#include "../h/fl.h"
#include "../h/param.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/mtpr.h"
#include "../h/buf.h"
#include "../h/cons.h"

struct{
	short fl_state ; /* floppy open and busy flags - for exclusivity*/
	short fl_active; /* floppy driver state flag */
	struct buf *fl_buf; /* buffer we're using */
	char *fl_xaddr; /* transfer address */
	short fl_errcnt;
} flptab;

flpopen(dev,flag)
dev_t dev;
int flag;
{
struct buf *geteblk();


	/* raw floppy open */
	if(flptab.fl_state != 0)
		u.u_error = ENXIO;
		/* only one customer at a time */
	else{
		flptab.fl_state = FL_OPEN;
		flptab.fl_buf = geteblk();
		flptab.fl_active = FL_IDLE;
	}
}

flpclose(dev,flag)
dev_t dev;
int flag;
{	/* raw floppy close */
	brelse( flptab.fl_buf);
	flptab.fl_state = 0;
}



flpstrategy( rw )
int rw; /* read -write flag */
{
	register struct buf *bp;
	register int i;

	/* I assume one block read/written for each call - 
	and enforce this by checking for block size of 128.
	I am going to use the b_blkno field to address
	physical, 128-byte blocks - that is (u.u_offset/128).
	This is checked for validity, and is further interpreted as:
			track# * (sectors/track) + sector #
	*/

	if (u.u_count == 0 ) 
		return;
	spl4();
	while ( flptab.fl_state & FL_BUSY)
		sleep((caddr_t) &flptab, PRIBIO);
	flptab.fl_state |= FL_BUSY;
	spl0();

	bp = flptab.fl_buf;
	while(( i = min(RXBYSEC, u.u_count) ) > 0){
		bp->b_blkno = u.u_offset>>7;
		if(bp->b_blkno >= MAXSEC
		|| (u.u_offset & 0177) != 0){
			/* block number out of range */
			/* or offset in middle of block */
			u.u_error = ENXIO;
			break;	
		}
		if(rw == B_WRITE){
			iomove( bp->b_un.b_addr, i, B_WRITE);
			if(u.u_error != 0)
				break;
		}
		bp->b_flags = rw;
		spl4(); 
		flpstart();
		while((bp->b_flags & B_DONE ) == 0)
			sleep( (caddr_t) bp, PRIBIO);	
		spl0();
		if(bp->b_flags & B_ERROR){
			u.u_error = EIO;
			break;
		}
		if( rw == B_READ){
			iomove( bp->b_un.b_addr, i, B_READ);
			if(u.u_error != 0)
				break;
		}
	}
	u.u_count = bp->b_resid;
	flptab.fl_state &= ~FL_BUSY;
	wakeup( (caddr_t) &flptab);
}


flpread(dev)
dev_t dev;
{	/* raw floppy read */
	flpstrategy( B_READ);
}

flpwrite(dev)
dev_t dev;
{	/* raw floppy write */
	flpstrategy( B_WRITE);
}

flpstart()
{
	register struct buf *bp;

	bp = flptab.fl_buf;
	flptab.fl_active = FL_MAND;
	flptab.fl_errcnt = 0;
	flptab.fl_xaddr = bp->b_un.b_addr;
	bp->b_resid = 0;
	bp->b_bcount = RXBYSEC; /* always transfer a full sector */

	if((mfpr(TXCS) & TXCS_RDY ) == 0)
		return;/* not ready to receive order */
	/* wake up floppy LSI software with command */
	flptab.fl_active = FL_SEC;
	if((bp->b_flags&B_READ)==B_READ){
		mtpr(TXDB,FL_RS);
	}
	else{
		mtpr(TXDB,FL_WS);
	}
}

conxflp()
{	/* See if we want to transmit something to the floppy - and do it */
	register int databyte;
	register struct buf *bp;

	bp = flptab.fl_buf;
	switch( flptab.fl_active ){ /* what state is the transaction in? */

	case FL_MAND: /* send command */
		if((bp->b_flags&B_READ)==B_READ)
		{
			mtpr(TXDB,FL_RS);
		}
		else
		{
			mtpr(TXDB,FL_WS);
		}
		flptab.fl_active =FL_SEC;
		break;
	case FL_SEC: /* send sector address */
		databyte = (int)bp->b_blkno%RXSTRK + 1;
		mtpr(TXDB,FL_DATA | databyte);
		flptab.fl_active =FL_TRACK;
		break;
	case FL_TRACK: /* send track address */
		databyte = (int)bp->b_blkno/RXSTRK;
		mtpr(TXDB,FL_DATA |databyte);
		if((bp->b_flags&B_READ)==B_READ)
			flptab.fl_active=FL_COM; /*prepare to receive complete */
		else
			flptab.fl_active=FL_DAX; /*prepare to send data */
		break;
	case FL_DAX:
		databyte= *(flptab.fl_xaddr++) ;/* have a datum */
		mtpr( TXDB,FL_DATA | databyte);
		if( --bp->b_bcount==0)
			flptab.fl_active=FL_COM;/*finish transmission */
		break;
	case FL_CAN: /* give cancel order */
		mtpr(TXDB, FL_CANCEL);
		if(++flptab.fl_errcnt <= FLERRS){
			/* If error count permits, retry order */
			flptab.fl_active=FL_MAND;
			bp->b_bcount = RXBYSEC;
			flptab.fl_xaddr = bp->b_un.b_addr;
		}
		else{ /* we're really stupid today - call it an error and
			give up */
			bp->b_flags |= B_ERROR | B_DONE;
			bp->b_resid = -RXBYSEC;
			flptab.fl_active=FL_IDLE;
			wakeup( bp);
		}
	}
}

consrflp(c)
int c;
{
	register int datum;
	register struct buf *bp;

	datum = c;
	bp = flptab.fl_buf;
	if( datum == FL_PERR){
		/* Shit - go a protocol error - so cancel the
		current function and try again - if error count isn't
		too great */
		/*First, though, make sure that an actual transaction
		is in progress (so a spurious error from the LSI won't
		screw us up too much !*/
		if(flptab.fl_active != FL_IDLE)
		{
			flptab.fl_active = FL_CAN;
		}
	}
	else
		switch( flptab.fl_active ){
		case FL_DAR: /* expecting a datum */
			if((c&RXDB_ID) != FL_DATA)
			{
				goto floppyerror; /*oops - didn't get one*/
			}
			*(flptab.fl_xaddr++) = (char) (c & RXDB_DATA);
			if(--bp->b_bcount==0){ /* end of read */
				flptab.fl_active = FL_IDLE;
				bp->b_flags |= B_DONE;
				wakeup( (caddr_t) bp );
			}
			break;
		case FL_COM: /* expecting a "function complete" */
			if((c&RXDB_ID)!= FL_FFC /*got something else */
			|| (c&FL_ERR) == FL_ERR){/*got one, but error bit set*/
	floppyerror:		bp->b_flags |= B_ERROR | B_DONE;
				bp->b_resid = -bp->b_bcount;
				flptab.fl_active=FL_IDLE;
				wakeup( (caddr_t) bp);
			}
			else if((bp->b_flags&B_READ) == B_READ){
			      /* got function complete, now get data */
			      flptab.fl_active = FL_DAR;
			}
			else{ /* got function complete on write - finish up */
			      flptab.fl_active = FL_IDLE;
				bp->b_flags |= B_DONE;
				wakeup( (caddr_t) bp);
			   }/* end if if READ else{...} */
		}/*end of switch */
}
