#
/*// pass two for the 8080 assembler */

#include "8080asm.h"

int p2gi();

extern char tfilname[];	/*//name of it file */
extern int instrlen[];	/*//length of each instruction format */
extern char initfnam[];	/*//name of the initilization file */
char ins[3];			/*//holds instructions bytes */
int lsb;				/*//least significant bit */
int mlflg;				/*//1=> sub loctr from operand */
int msb;				/*//most significant bit */
int opix;				/*//index thru operands */
int tpix;				/*//temp index */
int bufpt;				/*//index thru output buffer */
int ypix;				/*//temp index */
int pline;				/*//number of last printed line */
int addr;				/*//address of binary */
int obix;				/*//binary file buffer index */
int ftudp;				/*//first time thru undefined symbol */
int udfct;				/*//undefined symbol temp */
int bufix;				/*//binary file buffer index */
int brkln2 077777;		/*//pass 2 break line number for debugging */

char hexchar[] {'0','1','2','3','4','5','6','7','8','9',
				'a','b','c','d','e','f'};

# define BBL 16
char bibuff[BBL];		/*//binary file output buffer */


/*//pass two driver */
pass2()
{

	register (*dirop)(),i;	/*//temp */

	itix = ITBSZ;		/*//it buffer is empty */
	loctr = 0;			/*//location counter */
	rlflg = 1;			/*//relocatable */
	p2flg = 1;			/*//pass two */
	bufpt = 0;			/*//output buffer is empty */
	seek(ifn,0,0);		/*//beginning of source */
	close(itfn);
	itfn = openfi(tfilname,0);	/*//open it for reading */
	pline = 0;			/*//no lines printed */
	fchr=gchr();		/*//get first char */

/*// pass two main loop */

	while(1) {
		ristb();		/*//read it for one statement */
		absln = stbuf[0].itop;	/*//line number */
		if(absln>=brkln2)		/*//for debugging the assembler */
			i=0;
		opcpt = stbuf[2].itop;	/*//pointer to opcode entry in man tab */
		if(opcpt->flags&OPDR) {	/*//opcode is a directive */
			dirop = opcpt->vl2;	/*//address of pass two routine */
			(*dirop)();			/*//handle directive */
		}
		else {
			gcist();			/*//generate code for one statement */
		}
	}
}
/*// second pass end statement */
send()
{

	ival = 0;
	if(stbuf[0].itrl > 3) {		/*//label on end statement */
		opix = 3;				/*//set up params for expr */
		nite = stbuf[0].itrl;
		expr(&p2gi);
		if(itype!=ITCN) {
			uerr(13);			/*//undefined label */
			ival = 0;
		}
		if(ckeop(9)){			/*//check end of operand */
			ival = 0;
		}
	}
	wrbin(2,ival);				/*//output end block */
	print(-1);
	osymt();						/*//output undefined symbols */
	biflush();

	endit();			/*//end */
}


/*//second pass bss */
sds()
{

	print(0);					/*//print address only */
	loctr =+ stbuf[3].itop;		/*//reserve storage */
	wrbin(1,loctr);				/*//put on binary file */
}

/*// second pass org */
sorg()
{

	loctr = stbuf[3].itop;		/*//new location counter */
	print(0);
	rlflg = 0;					/*//abslute */
	wrbin(1,loctr);
}


/*//second pass define data (words or bytes) */
/*// call with */
/*//	0 => defining words */
/*//	1 => defining bytes */
sdata(dtyp)
{

	register pfg;

	pfg=0;
	opix=3;		/*//beginning of operand */
	nite=stbuf[0].itrl;		/*// number of operands */
	while(1) {
		expr(&p2gi);			/*//evaluate expression */
		if(itype!=ITCN) {			/*//must be constant */
			uerr(13);
			ival=0;
		}
		if(dtyp) {
			if(ckfcl(256)==0) {		/*//not a byte */
				uerr(20);
				ival=0;
			}
			if(pfg==0) {			/*//first byte of data */
				pfg++;
				ins[0] = ival;
				format=0;
				print(1);			/*//print first byte */
			}
			wrbin(0,ival);			/*//output one byte */
			loctr =+ 1;
		}
		else {
			if(pfg==0) {	/*//print first word of data */
				pfg++;
				ins[0] = ival.hibyte;
				ins[1] = ival.lobyte;
				format = 5;				/*//two bytes */
				print(1);
			}
			wrbin(0,ival.lobyte);
			wrbin(0,ival.hibyte);
			loctr =+ 2;
		}
		ckeop(15);	/*//should be end of operand */
		if(ckein())		/*//if end of operands */
			return;
	}
}

/*//define word statement */
sdw()
{
	sdata(0);	/*//defining words */
}

/*//define byte statement */
sdb()
{
	sdata(3);	/*//defining bytes */
}

/*// generate code for an instruction */
/*//  call with */
/*//		intermediate text for instruction in stbuf */

gcist()
{

	register svrl,i;

	if(stbuf[0].itty != ITBS)	/*//beginning of statement */
		abort();
	nite = stbuf[0].itrl;		/*//number of it entries */
	format = (opcpt->flags)&OPFF;
	ins[0] = opcpt->vl1;		/*//opcode value */
	opix = 3;
	if(nite>3) {					/*//operands */
		switch(format) {		/*//type of instruction */

		case OPF0:		/*//one byte no operands ie CMC, STC */
			ckeop(9);
			break;

		case OPF1:	/*//one byte dst in 3-5 [src in 0-2] ie INR, MOV */
			opf1();
			break;

		case OPF2:	/*//one byte reg pair in 4 ie LDAX */
			opf2();
			break;

		case OPF3:	/*//one byte reg in 0-2 ie ADD */
			opf3();
			break;
		case OPF4:	/*//one byte reg pair in 4-5 ie POP */
			opf4();
			break;

		case OPF5:	/*//two bytes reg pair, data ie MVI */
			opf5();
			break;

		case OPF6:	/*//two bytes reg, data it LXI */
			opf6();
			break;

		case OPF7:	/*//three bytes ie LDA */
			opf7();
			break;

		case OPF8:	/*//two bytes  data  ie ADI */
			opf8();
			break;

		default:
			abort();
		}
	}

	print(1);		/*//print source maybe */
	loctr =+ instrlen[format];
	for(i=0; i<instrlen[format]; i++) {
		wrbin(0,ins[i]);
	}
}

/*//one byte instruction */
/*//	dst in 3-5 */
/*//	optional src in 0-2 */

opf1()
{

	expr(&p2gi);	/*//get dst */
	if(ckfcl(8)==0)	/*//invalid reg */
		uerr(9);
	ckeop(9);
	ins[0] =|  ival<<3;		/*//put in instruction */
	if(ckein()==0) {
		expr(&p2gi);
		if(ckfcl(8)==0)		/*//invalid reg */
			uerr(10);
		ckeop(10);
		if(ckein()==0)		/*//not end of instruction */
			uerr(11);
		ins[0] =| ival;		/*//put in src */
	}
}

/*// format 2 */
/*//	one byte instruction with reg pair in 4  ie LDAX */

opf2()
{

	expr(&p2gi);		/*//get reg pair */
	if(ckfcl(4)==0 || (ival&1))		/*//invalid reg pair */
		uerr(9);				/*//invalid first operand */
	ckeop(9);			/*//end of operand */
	ins[0] =| (ival&02)<<3;		/*//put in instr */
	if(ckein()==0)		/*//should be end of instr */
		uerr(10);
}

/*// format 3 */
/*// one byte instruction reg in 0-2 ie ADD */

opf3()
{

	expr(&p2gi);		/*//get reg */
	if(ckfcl(8)==0)		/*//invalid reg */
		uerr(9);
	ckeop(9);
	ins[0] =| ival;		/*//put reg in instr */
	if(ckein()==0)		/*//should be end of instr */
		uerr(10);
}

/*// format 4 */
/*//	one byte instruction reg pair in 4-5 ie POP */

opf4()
{

	expr(&p2gi);		/*//get reg pair */
	if(ckfcl(8)==0 || (ival&1))		/*//invalid reg pair */
		uerr(9);
	ckeop(9);
	ins[0] =| (ival&06)<<3;			/*//put int instr */
	if(ckein()==0)		/*//should be end of instr */
		uerr(10);
}

/*// format 5 */
/*//  three byte instr  */
/*//		reg pair in 4-5 */
/*//		16 bits of data */
/*//			ie LXI */

opf5()
{

	expr(&p2gi);		/*//get reg */
	if(ckfcl(8)==0 || (ival&1))		/*//invalid reg pair */
		uerr(9);
	ckeop(9);
	ins[0] =| ival<<3;	/*//put in reg */
	if(ckein()) {		/*//end of instr */
		uerr(10);		/*//need another operand */
		return;
	}
	opf7();				/*//get 16 bit data */
}

/*// format 6 */
/*//  two bytes reg,data  ie MVI */

opf6()
{

	expr(&p2gi);		/*//register */
	if(ckfcl(8)==0)
		uerr(14);
	ckeop(9);
	ins[0] =| ival<<3;	/*//put in register number */
	if(ckein())			/*//shouldnt be end */
		uerr(10);
	else
		opf8();				/*//share opf8 code for data byte */
}


/*// format 8 */
/*//	two bytes  data goes in second byte  ie ADI */
opf8()
{

	expr(&p2gi);		/*//data byte */
	if(ckfcl(0400)==0)	/*//must fit in byte */
		uerr(15);
	ckeop(9);
	ins[1] = ival;
	if(ckein()==0)		/*//should be end */
		uerr(10);
}

/*//format 7 */
/*//  three bytes */
/*//		data in next two bytes */

opf7()
{

	expr(&p2gi);		/*// 16 bit constant */
	if(itype!=ITCN)		/*//not constant */
		uerr(10);
	ins[1] = ival.lobyte;	/*//put in instr */
	ins[2] = ival.hibyte;
	if(ckein()==0)
		uerr(10);
}

/*// check for special character */
/*//	call with: */
/*//		character to check for */
/*//		it type in itype */
/*//		it value in ival */

/*//	returns: */
/*//		0 => not the character */
/*//		1 => is  the character */

ckfss(ckch)
{

	if(itype!=ITSP || ival!=ckch)
		return(0);
	return(1);
}

/*//check for constant greater than 0 and less than the given limit */
/*//	call with: */
/*//		limit to check against */
/*//		it type in itype */
/*//		it value in ival */
/*//	returns: */
/*//		0 => not constant or outside limits */
/*//		1 => constant within limits */

ckfcl(cklm)
{

	if(itype!=ITCN || (ival<0 || ival>=cklm))
		return(0);
	return(1);
}

/*// check intermedate text item for special character */
/*//	call with: */
/*//		pointer to desired item in stbuf */
/*//		character to check for */
/*//	returns: */
/*//		0 => no match */
/*//		1 => match */

ckitc(ckpt,cksc)
{

	if(stbuf[ckpt].itty != ITSP || stbuf[ckpt].itop != cksc)
		return(0);
	return(1);
}

/*// read intermediate text for one statement */
/*// returns: */
/*//	intermediate text in stbuf */

ristb()
{

	register riix;

	stbuf[0].wd1 = riit();		/*//first word of it */
	stbuf[0].wd2 = riit();
	if(stbuf[0].itty != ITBS)	/*//best be beginning of statement */
		abort();

/*// get the rest of the statement it */
	for(riix=1; riix<stbuf[0].itrl; riix++) {
		stbuf[riix].wd1 = riit();
		stbuf[riix].wd2 = riit();
	}
}

/*// read in intermediate text */
/*//	returns: */
/*//		one word of intermediate text */

riit()
{

	if(itix > ITBSZ-1) {		/*//need new buffer of it */
		iitcnt++;				/*//count it buffers read */
		itix = 0;
		if(read(itfn,itbuf,ITBSZ*2)<=0) {
			printf("read error on it file\n");
			abort();
		}
	}
	return(itbuf[itix++]);
}


/*// check for end of operand */
/*// call with */
/*//		error number if this is not end of operand */

ckeop(uen)
{

	register cketp;

	if(opix>=nite)		/*//end of all operands */
		return(1);
	cketp = opix;
	do {
		cketp--;
	} while(stbuf[cketp].wd1==ITIGN);	/*//ignore this item */
	if(ckitc(cketp, ',')==0) {		/*//not end of stmt must be op,op */
		uerr(uen);
		return(0);
	}
	return(1);
}

/*//check for end of statement */
/*//	returns */
/*//		0 if not end of statement */
/*//		1 if end of statement */

ckein()
{

	if(opix>=nite)
		return(1);
	return(0);
}


/*// output symbol table to file */

osymt()
{

	register sx1,sx2;

/*// loop thru symbol initial reference table */
	for(sx1=0; sx1<63; sx1 =+ 2) {
		if(sirt[sx1+1]==0)		/*// this chain is empty */
			continue;

/*//output symbols on chain */
		sx2 = sirt[sx1+1];	/*//first entry on this chain */
		while(1) {
			osyme(sx2);			/*//output one symbol */
			if(sx2==sirt[sx1])	/*//end of chain */
				break;
			sx2 = sx2->tlnk;	/*//next entry in chain */
		}
	}
}


/*// output symbols in a form to be read by a debugger */
/*// call with pointer to symbol table entry */
/*// prints all undefined symbols */

osyme(aosypt)
{
	register struct symtab *osypt;
	register int *p1, i;

	osypt = aosypt;		/*//pointer to symbol table entry */
	if((osypt->flags&SYDF) == 0) {	/*//undefined symbol */
		pudfs(osypt);				/*//print undefined */
		return;
	}

	if(bfn==0)			/*//no output file */
		return;

	if((osypt->flags)&SYEQ)		/*//dont output equates */
		return;

	p1 = &(osypt->name[0]);
	for(i=0; i<4; i++)		/*//output symbol name */
		bwdout(*p1++);

	bwdout(osypt->vl1);		/*//output symbol value */
	scnt++;
}

/*// output full word to the binary file */
/*// call with word to output */
/*// characters are output left to right */

bwdout(wdii)
{
	bchout(wdii.hibyte);	/*//output left byte */
	bchout(wdii.lobyte);
}

/*// output one byte to the binary file */
/*//	call with: */
/*//		byte to output */
bchout(chii)
{

	if(obix>IOBSZ-1) {			/*//no room in buffer */
		if(write(bfn,iobuf,IOBSZ) != IOBSZ) {
			printf("I/O write error on binary output file\n");
			endit();
		}
		obix = 0;
	}

	iobuf[obix++] = chii;		/*//put output byte in buffer */
}

/*//flush the binary file buffer at end of assembly */
biflush()
{

	if(obix)
		if(write(bfn,iobuf,obix) != obix)
			printf("** I/O error on binary output file\n");
}


/*// output a byte as two hex ascii characters to the binary file */
/*//	call with: */
/*//		binary byte of data */

bouthex(bdata)
{

	register bi;

	bi = bdata;
	bchout(hexchar[(bi&0360)>>4]);	/*//first hex char out */
	bchout(hexchar[bi&017]);
}


/*// print undefined symbols */
/*// call with */
/*//	pointer to undefined symbol */

pudfs(udspt)
struct symtab *udspt;
{

	if(ftudp==0) {		/*//first time thru */
		printf("\n** UNDEFINED SYMBOLS **\n");
		ftudp++;
		udfct=0;		/*//no symbols on this line */
	}

	printf("%.8s  ",&(udspt->name[0]));
	if(udfct++ > 6) {
		printf("\n");
		udfct=0;
	}
}

/*// write file for binary loader */
/*// call with */
/*//	load code */
/*//		0 => sequential data byte */
/*//		1 => new address from org */
/*//		2 => end */

/*// data word */
/*//		0 => data byte */
/*//		1 => new address */
/*//		2 => program starting address or 0 */

wrbin(bilc, bidata)
{


	if(bfn==0)				/*//no output file */
		return;

	switch(bilc) {			/*//switch on load code */

	case 0:					/*//data is sequential data byte */
		bibuff[bufpt++] = bidata;		/*//put byte in buffer */
		if(bufpt>=BBL) {			/*// buffer is full */
			outbin();			/*// write header, data, checksum */
		}
		return;

	case 1:					/*// new address from org */
		if(bufpt) {			/*//something in buffer */
			outbin();	/*//write partial buffer */
		}
		addr = bidata;		/*//new address */
		return;

	case 2:					/*//end */
		if(bufpt) {			/*//something in buffer */
			outbin();
		}
		bchout(':');		/*//output last record */
		bchout('0');
		bchout('0');		/*//record length of zero->end */
		bouthex(bidata.lobyte);	/*//output starting address */
		bouthex(bidata.hibyte);
		bchout('\n');
		return;

	default:
		abort();
	}
}

/*// build one binary loader block */
/*//	call with: */
/*//		data in bibuff */
/*//		# bytes in bibuff as argument */

outbin()
{

	register i;
	char cksum;

	bchout(':');			/*//beginning of record */
	bouthex(bufpt);			/*//record length */
	cksum = bufpt;
	bouthex(addr.hibyte);	/*//first half of address of first byte */
	cksum =+ addr.hibyte;
	bouthex(addr.lobyte);
	cksum =+ addr.lobyte;
	bchout('0');				/*//record type */
	bchout('0');
	for(i=0; i<bufpt; i++) {	/*//put in data bytes in ascii */
		cksum =+ bibuff[i];		/*//compute checksum */
		bouthex(bibuff[i]);		/*//output as two hex chars in ascii */
	}

	bouthex(-cksum);
	bchout('\n');				/*//record separator */

	addr =+ bufpt;				/*//next sequential address */
	bufpt = 0;					/*//buffer is empty */
}

/*// output source and object listing */
/*//	call with */
/*//		1 => object in ins[] and instr type in format */
/*//		0 => print address only */
/*//		-1 => print to end of source */

print(pflag)
{

	register i,j;

	if(prtflg == 0) return;		/*//no printing desired */
	if(fchr==EOF)	return;		/*//end of sorce file */

	while(pline<absln-1 || pflag == -1) {	/*//need to print some lines */
		printf("            ");			/*//align the source */
		while(fchr != EOLC) {			/*//print one line */
			putchar(fchr);
			fchr = gchr();				/*//get next char */
			if(fchr==EOF) return;		/*//end of source */
		}
		pline++;
		putchar('\n');					/*//end of line */
		fchr = gchr();
		if(fchr==EOF) return;			/*//end of source */
	}

/*// output current address binary and sorce */
	printf("%-4x ", loctr);				/*//current address */
	if(pflag==0) {			/*//no binary */
		printf("       ");	/*//blanks instead */
	}
	else {
		for(i=0; i<instrlen[format]; i++) {	/*// binary */
			j = ins[i];
			j =& 0377;			/*//clear upper byte */
			if(j==0)
				printf("00");
			else
				if(j<=017)
					printf("%2.1x",j);
				else
					printf("%x",j);
		}
		putchar(' ');
		for(;i<3;i++) {
			printf("  ");		/*//align the source */
		}
	}
	if(pline>=absln)			/*//already printed source */
		putchar('\n');			/*//end of line */
	else {
		while(fchr != EOLC) {
			putchar(fchr);
			fchr=gchr();
			if(fchr==EOF) return;
		}
		putchar('\n');
		fchr=gchr();
		pline++;
	}
}
