/*
 *	rxcopy.c
 *	Program to perform block copy from floppy disc to floppy disc
 *	Peter Collinson
 * 	26/May/77
 */

char irx[]	"/dev/rx0";
char orx[]	"/dev/rx1";

char rderr[]	"Read error, device %s, block %d\n";

int ifd;
int ofd;

struct bufs
{	int 	b[256];
} buf[10];

struct bufs obuf[10];


main(argc, argv)
int argc; char **argv;
{
	char id, od;

	if(argc > 1)
	{	if(argc != 3)
		{	printf("Not enough arguments\n");
			exit();
		}

		id = argv[1][0];
		od = argv[2][0];

		if((id == '0' && od == '1') || (id == '1' && od == '0'))
		{	irx[7] = id;
			orx[7] = od;
		}

		else
		{	printf("Illegal device numbering\n");
			exit();
		}
	}
	printf("Copying from /dev/rx%c to /dev/rx%c: ", irx[7], orx[7]);
	read(1, &buf, 256);
	if((buf[0].b[0]&0377) != 'y') exit();

	if(((ifd = open(irx, 0)) < 0) || ((ofd = open(orx, 2)) < 0))
	{	printf("Cannot open: %s\n", (ifd<0)? irx: orx);
		exit();
	}


	copy();
	verify();
	exit();
}

copy()
{	register int blk, j, k;
	int i;

	printf("***Starting copy***\n");

	/* all these loops are to maximise access speed to rx discs */
	for(i = 0; i <= 9; i++)
	{	for(j = 0; j <= 400; j=+ 100)
		{	for(k = 0; k<= 9; k++)
			{	blk = j + k*10 +i;
				seek(ifd, blk, 3);
				if(read(ifd, &buf[k], 512) <= 0)
				{	printf(rderr, irx, blk);
					exit();
				}
			}
			for(k = 0; k <= 9; k++)
			{	blk = j +k*10 + i;
				seek(ofd, blk, 3);
				if(write(ofd, &buf[k], 512) <= 0)
				{	printf("Write error device %s block %d\n", orx, blk);
					exit();
				}
			}
		}
		printf("%d blocks read and written\n",i*50+50);
	}
}

verify()
{	register int blk, j, k;
	int i;

	printf("***Starting verification***\n");
	for(i = 0; i <= 9; i++)
	{	for(j = 0; j <= 400; j =+ 100)
		{	for(k = 0; k <= 9; k++)
			{	blk = j + i + k*10;
				seek(ifd, blk, 3);
				if(read(ifd, &buf[k], 512) <= 0)
				{	printf(rderr, irx, blk);
					exit();
				}
			}
			for(k = 0; k <= 9; k++)
			{	blk = j + k*10 + i;
				seek(ofd, blk, 3);
				if(read(ofd, &obuf[k], 512) <= 0)
				{	printf(rderr, orx, blk);
					exit();
				}
			}
			comp(i + j);
		}
		printf("%d blocks compared\n", i*50+50);
	}
}


comp(base)
int base;
{	register int *i, *o, ict;
	int blk,tenct;
	for(tenct = 0; tenct <= 9; tenct++)
	{	blk = base + tenct*10;
		i = &buf[tenct];
		o = &obuf[tenct];

		for(ict = 0; ict < 256; ict++)
			if(*i++ != *o++)
				printf("Compare failure block %d, word %o\n", blk, ict);
	}
}
