/**			for sdb'ing, include this define
#define fork() 0
**/
/*
 *		Line printer daemon
 *
 *	From the V6 Bell version,
 *	modified by:
 *		Kenj McDonell
 *		Ross Green
 *		Joseph Longo
 *	and rewritten by
 *		Robert Elz
 *				all from Comp Sci, Melb Uni
 *
 *	This file contains the output scheduler basically,
 *	ie: the part that decides what should get printed next
 */

#include "local.h"
#include <stdio.h>
#include <signal.h>
#ifdef	TTY
#include <sgtty.h>
#endif
#ifdef	LPR
#include "la.h"
#endif
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include "spool.h"
#define	XTRN
#include "globals.h"

main(argc,argv)
int	argc;
char	**argv;
{
	PR pr;
	register found, dev, i;
	int fd, flag;

	extern	int	catch(),
			newjob(),
			newpr(),
			merge();


	setgid(0);
	setuid(0);
	umask(0);

	/* Ignore quit, interrupt, hangup */
	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(CSIG, SIG_IGN);
	signal(NEW, SIG_IGN);
	signal(MERGE, SIG_IGN);
	signal(SIGTERM, SIG_IGN);

#ifdef	LOCK
	if ((lockf = open(LPDLOCK, 0)) < 0) {
#else
	if (access(LOCKFILE, 0) >= 0) {
#endif
		fd = open(LOCKFILE, 0);
		if (fd < 0)
			exit(0);
		i = read(fd, &pid, sizeof pid);
		if (i != sizeof pid || pid == 0)
			exit(0);
		if (kill(pid, NEW) < 0)
			printf("Lpd: printer locked\n");
		exit(0);
	}
	fd = creat(LOCKFILE, 0444);
	flag = fork();
	if (flag == -1) {
		unlink(LOCKFILE);
#ifdef	LOCK
		close(lockf);
#endif
		printf("Lpd: Can't fork\n");
		exit(0);
	}
	if (flag != 0)
		exit(0);	/* Normal exit from 'opr' */

	/* Now we are really 'lpd' - get on with it */
	pid = getpid();
	write(fd, &pid, sizeof pid);
	close(fd);

	for (i = 0; i < NOFILE; i++)
#ifdef	LOCK
		if (i != lockf)
#endif
			close(i);

	fclose(stdin);		/* keep stdio in sync */
	fclose(stdout);
	fclose(stderr);

	if ((dfd = fopen(lpd, "r")) == NULL)
		err_exit("Can't open SPOOLDIR");
	if ((dfd2 = fopen(lpd, "r")) == NULL)
		err_exit("Impossible SPOOLDIR open failure");
	if (chdir(lpd) < 0)
		err_exit("Can't chdir to SPOOLDIR");
	if ((jfd = creat(jobf, 0644)) < 0)
		err_exit("Can't make job file\n");

	setjmp(redo);
	merge();
	signal(MERGE, newpr);

	signal(CSIG, catch);

	setjmp(env);

	for (ever) {
		morejobs = 0;
		waiting = 0;
		signal(NEW, newjob);
		for (printers) {

			if (pr->comm == '-')
				continue;
			if (pr->ppid != 0)
				continue;
			if (devbusy(pr))
				continue;
			if (findfile(pr))
				tryspool(pr);
		}

		if (children == 0)
			done();
		if (! morejobs)
			await();
	}
}

await()
{
	PR pr;
	extern int newjob();

	while (term <= 0) {
		if (children >= maxchild)
			signal(NEW, SIG_IGN);
		waiting++;
		if (morejobs)
			return;
		term = wait(&status);
	}
	signal(NEW, SIG_IGN);
	waiting = 0;

	for (printers) {
		if (pr->ppid == term) {
			pr->opts |= ONEDONE;
			pr->ppid = 0;
			term = 0;
			lseek(jfd, (long)(pr-prt)*sizeof(struct job), 0);
			write(jfd, &job, sizeof job);
			children --;
			if (xitreason(status) == 0 && xitcode(status) == PRBUSY) {
				pr->comm = '-';
				maxchild--;
			} else if (pr->comm == '-')
				maxchild--;
			return;
		}
	}
	/* a stray child, should we take him in, or just ignore him  ?? */

	term = 0;
	return;		/* treat it as an invitation to try anr printer */
}

findfile(pr)
PR pr;
{
	register long curpri = BIGNUM;		/* A very big number */
	register long n;
	long getpri();

	rewind(dfd);
	while (fread(&dir, sizeof dir, 1, dfd) == 1) {
		if ( breakup() )		/* not a 'df' file */
			continue;
		if ( printing() )
			continue;
		if ( !thispr(pr) )
			continue;
		n = getpri(pr);
		if ( n < curpri) {
			curpri = n;
			setup(pr);
		}
	}
	if (curpri == BIGNUM)
		return(0);

	return(1);
}

setup(pr)
PR pr;
{
	spoold = dir;		/* save the dir entry of cmd file we want */
	dojob = jobnum;
	STRCPN(ourdev, device);
}

breakup()
{
	register char *p;

	if (dir.d_ino == 0)
		return(1);

	if (dir.d_name[0] != 'd' || dir.d_name[1] != 'f')
		return(1);

	STRCPM(nbuf, dir.d_name);
	p = rindex(&nbuf[2], '.');
	if (p == NULL)
		return(1);
	strncpy(device, &nbuf[2], p - nbuf - 2);
	device[p - nbuf - 2] = '\0';
	p += 3;
	if (*p < '0' || *p > '9')
		return(1);
	jobnum = atoi(p);
	return(0);
}

printing()
{
	PR pr;

	for (printers) {
		if (pr->ppid != 0 && pr->pjob == jobnum)
			return(1);
	}
	return(0);
}

long
getpri(pr)
PR pr;
{
	long size = 0;
	time_t now;

#ifdef	SIZES
	rewind(dfd2);
	while (fread(&test, sizeof test, 1, dfd2) == 1) {
		if ( ! datafile(&test) )
			continue;
		if ( ! samejob(&test) )
			continue;
		STRCPN(nbuf, test.d_name);
		if (fstat(nbuf, &statb) < 0)
			continue;
		size += statb.st_size;
		if (pr->opts & BANNER)
			size += BANSIZ;
		if (pr->opts & BIGBAN)
			size += BIGBSIZ;
	}
#endif
	STRCPN(nbuf, dir.d_name);
	if (stat(nbuf, &statb) < 0)	/* only if just dumped */
		statb.st_mtime = 0;	/* make it very high pri - get rid of it */

	return(calcpri(statb.st_mtime, size, pr->pbias*devmatch));
}

devbusy(mpr)
PR mpr;
{
	PR pr;

	for (printers)
		if (pr->ppid != 0 && strcmp(mpr->prnm, pr->prnm) == 0)
			return(1);
	return(0);
}

datafile(d)
struct direct *d;
{
	if (d->d_ino == 0)
		return(0);
	if (d->d_name[1] != 'f' || d->d_name[0] != 'c' && d->d_name[0] != 'l')
		return(0);
	return(1);
}

samejob(d)
struct direct *d;
{
	char tbuf[DIRSIZ+1];
	char class[CLSIZE];
	int	jnum;

	STRCPM(tbuf, d->d_name);
	jnum = 0;
	if ( sscanf( tbuf, "%*cf%[^.].%*c%*c%d", class, &jnum) < 1 )
		return(0);

	if (jnum == 0)
		return(0);

	if (strcmp(class, ourdev) != 0)
		return(0);

	if (jnum != jobnum)
		return(0);

	return(1);
}


err_exit(s)
char *s;
{
	register FILE *fd;

	if ((fd = fopen("/dev/console", "w")) != NULL) {
		fprintf(fd, "Lpd: err_exit %s\r\n", s);
	}

	done();
}

done()
{
	unlink(LOCKFILE);
	exit(0);
}
