/*
 * Melb Uni Comp Sci
 *
 *	LPD
 *
 *	here a child comes in the first moments after birth
 *	we clean up a bit, the climb into the mud where the real fun is
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <setjmp.h>
#ifdef	vax
#include <execargs.h>
#endif
#include <signal.h>
#include "local.h"
#include "spool.h"
#include "globals.h"
#ifdef	TTY
#include <sgtty.h>
#endif
#ifdef	LPR
#include "la.h"
#endif

char *dolv[] = {
	"Lpd",
	ourdev,
	0
};

tryspool(pr)
PR pr;
{
	register i;
	char pname[DIRSIZ+6];	/* one path segment + "/dev/" */
	int childcatch();

	i = fork();
	if (i == -1)
		return;

	pr->ppid = i;
	pr->pjob = dojob;
	children++;

	if (i != 0)
		return;		/* parent can now go on to next printer */

	child++;
	signal(CSIG, childcatch);
#ifdef	vax
	*execargs = (char *)dolv;
#endif
	mypr = pr;
	jobnum = pr->pjob;
	fclose(dfd);

	strcpy(pname, "/dev/");
	strcat(pname, pr->prnm);

	if ((op = fopen(pname, "w")) == NULL) { 	/* can't use printer */
		exit(PRBUSY);
	}
#ifdef	TTY
	ioctl(fileno(op), TIOCEXCL, 0);
#endif
#ifdef	LPR
	ioctl(fileno(op), LAFLUSH, 0);		/* clean out the drains */
#endif

	if ((pr->opts & ONEDONE) == 0)
	if (pr->prinit[0] != '\0' && (dfd = fopen(pr->prinit, "r")) != NULL) {
#ifdef	TTY
		if (pr->opts & PR_TTY) {
			struct sgttyb sg;
			ioctl(fileno(op), TIOCGETP, &sg);
			sg.sg_flags |= RAW;
			if (pr->speed)
				sg.sg_ispeed = sg.sg_ospeed = pr->speed;
			ioctl(fileno(op), TIOCSETP, &sg);
		}
#endif
#ifdef	LPR
		if (pr->opts & PR_LA) {
			struct la_iocb sg;
			ioctl(fileno(op), LAIOCGET, &sg);
			sg.la_flags |= F_RAW;
			if (pr->speed)
				sg.la_speed = pr->speed;
			ioctl(fileno(op), LAIOCSET, &sg);
		}
#endif
		while (( i = getc(dfd) ) != EOF)
			putc(i, op);
		fflush(op);
		fclose(dfd);
#ifdef	TTY
		if (pr->opts & PR_TTY) {
			struct sgttyb sg;
			ioctl(fileno(op), TIOCGETP, &sg);
			sg.sg_flags &= ~RAW;
			ioctl(fileno(op), TIOCSETP, &sg);
		}
#endif
#ifdef	LPR
		if (pr->opts & PR_LA) {
			struct la_iocb sg;
			ioctl(fileno(op), LADRAIN, 0);
			ioctl(fileno(op), LAIOCGET, &sg);
			sg.la_flags &= ~F_RAW;
			ioctl(fileno(op), LAIOCSET, &sg);
		}
#endif
	}

	STRCPM(nbuf, spoold.d_name);
	if (stat(nbuf, &statb) < 0) {	/* file has just been unlinked */
		unlink(nbuf);		/* can't work, but ... */
		exit(1);
	}
	setgid(statb.st_gid);
	setuid(statb.st_uid);		/* we are now the user that ran opr */

	job.jnum = pr->pjob;
	STRCPN(job.pname, pr->prnm);
	STRCPN(job.jclass, pr->class);
	lseek(jfd, (long)(pr-prt)*sizeof(struct job), 0);
	write(jfd, &job, sizeof job);
	close(jfd);

	i = fileno(op);
#ifdef	TTY
	if (pr->opts & PR_TTY) {
		struct sgttyb sg;
#ifdef	MELB_TTY
		struct sgttydel del;
#endif

		ioctl(i, TIOCFLUSH, 0);
		ioctl(i, TIOCGETP, &sg);
		sg.sg_flags = ANYP;
		if (pr->opts & NEEDCR)
			sg.sg_flags |= CRMOD;
		if (pr->speed)
			sg.sg_ispeed = sg.sg_ospeed = pr->speed;
		if ( !(pr->opts & USETABS) ) {
#ifdef	MELB_TTY
			ioctl(i, TIOCGDEL, &del);
			del.sg_tabdel = XTABS;
			ioctl(i, TIOCSDEL, &del);
#else
			sg.sg_flags |= XTABS;
#endif
		}
#ifdef	MELB_TTY
		if ( pr->opts & SIMFORM ) {
			ioctl(i, TIOCGDEL, &del);
			del.sg_ffdel = XFORM;
			ioctl(i, TIOCSDEL, &del);
		}
#endif
		ioctl(i, TIOCSETP, &sg);
	}
#endif
#ifdef	LPR
	if (pr->opts & PR_LA) {
		struct la_iocb sg;

		ioctl(i, LAIOCGET, &sg);
		sg.la_pages = 0;
		if (pr->speed)
			sg.la_speed = pr->speed;
		ioctl(i, LAIOCSET, &sg);
		ioctl(i, LAFLUSH, 0);
	}
#endif
	spool(nbuf);
	unlink(nbuf);

#ifdef	TTY
		/*
		 * this is to make sure chars don't get lost when
		 * the tty driver closes the line, - double buffered
		 * async interfaces tend to loose the last 1 or 2 chars
		 * in this case
		 * (It ought to be fixed in the system, not here)
		 */
	if (pr->opts & PR_TTY) {
		putc('\0', op);
		putc('\0', op);
	}
#endif

	fflush(op);
	acct(pr, 0);
	exit(0);
}
