#

/*
 *	syms.c
 */

#define	NTYPES	12

/*	syms:  Lists symbols in an object file or archive, sorted by type
 *		e.g. local/global/common and text/data bss.  This program
 *		is similar to "nm", but can accept archives as well as
 *		single object files.  It also has two extra flags (See
 *		"d" and "g" below.
 *
 *	usage:	syms [-cgudnr] filename ...
 *
 *	flags:	c:  list c-type globals only (those that begin with underscore
 *		g:  list global symbols only
 *		u:  list undefined symbols only
 *		d:  list defined symbols only
 *		n:  sort symbols alphabetically by name, rather than by value
 *		r:  sort in descending, rather than ascending order
 */

/*
 *	Modified by Bill Shannon   07/20/78
 *
 *	Fixed for new archive file format.
 *	Bugfix: close each file before processing next.
 *
 *	Modified by Sam Leffler	  5/7/80
 *	Rewritten for Version 7(PDP-11) & UNIX/24V
 */
#include	<a.out.h>
#include	<ar.h>
#include	<stdio.h>

char t_code[] { N_UNDF, N_ABS, N_TEXT, N_DATA, N_BSS,
		N_EXT, N_EXT|N_ABS, N_EXT|N_TEXT, N_EXT|N_DATA, 
		N_EXT|N_BSS, N_FN};

char *t_tag[] {	"Undefined Local",
		"Absolute Local",
		"Text Local",
		"Data Local",
		"Bss Local",
		"Undefined Global",
		"Absolute Global",
		"Text Global",
		"Data Global",
		"Bss Global",
		"Ld File",
		"Special",
		"Common"
		};
char *errmsg[] {"Bad flag ignored",
		"Unable to open",
		"Read error or bad length",
		"Not an object module or archive",
		"Symbol segment length incorrect"
		};
int fildes;
struct exec header;
struct ar_hdr arhdr;
unsigned magic;
int c_only = 0;
int by_name = 0;
int reverse = 1;
int u_only = 0;
int g_only = 0;
int d_only = 0;
struct node {
	char name[8];
	struct node *next;
	unsigned value;
};

main(argc,argv)
int argc;
char *argv[];
{	register int i,j;
	extern char *ctime();
	char c;
	for (i=1; i<argc; i++)
	{
		if (argv[i][0] == '-')
		{
			for (j=1; (c = argv[i][j++]) != '\0' ; )
			{
				switch(c)
				{
					case 'c': c_only++;
					case 'g': g_only++; break;
					case 'u': u_only++; break;
					case 'n': by_name++; break;
					case 'r': reverse = -1; break;
					case 'd': d_only = 1; break;
					default:  printf(errmsg[0]);
				}
			}
		} 
		else if ((fildes=open(argv[i],0)) < 0)
			error(1);
		else if (read(fildes,(char *)&magic,sizeof(magic)) != sizeof(magic))
			error(2);
		else if (magic == ARMAG)
		{
			printf("\nArchive file %s\n",argv[i]);
			while ((c = read(fildes,(char *)&arhdr,sizeof(arhdr))) > 0)
			{
				if (c != sizeof(arhdr)) {
					error(2);
					break;
				}
				printf("\nMember: %-14.14s\n", arhdr.ar_name);
				if (read(fildes,(char *)&header,sizeof(header)) != sizeof(header))
					error(2);
				else
					proces1();
			}
			close(fildes);
		}else{
			printf ("\n\n\nFile %s\n",argv[i]);
			lseek(fildes, 0L, 0);	/* reset for proces1 */
			if (read(fildes, (char *)&header,sizeof(header)) != sizeof(header)) {
				error(2);
				continue;
			}
			proces1();
			close(fildes);
		}
	}
}

proces1()
{
	struct {int integ;};
	int j, type, itype;
	struct node stype[NTYPES+1], proto;
	register int i;
	extern char *malloc();
	long off;
	register struct node *p, *q;

	if (header.a_magic == A_MAGIC1)
		printf("Non-sharable\n");
	else if (header.a_magic == A_MAGIC2)
		printf ("Sharable\n");
	else if (header.a_magic == A_MAGIC3)
		printf ("Split I/D\n");
	else if (header.a_magic == A_MAGIC4)
		printf("Overlay\n");
	else{
		error(3);
		return;
	}
	
	printf ("  Text: %-8uData: %-8uBss: %-8u (decimal bytes)\n",
		header.a_text, header.a_data, header.a_bss);
	printf ("  Text: %-8oData: %-8oBss: %-8o (octal bytes)\n",
		header.a_text, header.a_data, header.a_bss);
	off = (long)header.a_text+header.a_data;
	if (header.a_flag == 0)
		off *= 2;
	if (lseek(fildes, off, 1) < 0) {
		error(2);
		return;
	}
	if (header.a_syms%sizeof(struct nlist)) {
		error(4);
		return;
	}
	for (i=0; i<=NTYPES; i++)
		stype[i].next = 0;
	for (i = header.a_syms; (i =- sizeof(struct nlist)) >= 0; )
	{
		p = (struct node *)malloc(sizeof(struct node));
		if (read(fildes, (char *)p,sizeof(struct nlist)) != sizeof(struct nlist))
		{
			error(2);
			return;
		}
		type = (p->next).integ;
		for (itype=0; type != t_code[itype] && ++itype < 11; );
		if (itype==5 && (p->value != 0))
			itype = NTYPES; /* Common */
		if ((c_only && (p->name[0] != '_')) || (g_only && !(type&040)) ||
		    (d_only && ((itype == 0) || (itype == 5) || (itype == NTYPES))) ||
		    (u_only && (itype != 0) && (itype != 5)) )
			continue;
		else
			sortins(p,&(stype[itype]));
	}
	/*  Print output and free memory */
	for (i=0; i <= NTYPES; i++)
	{
		if (p = stype[i].next)
		{
			printf("\n%s Symbols...",t_tag[i]);
			do
			{
				printf("\n  ");
				for (j=4; j--; )
				{
					printf(" %8.8s %-6o",p->name,p->value);
					q = p->next;
					free(p);
					if ((p = q) == 0)
						break;
				}
			} while (p);
		}
	}
	putchar('\n');
}

sortins(p,q)
struct node *p, *q;
{
	struct node *r;
	while ((r = q->next) && (reverse * (by_name? strcmp(r->name, p->name) : (r->value) >= (p->value) )) <= 0)
		q = r;
	p->next = r;
	q->next = p;
}

error(i)
int i;
{
	printf("%s\n\n",errmsg[i]);
	lseek(fildes, 0L, 2); /* Skip rest of file */
}

strcmp(s1,t1)
char *s1, *t1;
{
	register int i;
	register char *s, *t;

	s = s1; t = t1;
	for (i=0; i++<8; )
		if (*s < *t)
			return(-1);
		else if (*s++ > *t++)
			return (1);
	return (0);
}
