# include "mfile2"
# define max(x,y) ((x)<(y)?(y):(x))
# define min(x,y) ((x)<(y)?(x):(y))
# define FLOATING(t)	((t) == FLOAT || (t) == DOUBLE)
# define CHARACTER(t)	((t) == CHAR || (t) == UCHAR)
int     fltused = 0;
int     radebug = 0;
int     crslab = 10000;
/*
 * should the assignment op p be stored,
 * given that it lies as the right operand of o
 * (or the left, if o==UNARY MUL)
 */
stoasg (p, o)
register NODE *p;
{
	return (shltype (p->left->op, p->left));
}
/*
 * should we delay the INCR or DECR operation p
 */
deltest (p)
register NODE *p;
{
	switch(p->type) {
		case (PTR+CHAR):
		case (PTR+UCHAR):
		case CHAR:
		case UCHAR:
		case LONG:
		case ULONG:
			return(0);
		default:
			if (p->op == FLD)
				return(0);
			return(canadrs(p->left));
	}
	/* NOTREACHED */
}
/*
 *	Make the node addressable, by placing making one unaddressable
 *	operand addressable.
 */
mkadrs (p)
register NODE *p;
{
	register        o;
	if (xdebug)
		xprint(p, INTEMP, "mkadrs");
	o = p->op;
	if (asgop (o)) {
		if ((p->left->su >= p->right->su) && p->left->op != FLD) {
			if (p->left->op == UNARY MUL) {
				if (p->left->su > 0)
					SETSTO (p->left->left, INTEMP);
				else {
					if (p->right->su > 0)
						SETSTO(p->right, INTEMP);
					else
						cerror ("store finds both sides trivial");
				}
			}
			else
				if (p->left->op == FLD && p->left->left->op == UNARY MUL) {
					SETSTO (p->left->left->left, INTEMP);
				}
				else {		 /* should be only structure assignment */
					SETSTO (p->left, INTEMP);
				}
		}
		else
			SETSTO (p->right, INTEMP);
	}
	else {
		if (p->left->su > p->right->su) {
			SETSTO (p->left, INTEMP);
		}
		else {
			SETSTO (p->right, INTEMP);
		}
	}
}
/*
 * is it legal to make an OREG or NAME entry which has an
 * offset of off, (from a register of r), if the
 * resulting thing had type t
 */
notoff (t, r, off, cp)
	TWORD	t;
	CONSZ	off;
	char   *cp;
{
	/*
	 * We can't allow OREG's to be formed for char refrences once the
	 * address has been placed into the i or j register, unless we are
	 * referring to something on the stack which is on a word boundary.
	 */
	if (CHARACTER(t))
		/*
		 * Check for word allignment, note that we have eliminated
		 * much of the work in the first pass by transforming
		 * all word aligned constant addresses into NAME nodes.
		 */
		if (*cp != '\0' || ((off+1)%3) != 0)
			return(1);		/* NO!!! */
	if (r == Ri || r == Rj || r == Rk)	/* index registers */
		return (0);			/* YES */
	return(1);				/* NO!!!! */
}
/*
 * zap Sethi-Ullman number for chars, longs, floats
 * in the case of longs, only STARNM's are zapped
 * ZCHAR, ZLONG, ZFLOAT are used to select the zapping
 */
zum (p)
register NODE *p;
{
	register        su;
	su = p->su;
	switch (p->type) {
		case CHAR:
		case UCHAR:
			if (su == 0)
				p->su = su = 1;
			break;
		case LONG:
		case ULONG:
			if (su == 0)
				p->su = su = 2;
			break;
		case FLOAT:
			if (su == 0)
				p->su = su = 2;
	}
	return (su);
}
/*
 * set the su field in the node to the sethi-ullman
 * number, or local equivalent
 */
sucomp (p)
register NODE *p;
{
	register        o,
	                ty,
	                sul,
	                sur;
	register        nr;
	register	lt,
			rt;
	ty = optype (o = p->op);
	nr = szty (p->type);
	p->su = 0;
	if (ty == LTYPE)
		return;
	else
		if (ty == UTYPE) {
			switch (o) {
				case UNARY CALL:
				case UNARY STCALL:
					/*
					 * This simulates the future expansion
					 * of the field node into a shift and
					 * mask, if we don't do it here we
					 * may not see it's impact till too
					 * late (i.e. op='s).
					 */
				case FLD:
					p->su = fregs;	/* all regs needed */
					return;
				case STARG:
					p->su = max(max(p->left->su, nr), 2);
					return;
				case SCONV:
					/*
					 * In case we must have the D register
					 * for a conversion guarantee it.
					 */
					lt = p->type, rt = p->left->type;
					if (lt == LONG || lt == ULONG || rt == LONG || rt == ULONG) {
						p->su = fregs;
						return;
					}
					/*
					 * When we convert a byte pointer to
					 * a non-pointer quantity show the
					 * difficulty.  However, leave a little
					 * leeway so we don't always cause a
					 * store.
					 */
					if (bptype(p->left->type))
						nr = fregs;
					goto norm;
				case UNARY MUL:
					if (shumul (p->left))
						return;
				default:
				norm:
					p->su = max (p->left->su, nr);
					return;
			}
		}
	/*
	 * If rhs needs n, lhs needs m, regular su computation
	 */
	sul = p->left->su;
	sur = p->right->su;
	lt = p->left->type;
	rt = p->right->type;
	if (o == ASSIGN) {
asop: 					 /* also used for +=, etc., to memory */
		if (sul != 0) {
			/*
			 * Perform the right op's, then the left
			 * address, finally store it.
			 */
			if (sur < 2)
				p->su = max(sul, nr);
			else
				p->su = max(sur, nr+sul);
		} else		/* don't need to worry about the left */
			p->su = max(sur, nr);
		return;
	}
	if (o == CALL || o == STCALL) {
		/*
		 * in effect, takes all free registers
		 */
		p->su = fregs;
		return;
	}
	if (o == STASG) {
		/*
		 *  right, then left
		 */
		p->su = max (max (sul + nr, sur), fregs);
		return;
	}
	if (logop (o)) {
		/*
		 * do the harder side, then the easier side, into registers
		 *	left then right, max(sul,sur+nr)
		 *	right then left, max(sur,sul+nr)
		 * to hold both sides in regs: nr+nr
		 */
		nr = szty (p->left->type);
		p->su = min (max (sul, sur + nr), max (sur, sul + nr));
		return;
	}
	if (asgop (o)) {
		/*
		 * computed by doing right, doing left address,
		 *  doing left, op, and store
		 */
		switch (o) {
			case ASG DIV:
			case ASG MOD:
			case ASG MUL:
				if (FLOATING(p->type))
					nr = fregs;
				goto gencase;
			case INCR:
			case DECR:
			case ASG PLUS:
			case ASG MINUS:
			case ASG AND:
			case ASG ER:
			case ASG OR:
				if (p->type == INT || p->type == UNSIGNED || ISPTR (p->type))
					goto asop;
		gencase:
			default:
				sur = zum (p->right);
				/*
				 * easy case:  if addressable, do left value, op, store
				 */
				if (sur == 0) {
					if (sul == 0)
						p->su = nr;
					/*
					 * harder: left adr, val, op, store
					 */
					else
						p->su = max (sul, nr + 1);
				}
				else {
					/*
					 * do right, left adr, left value, op, store
					 */
					if (sul == 0) {
						/*
						 * right, left value, op, store
						 */
						p->su = max (sur, nr + nr);
					}
					else {
						p->su = max (sur, max (sul + nr, nr + nr));
					}
				}
				return;
		}
	}
	switch (o) {
		case ANDAND:
		case OROR:
		case QUEST:
		case COLON:
		case COMOP:
			p->su = max (max (sul, sur), nr);
			return;
		case DIV:
		case MOD:
		case MUL:
		case LS:
		case RS:
			nr = fregs;
			break;
		case PLUS:
			{
				NODE	*s;
		
				if (offsetype(lt) && bptype(rt)) {
					/*
					 * Insure that the char pointer appears on the
					 * left hand side.
					 */
					s = p->left;
					p->left = p->right;
					p->right = s;
					ty = sul;
					sul = sur;
					sur = ty;
					/*
					 * If we've got a funky operator on the left
					 * insure that it'll be evaluated into memory
					 * by setting the su number.
					 */
					if (sur == fregs && sul > 0) {
						p->su = fregs+1;
						return;
					} else {
						if (!special(p->right, SICON))
							nr = fregs;
						goto noswap;
					}
				}
				if (offsetype(rt) && bptype(lt)) {
					/*
					 * Same as above, but don't swap it.
					 */
					if (sur == fregs && sul > 0) {
						p->su = fregs+1;
						return;
					} else {
						if (!special(p->right, SICON))
							nr = fregs;
						goto noswap;
					}
				}
			}
			break;
		case MINUS:
			/*
			 * Reflect the cost of (char *) - (char *)
			 */
			if (bptype(lt) && bptype(rt))
				nr = fregs;
			break;
		case PACONV:
		case PSCONV:
			/*
			 * Cheat a little, expect that in worst case
			 * computations up ahead will turn 2 into
			 * nr+nr = 4 which is fregs...the correct estimate
			 * for anything difficult.
			 */
			if (!special(p->right, SICON))
				nr = 2;
			break;
	}
	if (o == PLUS || o == MUL || o == OR || o == ER) {
		if (istnode (p->left) || sul > sur)
			goto noswap;		 /* don't do it! */
		/*
		 * look for a funny type on the left, one on the right
		 */
		if (rt == FLOAT && lt == DOUBLE)
			goto swap;
		if (CHARACTER(rt) && (lt == INT || lt == UNSIGNED || ISPTR (lt)))
			goto swap;
		if (lt == LONG || lt == ULONG) {
			if (rt == LONG || rt == ULONG) {
				/*
				 * if one is a STARNM, swap
				 */
				if (p->left->op == UNARY MUL && sul == 0)
					goto noswap;
				if (p->right->op == UNARY MUL && p->left->op != UNARY MUL)
					goto swap;
				goto noswap;
			}
			else
				if (p->left->op == UNARY MUL && sul == 0)
					goto noswap;
				else
					goto swap;
						 /* put long on right, unless STARNM */
		}
		/*
		 *  we are finished with the type stuff now;
		 * if one is addressable,
		 * put it on the right
		 */
		if (sur > sul && sul <= 1) {
			NODE * s;
			int     ssu;
	swap:
			ssu = sul;
			sul = sur;
			sur = ssu;
			s = p->left;
			p->left = p->right;
			p->right = s;
		}
	}
noswap:
	sur = zum (p->right);
	if (sur == 0) {
		/*
		 * get left value into a register, do op
		 */
		p->su = max (nr, sul);
	}
	else {
		/*
		 * do harder into a register, then easier
		 */
		p->su = max (nr + nr, min (max (sul, nr + sur),
					   max (sur, nr + sul)));
	}
}
/*
 * do register allocation
 */
rallo (p, down)
register NODE *p;
{
	register        o,
	                type,
	                down1,
	                down2,
			lt,
	                ty;
	if (radebug)
		printf ("rallo( %o, %o )\n", p, down);
	down2 = NOPREF;
	p->rall = down;
	down1 = (down &= ~MUSTDO);
	ty = optype (o = p->op);
	if (ty == BITYPE || ty == UTYPE)
		lt = p->left->type;
	type = p->type;
	if (FLOATING(type)) {
		switch(o) {
			case DIV:
				down1 = FRx|MUSTDO;
				down2 = Rd|MUSTDO;
				break;
			case UNARY MINUS:
				down1 = FRx|MUSTDO;
				break;
			case FORCE:
				down1 = FRx|MUSTDO;
				break;
			case UNARY MUL:
				goto stars;
		}
		++fltused;
	} else switch(o) {
		case STARG:
		case CALL:
		case UNARY CALL:
			/*
			 * make sure it gets put into an index register
			 */
			down1 = Ri|MUSTDO;
			break;
		case ER:
		case OR:
		case AND:
		case MUL:
			if (p->right->op == FLD && p->left->su > 1)
				down1 = Re|MUSTDO;
			else
				down1 = down2 = Ra;
			break;
		case DIV:
		case MOD:
			if (type != LONG && type != ULONG) {
				down1 = Ra|MUSTDO;
				down2 = Ri|MUSTDO;
			}
			break;
		case FORCE:
		case LS:
		case RS:
			/*
			 * Must have value to be shifted in the Ra or
			 * Rd register.  The address of the operand
			 * is placed in the Ri or Rj register for a
			 * variable shift (to be used to index into the
			 * table of instructions for the exm), or
			 * given as an explicit constant.
			 */
			if (type == LONG || type == ULONG)
				down1 = Rd|MUSTDO;
			else
				down1 = Ra|MUSTDO;
			if (o != FORCE)
				down2 = Ri|MUSTDO;
			break;
		case ASSIGN:
		asghelp:
			/*
			 * Force address of right hand side into j register
			 * for char's; and address of left into i register.
			 * (only if there is a UNARY MUL present).
			 */
			if ((o = p->left->op) == UNARY MUL || o == FLD) {
				/*
				 * Force left into the i register
				 */
				mkrall(p->left, Ri|MUSTDO);
			}
			if ((o = p->right->op) == UNARY MUL || o == FLD) {
				/*
				 * Force the right into the j register
				 */
				mkrall(p->right->left, Rj|MUSTDO);
			}
			if (CHARACTER(lt) || p->left->op == FLD)
				p->right->rall = Ra|MUSTDO;
			return;
		case INCR:
		case DECR:
			if (bptype(type))
				down1 = Ri;
			break;
		case STASG:
			if (p->left->op != ICON)
				mkrall(p->left, Ri|MUSTDO);
			if (p->right->op != ICON)
				mkrall(p->right, Rj|MUSTDO);
			return;
		case EQ:
		case NE:
		case GT:
		case GE:
		case LT:
		case LE:
		case NOT:
		case ANDAND:
		case OROR:
			down1 = NOPREF;
			break;
		case UNARY MUL:
		stars:
			if (p->left->rall == NOPREF)
				mkrall(p->left, Rj|MUSTDO);
			return;
		case PLUS:
		case MINUS:
			/*
			 * Special concession to char * + bytes,
			 *  cut down on the number of times intermediate
			 *  results move from reg to reg.
			 */
			if (bptype(lt)) {
				if (!bptype(p->right->type)) {
					if (special(p->right, SICON)) {
						if (down1 == Ri || down1 == Rj)
							down1 |= MUSTDO;
						else
							down1 = Ri|MUSTDO;
					} else
						down2 = down1, down1 = Ra|MUSTDO;
				} else
					down1 = Ra|MUSTDO, down2 = Ri|MUSTDO;
			}
			break;
		case PACONV:
		case PSCONV:
			/*
			 * Similar to above, but we check for
			 * special case of constants.
			 */
			if (special(p->right, SICON)) {
				if (down1 == Ri || down1 == Rj)
					down1 |= MUSTDO;
				else
					down1 = Ri|MUSTDO;
			} else
				down1 = Ra|MUSTDO, down2 = Ri|MUSTDO;
			break;
		case SCONV:
			if ((type == LONG || type == ULONG) ||
			    (bptype(lt) && offsetype(type)))
				down1 = Ra|MUSTDO;
			break;
		case PCONV:
			if (bptype(type) && offsetype(lt))
				down1 = Ra|MUSTDO;
			break;
		default:
			/*
			 * Help out assignops....
			 */
			if (asgop(o))
				goto asghelp;
			break;
	}
	if (ty != LTYPE)
		rallo (p->left, down1);
	if (ty == BITYPE)
		rallo (p->right, down2);
}
/*
 * Insure that the use of p gets done with register r;
 * in effect, simulate offstar.
 */
mkrall(p, r)
	register NODE	*p;
	register	r;
{
	if (p->op == FLD) {
		p->left->rall = p->rall;
		p = p->left;
	}
	if (p->op == UNARY MUL) {
		p->rall = r;
		p = p->left;
	}
	if ((p->op == PLUS || p->op == MINUS) && p->right->op == ICON) {
		register	rt = p->right->type,
				lt = p->left->type;
		p->rall = r;
		p = p->left;
	}
	rallo(p, r);
}
/*
 * handle indirections
 */
offstar (p)
register NODE *p;
{
	register	o = p->op;
	if (xdebug)
		xprint(p, ININREG, "offstar");
	if (o == UNARY MUL && !shumul(p->left)) {
		p = p->left;
		o = p->op;
	}
	/*
	 * Look ahead to see if we might form an OREG by placing the
	 * pointer part of a PACONV/PSCONV into an index register.
	 * If we don't have what we want don't fool around with it,
	 * since it might appear on the left hand side of an op=,
	 * in which case we would end up doing the PACONV/PSCONV twice.
	 */
	if (o == PACONV || o == PSCONV) {
		if (p->right->op == ICON && ((p->right->lval+1)%3) == 0 &&
		    p->right->name[0] == '\0') {
			if (p->left->op != REG) {
				order(p->left, INAREG);	
				return;
			}
		}
	}
	if ((o == PLUS || o == MINUS) && !bptype(p->left->type)) {
		if (p->left->op != REG) {
			order (p->left, INAREG);
			return;
		}
	}
	order(p, INAREG);
}
/*
 * Rewriting rules for ++ and -- operators.
 */
setincr (p)
	NODE	*p;
{
	return(0);		/* don't bother right now */
}
/*
 * Have we got a nice UNARY MUL node to feed to offstar ???
 */
niceuty(p)
register NODE	*p;
{
	register TWORD	t = p->type;
	if (p->op == FLD)
		p = p->left;
	if (p->op != UNARY MUL)
		return(0);
	p = p->left;
	if (!CHARACTER(t))
		return(!shumul(p));
	return(p->op != REG);
}
/*
 * Is the node p addressable...i.e. can we access it without any more
 * registers.
 */
canadrs(p)
	register NODE	*p;
{
	register	o = p->op,
			type = p->type;
	if (!CHARACTER(type) && o != FLD) {
		if (o == UNARY MUL)
			return(shumul(p->left));
		return(o == REG || o == NAME || o == ICON || o == OREG);
	}
	if (o == FLD) {
		if ((o = p->left->op) == UNARY MUL) {
			if (CHARACTER(type))
				return(p->left->left->op == REG);
			return(shumul(p->left->left));
		}
		return(o == NAME || o == OREG);
	}
	/*
	 * All that's left is characters
	 */
	if (o == UNARY MUL)
		return(p->left->op == REG);
	return(o == OREG || o == NAME);
}
/*
 *	Rewriting rules for all binary operators
 */
setbin (p)
	register NODE	*p;
{
	register NODE	*r = p->right,
			*l = p->left;
	register	o = p->op;
	extern int	revrel[];
	if (xdebug)
		xprint(p, FOREFF, "setbin");
	if (logop (o)) {
		/*
		 * relational: do both sides into regs if need be
		 * Place the harder side on the left (always), so we may
		 * flip-flop back and forth trying to make each side
		 * addressable.  While not terribly aesthetic it seems to be
		 * the best way to come up with as many cm<r>'s as possible.
		 * Should also handle the case where we have:
		 *      f(...) <relop> <exp>
		 * since the check of su's guards against a U* being evaluated
		 * on the right, before we make the function call.
		 */
		if (r->su > l->su) {
			p->right = l;
			l = p->left = r;
			r = p->right;
			if (p->op > NE)
				p->op = revrel[o - EQ];
			if (odebug)
				xprint(p, FORCC, "setbin");
		}
		if (niceuty(l)) {
			offstar(l->left);
			return(1);
		} else if (l->su <= r->su && niceuty(r)) {
			offstar(r->left);
			return(1);
		} else if (!istnode(l)) {
			order(l, INAREG|INDREG);
			return(1);
		}
		if (!istnode(r)) {
			order(r, INAREG|INDREG|INXREG);
			return(1);
		}
		cerror ("setbin can't deal with %s", opst[o]);
	}
	/*
	 * ordinary operator
	 */
	if (r->su == 0 && !istnode(l)) {	/* rhs is addressable */
		order(l, INAREG|INDREG|INXREG);
		return(1);
	}
	if (!istnode(r) && r->su > l->su) {
		/*
		 * First try to make it addressable
		 */
		if (niceuty(r)) {
			offstar(r->left);
			return(1);
		}
		/*
		 * Don't fool around....anything goes
		 */
forceright:
		order(r, INAREG|INDREG|INXREG|INTEMP);
		return(1);
	} else if (!istnode(l)) {
		/*
		 * This is usually due to a rewrite of op= statement.
		 */
		if ((p->type == LONG || p->type == ULONG) &&
		    r->op == REG) {
			if (niceuty(l)) {	
				offstar(l->left);
				return(1);
			} else
				cerror("setbin wants two long registers");
		} else {
			order(l, INAREG|INDREG|INXREG);
			return(1);
		}
	}
	if (istnode(l) && !istnode(r))
		goto forceright;
	cerror("setbin can't handle %s", opst[o]);
}
/*
 * Rewriting rules for structure assignments...very simple:
 *	either we have constants, or we place each side in an
 *	index register, so that we may form a loop
 */
setstr (p)
	register NODE	*p;
{
	register	o;
	if (xdebug)
		xprint(p, ININREG, "setstr");
	o = p->right->op;
	if (o != ICON && o != REG) {
		order(p->right, INAREG);
		return(1);
	}
	o = p->left->op;
	if (o != ICON && o != REG) {
		order(p->left, INAREG);
		return(1);
	}
	return (0);
}
/*
 * setup for assignment operator
 */
setasg (p)
	register NODE	*p;
{
	register NODE	*l = p->left,
			*r = p->right;
	if (xdebug)
		xprint(p, FOREFF, "setasg");
	/*
	 * Special case: look out for cascaded ='s, we may want to
	 * make the left hand side addressable if the right already is
	 * (i.e. an ICON or such).
	 */
	if (canadrs(l) && r->op != REG) {
		order (r, INAREG|INDREG|INXREG);
		return (1);
	}
	if (r->su > l->su || (l->su <= 1 && r->op != REG)) {
		if (r->op == UNARY MUL) {
			if (!shumul(r->left)) {
				offstar(r->left);
				return(1);
			}
			if (CHARACTER(r->type) && r->left->op != REG){
				order(r->left, INAREG);
				return(1);
			}
		}
		order(r, INAREG|INDREG|INXREG);
		return(1);
	}
	if (l->op == UNARY MUL){
		if (!shumul(l->left)) {
			offstar(l->left);
			return(1);
		}
		if (CHARACTER(l->type) && l->left->op != REG) {
				order(l->left, INAREG);
				return(1);
		}
	}
	if (l->op == FLD && l->left->op == UNARY MUL) {
		offstar (l->left->left);
		return (1);
	}
	return (0);
}
/*
 * setup for =ops
 */
setasop (p)
	register NODE	*p;
{
	register        o = p->op;
	register NODE	*pt;
	register TWORD	lt = p->left->type;
	if (xdebug)
		xprint(p, FOREFF, "setasop");
	/*
	 * General attack is to rewrite tree as follows:
	 *		op =
	 *            /     \
	 *	     e1	    e2
	 * goes to:
	 *		=
	 *	      /   \
	 *	     e1    op
	 *		 /    \
	 *	       e1      e2
	 * from which time setbin and setasg take over.
	 *
	 * This bunch of code should only be entrered once per
	 * op= we have to process (i.e. what happens afterwards is
	 * up to setbin and setasg)
	 *
	 * We can only handle += and -= for the following things:
	 *	int, unsigned, pointers to anything but a char
	 * thus the ugly 'if' must check we aren't letting slip
	 * by.
	 */
	if ((o != ASG PLUS && o != ASG MINUS) ||
	    (lt != INT && lt != UNSIGNED && !ISPTR(lt))) {
	rewrite:
		/*
		 * Make sure no side effects are created by the rewriting.
		 * but be careful about x op= f();
		 */
		if (p->right->su < fregs && niceuty(p->left))
			offstar(p->left->left);
		/*
		 * Now do it
		 */
		pt = tcopy(p);
		p->op = ASSIGN;
		reclaim(p->right, RNULL, 0);
		p->right = pt;
		p->right->op--;		/* turn ASG OP => OP */
		canon(p);
		rallo(p, p->rall);
		if (odebug)
			fwalk(p, eprint, 0);
		/*
		 * Let reader.c handle the rest
		 */
		return(1);
	}
	/*
	 * Handle only += and -= for restricted cases
	 */
	if ((bptype(lt) && !special(p->right, SICON) || p->left->op == FLD))
		goto rewrite;
	/*
	 * Be careful about x += f(), so check the su count
	 * before going to the left.
	 */
	if (p->right->su < fregs && niceuty(p->left)) {
		offstar(p->left->left);
		return(1);
	}
	/*
	 * Well, we've got the left hand side addressable (maybe),
	 * now lets try to put the right in a register.
	 */
	if (niceuty(p->right)) {
		offstar(p->right->left);
		return(1);
	}
	if (p->right->op != REG) {
		order(p->right, INAREG|INDREG|INXREG);
		return(1);
	}
	/*
	 * This shouldn't happen, but if it does let reader.c handle
	 * the rewriting.
	 */
	return(0);
}
getlab()
{
	return (crslab++);
}
deflab(l)
{
	printf("L%d:\n", l);
}
/*
 *	Generate code for argument passing.
 */
genargs (p)
register NODE *p;
{
	register        size;
	/*
	 * first, do the arguments on the right (last->first)
	 */
	while (p->op == CM) {
		genargs (p->right);
		p->op = FREE;
		p = p->left;
	}
	order (p, FORARG);
}
argsize (p)
register NODE *p;
{
	register        t;
	t = 0;
	if (p->op == CM) {
		t = argsize (p->left);
		p = p->right;
	}
	if (FLOATING(p->type) || p->type == LONG || p->type == ULONG)
		return (t + 2);
	else
		if (p->op == STARG)
			return (t + INTROUND(p->stsize));/* size */
		else
			return (t + 1);
}
/*
 * Debugging routine
 */
xprint(p, cook, name)
	register NODE	*p;
	COOKSZ		cook;
	register char	*name;
{
	printf("%s( %o, ", name, p);
	prcook(cook);
	printf(" )\n");
	fwalk(p, eprint, 0);
}
bptype(t)
	register TWORD	t;
{
	return(t == (PTR+CHAR) || t == (PTR+UCHAR) || t == INCREF(ARY+CHAR) ||
		t == INCREF(ARY+UCHAR));
}
offsetype(t)
	register TWORD	t;
{
	return(CHARACTER(t) || t == UNSIGNED || t == INT);
}
