#
/*
# include "stdio.h"
*/
#if unix
# include <signal.h>
#endif

# include "mfile1"

#ifdef ONEPASS
# include "manifest"
# include "macdefs"
#endif


int     proflag;
int	traceflag;			/* Trace option */
int     strftn = 0;		       /* is the current function one which returns a value */
FILE	*tmpfile;
FILE	*outfile = stdout;
#if unix
char   *tmpname = "/tmp/pcXXXXXX";
#endif
#if vulcan
char	*tmpname = "C9";
#endif
int     crslab = 10;
int     lastloc = PROG;

/*
 * The size (in words) of the largest structure that should be moved via
 * a move sequence...as opposed to a loop of moves
 */
# define BIGSIZE	6

/*
 * output a branch to label n,
 * exception is an ordinary function branching to retlab: then return
 */
branch (n)
{
	if (n == retlab && !strftn) {
		printf(")	bul	cret\n");
	}else
		printf(")	buc	L%d\n", n);
}

/*
 * cause the alignment to become a multiple of n.
 */
defalign (n)
{
	n /= SZCHAR;
	if (lastloc != PROG && n > 3)
		cerror("attempt to align to %d-byte boundary", n);
}

locctr (l)
{
	register        temp;

	/*
	 * l is either
	 *	PROG, ADATA, DATA, STRING, ISTRING, or STAB.
	 */
	if (l == lastloc)
		return (l);
	temp = lastloc;
	lastloc = l;
	switch (l) {

		case PROG:
			outfile = stdout;
			if (temp == DATA || temp == ADATA)
				printf(")\t.text\n");
			break;

		case DATA:
		case ADATA:
			outfile = stdout;
			if (temp != DATA && temp != ADATA)
				printf(")	.data\n");
			break;

		case STRNG:
		case ISTRNG:
			outfile = tmpfile;
			break;

		case STAB:
			cerror ("locctr: STAB unused");
			break;

		default:
			cerror ("illegal location counter");
	}

	return (temp);
}

/*
 * output something to define the current position as
 * label n.
 */
deflab (n)
{
	fprintf (outfile, ")L%d:\n", n);
}

/*
 * return a number usable for a label.
 */
getlab ()
{
	return (++crslab);
}

/*
 * code for the end of a function
 */
efcode ()
{

	if (strftn) {		       /* copy output (in Ra) to caller */
		register struct symtab *p;
		register int    stlab;
		register int    count;
		int     size;

		p = &stab[curftn];
		deflab (retlab);
		stlab = getlab ();
		size = tsize (DECREF (p->stype), p->dimoff, p->sizoff) / SZCHAR;
		count = size / sizeof(int);
		printf(")	tai\n");
		if (count <= BIGSIZE) {	/* handle it with a series of moves */
			register char	reg;
			register int	ncount = count;

			while (ncount > 1) {
				printf(")	tmd	!%d,i\n", ncount-2);
				printf(")\ttdm\t!L%d+%d\n",stlab, ncount-2);
				ncount -= 2;
			}
			if (ncount == 1) {
				printf(")	tma	!0,i\n");
				printf(")	tam	!L%d\n", stlab);
			}
		} else {		/* build a loop */
			/*
			 * Do it in doubles
			 */
			printf(")	tnj	%d\n", count & ~01);
			printf(")0:	tmd	!0,i\n");
			printf(")\ttdm\t!L%d+%d,j\n", stlab, count & ~01);
			printf(")	aoi	2\n");
			printf(")	aoj	1\n");
			printf(")	bwj	0b\n");
			if (count & 01) {	/* move it separate */
				printf(")	tma	!0,i\n");
				printf(")	tam	!L%d+%d\n", stlab, count-1);
			}
		}
		printf(")	tma	$L%d\n", stlab);
		printf(")\t.bss\n)L%d:\t.=.+%d\n", stlab, count);
		printf(")	.text\n");
		/*
		 * turn off strftn flag, so return
		 * sequence will be generated.
		 */
		strftn = 0;
	}
	branch (retlab);
#ifdef ONEPASS
	p2bend ();
#else
	printf("]\n");
#endif
}

/*
 * code for the beginning of a function;
 *  a is an array of indices in stab for the arguments
 *  n is the number
 */
bfcode (a, n)
	int	a[];
{
	register        i;
	register        temp;
	register struct symtab *p;
	int     off;

	locctr (PROG);
	p = &stab[curftn];
	defnam (p);
	temp = p->stype;
	temp = DECREF (temp);
	strftn = (temp == STRTY) || (temp == UNIONTY);

	retlab = getlab ();
	if (proflag) {
		int     plab;
		plab = getlab ();
		printf(")	tma	$L%d\n", plab);
		printf(")	bli	@mcount\n");
		printf(")\t.bss\n)L%d:\t.=.+1\n", plab);
		printf(")	.text\n");
	}

	/*
	 * routine prolog
	 */
	printf(")	bli	@csv\n");
	/*
	 * adjust stack for autos
	 */
	printf(")	tni	.F%d\n", ftnno);
	printf(")	aim	!stack\n");

	off = ARGINIT;
	/*
	 *	Note that there are no register variables, so all
	 *	we do is allocate space on the stack for the params.
	 */
	for (i = 0; i < n; ++i)
		if(oalloc(&stab[a[i]], &off))
			cerror ("bad argument");

	/*
	 * Insert code for tracing flow of control
	 */
	if (traceflag) {
		int	namlab = getlab();
		register int	paramoff = 0;

		for (i = 0; i < n; i++) {
			register struct symtab	*p;

			p = &stab[a[i]];
			if (p->sclass != PARAM)
				continue;
			/*
			 * Compute the amount of space the param takes on the
			 * stack, so we may place it in line and print out
			 * all the params to a function.
			 */
			paramoff += tsize(p->stype, p->dimoff, p->sizoff);
			if (p->stype == CHAR || p->stype == UCHAR)
				SETOFF(paramoff, ALINT);
		}
		printf(")	tma	#L%d,0\n", namlab);
		printf(")	bli	@tracer\n");
		printf(")	.word	%d\n", paramoff/SZINT);
		/*
		 * Put the name of the function in text space
		 */
		locctr(ISTRNG);
		defalign(ALPOINT);
		fprintf(outfile, ")	.text\n");
		fprintf(outfile, ")L%d:	.word	\"%s\\0\"\n", namlab, p->sname);
		fprintf(outfile, ")	.data\n");
		locctr(PROG);
	}
}

/*
 * called just before the first executable statement
 * by now the atomatics and register variables are allocated.
 */
bccode ()
{
	SETOFF (autooff, SZINT);
	/*
	 * set aside store area offset
	 */
#ifdef ONEPASS
	p2bbeg (autooff, regvar);
#else
	printf("[%d\t%d\t%d\t\n", ftnno, autooff, regvar);
#endif
}

/*
 * called just before the final exit,
 *   flag is 1 if errors,
 * 	     0 if none.
 */
ejobcode (flag)
{
}

/*
 * called before removing automatics from stab
 */
aobeg ()
{
}

/*
 * called when automatic p is removed from stab
 */
aocode (p)
	struct symtab  *p;
{
}

/*
 * called after removing all automatics
 * from stab.
 */
aoend ()
{
}

/*
 * define the current location as the name p->sname.
 */
defnam (p)
	register struct symtab	*p;
{

	if (p->sclass == EXTDEF)
		printf(")	.globl	%s\n", exname(p->sname));
	if (p->sclass == STATIC && p->slevel > 1)
		deflab (p->offset);
	else
		printf(")%s:\n", exname (p->sname));
}

/*
 * put byte i+1 in a string
 */
bycode(t, i)
{
	if (t < 0) {
		putc('\n', outfile);
		return;
	}
	t &= 0xff;	/* just one byte */
	if (i == 0) {
		locctr(ISTRNG);
		fprintf(outfile, ")	.byte	0%o", t);
		return;
	}
	if ((i % 12) == 0)
		fprintf(outfile, "\n)	.byte	0%o", t);
	else
		fprintf(outfile, ",0%o", t);
}

/*
 * n integer words of zeros
 */
zecode(n)
{
	if (n <= 0)
		return;
	printf(")	.=.+%d\n", n);
	inoff += (OFFSZ)n * SZINT;
}

/*
 * return the alignment of field of type t
 */
fldal (t)
	unsigned	t;
{
	uerror ("illegal field type");
	return (ALINT);
}

/*
 * fix up type of field p
 */
fldty (p)
	struct symtab	*p;
{
	;
}

/*
 * print location of error
 *  c is either
 *	'u'	user error
 *	'c'	compiler error
 *	'w'	warning
 */
where (c)
	char	c;
{
	fprintf (stderr, "%s, line %d: ", ftitle, lineno);
}

main (argc, argv)
	int	argc;
	char	*argv[];
{
	register int	c;
	register int	i;
	int		r;
	extern int	dexit ();

	for (i = 1; i < argc; ++i) {
		if (argv[i][0] == '-') {
			if (argv[i][1] == 'X') switch(argv[i][2])
			{
				case 'p':
					proflag = 1;
					break;
				case 'T':
					traceflag = 1;
					break;
			}
		}
#if unix && slash6
		else {		/* collect files */
			if (freopen(argv[i], "r", stdin) == NULL)
				cerror("can't open %s", argv[i]);
			if (i+1 < argc && freopen(argv[i+1], "w", stdout) == NULL)
				cerror("can't create %s", argv[i+1]);
			break;
		}
#endif
	}

#ifndef vulcan
	mktemp (tmpname);
	if (signal (SIGHUP, SIG_IGN) != SIG_IGN)
		signal (SIGHUP, dexit);
	if (signal (SIGINT, SIG_IGN) != SIG_IGN)
		signal (SIGINT, dexit);
	if (signal (SIGTERM, SIG_IGN) != SIG_IGN)
		signal (SIGTERM, dexit);
#endif
	tmpfile = fopen (tmpname, "w");
	if (tmpfile == NULL)
		cerror("can't open temp file\n");

	r = mainp1 (argc, argv);

	tmpfile = freopen (tmpname, "r", tmpfile);
	if (tmpfile != NULL)
		while ((c = getc (tmpfile)) != EOF)
			putchar (c);
	else
		cerror ("Lost temp file");
	/*
	 * If we're on Vulcan we must deassign the lfn associated with
	 * the temp file before we elminate it, or _cleanup will try to
	 * deassign it after the eliminate does - boom!!
	 */
#ifdef vulcan
	fclose(tmpfile);
#endif
	unlink (tmpname);
	return (r);
}

dexit (v)
{
#ifdef vulcan
	fclose(tmpfile);
#endif
	unlink (tmpname);
	exit (v);
}

/*
 *	p points to an array of structures, each consisting
 *	of a constant value and a label.
 *	The first is >=0 if there is a default label;
 *		its value is the label number
 *	The entries p[1] to p[n] are the nontrivial cases
 */
genswitch (p, n)
	register struct sw	*p;
{
	register        i;
	register CONSZ	j,
	                range;
	register        dlab,
	                swlab;

	range = p[n].sval - p[1].sval;

	if (range > 0 && range <= 3 * n && n >= 4) {
				       /* implement a direct switch */
		swlab = getlab();
		dlab = p->slab >= 0 ? p->slab : getlab ();

		printf(")	tai\n");
		if (j = p[1].sval)
			printf(")\t%s\t%D\n", j > 0 ? "soi" : "aoi",
				j > 0 ? j : -j);
		/*
		 * note that this is a cl; it thus checks
		 *  for numbers below range as well as out of range.
		 */
		printf(")	bon	L%d\n", dlab);
		printf(")	cmi	$%D\n", range);
		printf(")	bop	L%d\n", dlab);
		printf(")	buc	*@L%d,i\n", swlab);

		/*
		 * output table
		 */
		locctr (ADATA);
		defalign (ALPOINT);
		deflab (swlab);
		for (i = 1, j = p[1].sval; i <= n; ++j) {
			printf(")	.dac	L%d\n", (j == p[i].sval) ?
					p[i++].slab : dlab);
		}

		locctr (PROG);

		if (p->slab < 0)
			deflab (dlab);
		return;

	}

	/*
	 * debugging code
	 */

	/* out for the moment
	if( n >= 4 ) werror( "inefficient switch: %d, %d", n, (int) (range/n) );
	 */

	/*
	 * simple switch code
	 */

	for (i = 1; i <= n; ++i) {
		/*
		 * already in a register
		 */
		printf(")	cma	$%D\n", p[i].sval);
		printf(")	boz	L%d\n", p[i].slab);
	}

	if (p->slab >= 0)
		branch (p->slab);
}
