%{
#include	"mch.c"
%}

%token	S_CHAR	S_INT	S_IF	S_FOR	S_DEF
%token	S_DO	S_ELSE	S_WHILE	S_BREAK	S_LOOP	S_GOTO
%token	S_INCL	S_RETUR	S_SWITC	S_CASE	S_DEFAU

%token	ASCII	370
%token	NUM	371
%token	ID	203
%token	STRING	207
%token	ASEMINS	211

%token	RSHIFT	309
%token	LSHIFT	310
%token	LOGAND	313
%token	LOGOR	314

%token	EQPL	331
%token	EQMI	332
%token	EQAND	333
%token	EQIOR	334
%token	EQXOR	335
%token	EQDIV	336
%token	EQMUL	337
%token	EQMOD	338
%token	EQRSH	339
%token	EQLSH	340


%token	UAND	352
%token	UIND	353
%token	UMINUS	354
%token	INCRA	355
%token	DECRA	356


%token	LE	323
%token	GE	322
%token	EQEQ	325
%token	NEQ	326



%right	'='	EQPL	EQMI	EQAND	EQIOR	EQXOR	EQDIV	EQMUL	EQMOD
%right	EQRSH	EQLSH
%left	LOGOR
%left	LOGAND
%left	'|'
%left	'^'
%left	'&'
%left	EQEQ	NEQ
%left	GE	LE	'<'	'>'
%left	RSHIFT	LSHIFT
%left	'+'	'-'
%left	'*'	'/'	'%'
%right	UIND	UAND	UMINUS	'!'	'~'	INCRA	DECRA


%%


start	: extdef
	| start extdef
	;

extdef	: dtype decl '(' arglist ')'  adlist fbody =
		prodec($1, $2, $7);
	| dtype decl '(' arglist ')'  fbody =
		prodec($1, $2, $6);
	| dtype decl '(' ')' fbody =
		prodec($1, $2, $5);
	| dtype indlist ';' =
		settype($1);
	| S_INCL STRING =
	{
		getfil();
	}
	| S_DEF ID conexp =
	{
		if (chkdecl($2)) {
			$2->s_value = $3;
			$2->s_class =| EXTERN;
			$2->s_flag =| DEFINED;
		}
	}
	| mcode =
	{
		chktabovr();
		if ($1)
			*asp-- = node($1, cntr);
	}
	| error stdel
	;

stdel	: ';'
	| '}'
	| '{'
	;

mcode	: '?' =
		$$ = getasmbl();
	| dtype ID '?'  =
	{
		chkdecl($2);
		$2->s_type =| FUNC | $1;
		if (($$ = getasmbl()) == 0)
			$2->s_class =| EXTERN;
	}
	;

fbody	: '{' dlist stlist '}' =
		$$ = $3;
	| '{' stlist '}' =
		$$ = $2;
	;

indlist	: idecl midecl 
	| indlist idecl midecl 
	;

midecl	: ',' indlist
	| midecl ',' indlist
	|
	;

idecl	: mdecl =
		decinit($1, 0, 0);
	| mdecl conexp =
		decinit($1, $2, 0);
	| mdecl STRING =
		decinit($1, inistr($1, $2), STRING);
	| mdecl '{' c_t_exp '}' =
	{
		if (*(ptr = $3) == CTEXPR &&
				!($1->s_type & ARRAY))
			terror(1);
		decinit($1, $3, CTEXPR);
	}
	| mdecl '&' ID		%prec UAND =
	{
		if ($1->s_type & PNTR)
			decinit($1, $3, UAND);
		else
			terror(1);
	}
	| mdecl '&' ID '[' conexp ']' 	%prec UAND =
	{
		if (!($3->s_type & ARRAY))
			terror(2);
		if ($1->s_type & PNTR)
			decinit($1, node($3, $5), SUBSCR);
		else
			terror(1);
	}
	;

conexp	: conexp '+' conexp =
		$$ = $1 + $3;
	| conexp '-' conexp =
		$$ = $1 - $3;
	| conexp '*' conexp =
		$$ = $1 * $3;
	| conexp '/' conexp =
		$$ = $1 / $3;
	| conexp '&' conexp =
		$$ = $1 & $3;
	| conexp '|' conexp =
		$$ = $1 | $3;
	| conexp '^' conexp =
		$$ = $1 ^ $3;
	| conexp '%' conexp =
		$$ = $1 % $3;
	| conexp LSHIFT conexp =
		$$ = $1 << $3;
	| conexp RSHIFT conexp =
		$$ = $1 >> $3;
	| '-' conexp	%prec UMINUS =
		$$ = - $2;
	| '!' conexp =
		$$ = !$2;
	| '~' conexp =
		$$ = ~$2;
	| constan =
		$$ = $1;
	| ID =
	{
		if ($1->s_flag & DEFINED)
			$$ = $1->s_value;
		else
			terror(1);
	}
	;

c_t_exp	: intlzer
	| c_t_exp ',' intlzer =
		$$ = node(CTEXPR, $1, $3);
	;

intlzer	: conexp =
		$$ = node(CONST, $1);
	| STRING =
	{
		$$ = node(STRING, nxtlab);
		strnode($1);
	}
	| '&' ID	%prec UAND =
		$$ = node(UAND, $2);
	| '&' ID '[' conexp ']'	%prec UAND =
		$$ = node(SUBSCR, $2, $4);
	;

dtype	:
		=
		$$ = INT;
	| tdtype =
		$$ = $1;
	;

tdtype	: S_INT =
		$$ = INT;
	| S_CHAR =
		$$ = CHAR;
	;

adlist	: ddlist =
		symp1 = 0;
	;

ddlist	: ddecl
	| ddlist ddecl
	;

ddecl	: tdtype declist ';' =
		getlen($1, 0);
	;

dlist	: declars
	| dlist declars
	;

declars	: tdtype declist ';' =
		getlen($1, 1);
	;

declist	: mdecl =
		dechain($1);
	| declist ',' mdecl =
		dechain($3);
	;

decl	: ID =
	{
		chkdecl($1);
		$$ = $1;
	}
	| '*' ID	%prec UIND =
	{
		if (chkdecl($2))
			$2->s_type =| PNTR;
		$$ = $2;
	}
	;

mdecl	: decl =
		$$ = $1;
	| ID '[' dims ']' =
	{
		arraydec($1, $3);
		$$ = $1;
	}
	| '*' ID '[' dims ']'	%prec UIND =
	{
		arraydec($2, $4);
		$2->s_type =| PNTR;
		$$ = $2;
	}
	| '*' '*' ID	%prec UIND =
	{
		arraydec($3, 1);
		$3->s_type =| PNTR;
		$$ = $3;
	}
	;

dims	:
		=
		$$ = 1;
	| conexp =
		$$ = $1;
	;

arglist	: ID =
		argchain($1);
	| arglist ',' ID =
		argchain($3);
	;

stat	: S_IF '(' expr ')' stat else_st =
		$$ = node(S_IF, $3, $5, $6);
	| S_FOR '(' nulexp ';' nulexp ';' nulexp ')' stat =
		$$ = node(S_FOR, $3, $5, $7, $9);
	| S_WHILE '(' expr ')' stat =
		$$ = node(S_WHILE, $3, $5);
	| S_DO stat S_WHILE '(' expr ')' ';' =
		$$ = node(S_DO, $2, $5);
	| S_RETUR nulexp ';' =
		$$ = node(S_RETUR, $2);
	| S_SWITC '(' expr ')' stat =
		$$ = node(S_SWITC, $3, $5);
	| S_DEFAU ':' stat =
		$$ = node(S_DEFAU, $3);
	| S_CASE expr ':' stat =
	{
		if (*(ptr = $2) != CONST)
			mcerror("Constant required");
		$$ = node(S_CASE, *++ptr, $4);
	}
	| S_BREAK ';' =
		$$ = node(S_BREAK);
	| S_LOOP ';' =
		$$ = node(S_LOOP);
	| expr ';' =
		$$ = $1;
	| '{' stlist '}' =
		$$ = $2;
	| S_GOTO ID ';' =
		{ $2->s_dsiz=yyline;
		$$ = node(S_GOTO, $2);  }
	| ID ':' stat =
	{
		if (chkdecl($1)) {
			$1->s_class = LABEL;
			$$ = node(LABNODE, $1, $3);
		}
	}
	| ';' =
		$$ = 0;
	| '?' =
	{
		tptr = getasmbl();
		$$ = node(ASEMINS, tptr, cntr);
	}
	| error stdel =
		$$ = 0;
	;

nulexp	:
		=
		$$ = 0;
	| expr =
		$$ = $1;
	;

else_st	:  S_ELSE stat =
		$$ = $2;
	| =
		$$ = 0;
	;


stlist	: stat
	| stlist stat =
		$$ = node(SLIST, $1, $2);
	;

expr	:  expr '+' expr =
		$$ = trytofold(PLUS, $1, $3);
	|  expr '-' expr =
		$$ = trytofold(MINUS, $1, $3);
	|  expr LSHIFT expr =
	{
		insert(LSHIFT);
		$$ =  trytofold(LSHIFT, $1, $3);
	}
	|  expr RSHIFT expr =
	{
		insert(RSHIFT);
		$$ = trytofold(RSHIFT, $1, $3);
	}
	|  expr LOGAND expr =
		$$ = node(LOGAND, $1, $3, yyline);
	|  expr LOGOR expr =
		$$ = node(LOGOR, $1, $3, yyline);
	|  expr '&' expr =
		$$ = trytofold(AND, $1, $3);
	|  expr '|' expr =
		$$ = trytofold(OR, $1, $3);
	|  expr '^' expr =
		$$ = trytofold(UPARR, $1, $3);
	|  expr '/' expr =
	{
		insert(DIV);
		$$ = trytofold(DIV, $1, $3);
	}
	|  expr '*' expr =
	{
		insert(MUL);
		$$ = trytofold(MUL, $1, $3);
	}
	| expr '%' expr =
	{
		insert(MOD);
		$$ = trytofold(MOD, $1, $3);
	}
	|  expr '=' expr =
		$$ = node(EQ, $1, $3, yyline);
	| expr asgnop expr	%prec '=' =
		$$ = node($2, $1, $3, yyline);
	| INCRA expr =
		$$ = node(INCRB, $2, 0, yyline);
	| expr INCRA =
		$$ = node(INCRA, $1, 0, yyline);
	| DECRA expr =
		$$ = node(DECRB, $2, 0, yyline);
	| expr DECRA =
		$$ = node(DECRA ,$1, 0, yyline);
	|  expr relop expr	%prec '>' =
		$$ = node($2, node( MINUS, $1, $3, yyline), 0, yyline);
	|  '-' expr	%prec	UMINUS =
	{
		ptr = $2;
		if (*ptr++ == CONST) {
			*ptr = -(*ptr);
			$$ = $2;
		} else
			$$ = node(UMINUS, $2, 0, yyline);
	}
	| '!' expr =
	{
		ptr = $2;
		if (*ptr++ == CONST) {
			*ptr = !(*ptr);
			$$ = $2;
		} else
			$$ = node(ULNEG, $2, 0, yyline);
	}
	| '~' expr =
	{
		ptr = $2;
		if (*ptr++ == CONST) {
			*ptr = ~(*ptr);
			$$ = $2;
		} else
			$$ = node(UCOMPL, $2, 0, yyline);
	}
	| '&' expr	%prec UAND =
		$$ = node(UAND, $2, 0, yyline);
	| constan =
		$$ = node(CONST, $1, yyline);
	| STRING =
		$$ = strnode($1);
	| '(' expr ')' =
		$$ = $2;
	| ID '(' parlist ')' =
		$$ = setfun($1, $3);
	| ID '(' ')' =
		$$ = setfun($1, 0);
	| ID =
	{
		if ($1->s_flag & DEFINED) {
			$$ = node(CONST, $1->s_value, yyline);
			return;
		}
		if ($1->s_class == LOCAL || $1->s_class == PAR)
			ptr=node(LCLID, node($1->s_type, $1->s_value),yyline);
		else
			ptr = node(EXTID, $1, yyline);
		if (($1->s_type & ARRAY) && !($1->s_type & PNTR))
			$$ = node(UAND, ptr, 0, yyline);
		else
			$$ = ptr;
	}
	| ID '[' expr ']' =
	{
		insert(INDEX);
		if (!($1->s_type & ARRAY))
			terror(2);
		if ($1->s_class == LOCAL)
			ptr = node(LCLID,node($1->s_type,$1->s_value),yyline,$3);
		else
			ptr = node(EXTID,$1,yyline,$3);
		$$ = node(SUBSCR,ptr,yyline);
	}
	| '*' expr	%prec UIND =
		$$ = node(UIND, $2,0,yyline);
	;

parlist	: expr
	| parlist ',' expr =
		$$ = node(PARLIST, $1, $3);
	;

relop	: EQEQ =
		$$ = EQEQ;
	| NEQ =
		$$ = NEQ;
	| GE =
		$$ = GE;
	| LE =
		$$ = LE;
	| '<' =
		$$ = LT;
	| '>' =
		$$ = GT;
	;

asgnop	: EQPL =
		$$ = EQPL;
	| EQMI =
		$$ = EQMI;
	| EQMUL =
	{
		insert(MUL);
		$$ = EQMUL;
	}
	| EQDIV =
	{
		insert(DIV);
		$$ = EQDIV;
	}
	| EQLSH =
	{
		insert(LSHIFT);
		$$ = EQLSH;
	}
	| EQRSH =
	{
		insert(RSHIFT);
		$$ = EQRSH;
	}
	| EQXOR =
		$$ = EQXOR;
	| EQIOR =
		$$ = EQIOR;
	| EQMOD =
	{
		insert(MOD);
		$$ = EQMOD;
	}
	| EQAND =
		$$ = EQAND;
	;

constan	:  NUM =
		$$ = $1;
	| ASCII =
		$$ = $1;
	;

