
#define	NSIDEV	2


/* Data declarations and intialization for the SI handler */


/*  * * * *   Port 0   * * * *  */

struct ldisk	si0[]  {

/* Ldisk 0  */
	L_FLIPCYL |	/* flags */
	(  1  <<8),	/* priority */
	0,		/* lo cyl */
	48800,		/* no of blocks */
	&si0[0],	/* av_forw */
	&si0[0],	/* av_back */

/* Ldisk 1  */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	305,		/* lo cyl */
	4872,		/* no of blocks */
	&si0[1],	/* av_forw */
	&si0[1],	/* av_back */

/* Ldisk 2  */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	336,		/* lo cyl */
	19200,		/* no of blocks */
	&si0[2],	/* av_forw */
	&si0[2],	/* av_back */

/* Ldisk 3  */
	0 |		/* flags */
	(  1  <<8),	/* priority */
	456,		/* lo cyl */
	48800,		/* no of blocks */
	&si0[3],	/* av_forw */
	&si0[3],	/* av_back */

/* Ldisk 4  */
	0 |		/* flags */
	(  2  <<8),	/* priority */
	761,		/* lo cyl */
	4872,		/* no of blocks */
	&si0[4],	/* av_forw */
	&si0[4],	/* av_back */

/* Ldisk 5  */
	0 |		/* flags */
	(  2  <<8),	/* priority */
	792,		/* lo cyl */
	4872,		/* no of blocks */
	&si0[5],	/* av_forw */
	&si0[5],	/* av_back */
	};


struct prilev	si0prio[]  {

/* level 0 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	si_ord0,	/* service order */
	0,		/* current ldisk */
	0,		/* bp for next service */

/* level 1 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	si_ord1,	/* service order */
	0,		/* current ldisk */
	0,		/* bp for next service */

/* level 2 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	si_ord2,	/* service order */
	0,		/* current ldisk */
	0,		/* bp for next service */

	-1		/* Terminator */
	};


/*  * * * *   Port 1   * * * *  */

struct ldisk	si1[]  {

/* Ldisk 0  */
	L_FLIPCYL |	/* flags */
	(  1  <<8),	/* priority */
	0,		/* lo cyl */
	48800,		/* no of blocks */
	&si1[0],	/* av_forw */
	&si1[0],	/* av_back */

/* Ldisk 1  */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	305,		/* lo cyl */
	4872,		/* no of blocks */
	&si1[1],	/* av_forw */
	&si1[1],	/* av_back */

/* Ldisk 2  */
	0 |		/* flags */
	(  0  <<8),	/* priority */
	336,		/* lo cyl */
	19200,		/* no of blocks */
	&si1[2],	/* av_forw */
	&si1[2],	/* av_back */

/* Ldisk 3  */
	0 |		/* flags */
	(  1  <<8),	/* priority */
	456,		/* lo cyl */
	48800,		/* no of blocks */
	&si1[3],	/* av_forw */
	&si1[3],	/* av_back */

/* Ldisk 4  */
	0 |		/* flags */
	(  2  <<8),	/* priority */
	761,		/* lo cyl */
	4872,		/* no of blocks */
	&si1[4],	/* av_forw */
	&si1[4],	/* av_back */

/* Ldisk 5  */
	0 |		/* flags */
	(  2  <<8),	/* priority */
	792,		/* lo cyl */
	4872,		/* no of blocks */
	&si1[5],	/* av_forw */
	&si1[5],	/* av_back */
	};


struct prilev	si1prio[]  {

/* level 0 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	si_ord0,	/* service order */
	0,		/* current ldisk */
	0,		/* bp for next service */

/* level 1 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	si_ord1,	/* service order */
	0,		/* current ldisk */
	0,		/* bp for next service */

/* level 2 */
	0,		/* request count */
	0 |		/* order pointer */
	(  1  <<8),	/* head direction */
	si_ord2,	/* service order */
	0,		/* current ldisk */
	0,		/* bp for next service */

	-1		/* Terminator */
	};


char	si_ord0[]	"\1\2,\2;" ;
char	si_ord1[]	"\0,\0,\0\3,\3,\3,\3\0;"  ;
char	si_ord2[]	"\4\5;" ;


/*  * * * *   Pdisks   * * * *  */

struct pdisk	si_disks[]  {

/* Pdisk 0 */
	0,		/* current request */
	0,		/*    "    ldisk */
	0 |		/* error count */
	(  0  <<8),	/* errors printed */
	0,		/* r/w queue linkage */
	0,		/* physical address 1 */
	0,		/* physical address 2 */
	0,		/* error register */
	0,		/* words after error */
	0 |		/* flags */
	(  6  <<8),	/* no. of ldisks */
	si0,		/* the ldisks */
	&sistart,	/* seek start routine */
	si0prio,	/* priority level structures */

/* Pdisk 1 */
	0,		/* current request */
	0,		/*    "    ldisk */
	0 |		/* error count */
	(  0  <<8),	/* errors printed */
	0,		/* r/w queue linkage */
	0,		/* physical address 1 */
	0,		/* physical address 2 */
	0,		/* error register */
	0,		/* words after error */
	0 |		/* flags */
	(  6  <<8),	/* no. of ldisks */
	si1,		/* the ldisks */
	&sistart,	/* seek start routine */
	si1prio,	/* priority level structures */
	};
