/*	dz.c	2.1	May 25 80	M02	*/

/*
 *  DZ-11 Driver
 */
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/tty.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/pte.h"
#include "../h/uba.h"
#include "../h/conf.h"
#include "../h/pdma.h"
 
#define DZADDR  (UBA0_DEV + 0160100)
#ifdef ERNIE
#define NDZ 	(3*8)
#else
#define	NDZ	(6*8)
#endif
 
#define BITS7	020
#define BITS8	030
#define TWOSB	040
#define PENABLE	0100
#define OPAR	0200
#define MSE	040		/* Master Scan Enable */
#define RIE	0100		/* Receiver Interrupt Enable */
#define TIE	040000		/* Transmit interrupt enable */
#define DZ_IEN	(MSE+RIE+TIE)
#define PERROR	010000
#define FRERROR	020000
#define SSPEED	7		/* std speed = 300 baud */

 
#define	dzlpr	dzrbuf
#define dzmsr	dzbrk
#define ON	1
#define OFF	0
 
int	dzstart();
int	dzxint();
struct	tty dz_tty[NDZ];
int	dz_cnt = { NDZ };

struct device {
	short	dzcsr;
	short	dzrbuf;
	char	dztcr;
	char	dzdtr;
	char	dztbuf;
	char	dzbrk;
};

struct pdma dzpdma[] = {
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[0], dzxint,
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[1], dzxint,
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[2], dzxint,
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[3], dzxint,
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[4], dzxint,
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[5], dzxint,
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[6], dzxint,
	(struct device *)(DZADDR), NULL, NULL, (int)&dz_tty[7], dzxint,
/**
#ifdef ERNIE
**/
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[8], dzxint,
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[9], dzxint,
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[10], dzxint,
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[11], dzxint,
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[12], dzxint,
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[13], dzxint,
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[14], dzxint,
	(struct device *)(DZADDR+010), NULL, NULL, (int)&dz_tty[15], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[16], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[17], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[18], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[19], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[20], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[21], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[22], dzxint,
	(struct device *)(DZADDR+020), NULL, NULL, (int)&dz_tty[23], dzxint,
/**
#endif
**/
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[24], dzxint,
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[25], dzxint,
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[26], dzxint,
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[27], dzxint,
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[28], dzxint,
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[29], dzxint,
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[30], dzxint,
	(struct device *)(DZADDR+030), NULL, NULL, (int)&dz_tty[31], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[32], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[33], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[34], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[35], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[36], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[37], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[38], dzxint,
	(struct device *)(DZADDR+050), NULL, NULL, (int)&dz_tty[39], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[40], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[41], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[42], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[43], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[44], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[45], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[46], dzxint,
	(struct device *)(DZADDR+060), NULL, NULL, (int)&dz_tty[47], dzxint,
};
char	dz_timer;
char	dz_speeds[] = {
	0, 020 , 021 , 022 , 023 , 024 , 0, 025,
	026 , 027 , 030 , 032 , 034 , 036 , 0 , 0,
};
 
/*ARGSUSED*/
dzopen(d, flag)
{
	register struct tty *tp;
	register dev;
	extern dzscan();
 
	dev = minor(d);
	if (dev >= dz_cnt) {
		u.u_error = ENXIO;
		return;
	}
	if (dz_timer == 0) {
		dz_timer++;
		timeout(dzscan, (caddr_t)0, 60);
	}
	tp = &dz_tty[dev];
	tp->t_addr = (caddr_t)&dzpdma[dev];
	tp->t_oproc = dzstart;
	tp->t_iproc = NULL;
	tp->t_state |= WOPEN;
	if ((tp->t_state & ISOPEN) == 0) {
		ttychars(tp);
#if	MELB_TTY
		if (tp->t_ospeed==0 || tp->t_ispeed==0)
			tp->t_ospeed = tp->t_ispeed = SSPEED;
#else
		tp->t_ospeed = tp->t_ispeed = SSPEED;
#endif
#if	! MELB_TTY
		tp->t_flags = ODDP|EVENP|ECHO|HUPCLS;
#else
		if (tp->t_state&HUPCLS || tp->t_flags == 0)
			tp->t_flags = ODDP|EVENP|ECHO|KNL;
		else
			tp->t_flags &= ~ PAGE;
		tp->t_state &= CARR_ON;
#endif
		dzparam(dev);
	} else if (tp->t_state&XCLUDE && u.u_uid != 0) {
		u.u_error = EBUSY;
		return;
	}
/***/	if ((tp->t_state&CARR_ON) == 0)		/* don't turn off DTR */
/***/		tp->t_state &= ~HUPCLS;
/**D**/	tp->t_xtra |= 04000;		/* DEBUG: so we can see DTR on */
	dzmodem(dev, ON);
	VOID spl5();
	while ((tp->t_state & CARR_ON) == 0) {
		tp->t_state |= WOPEN;
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
	}
	VOID spl0();
	(*linesw[tp->t_line].l_open)(d, tp);
}
 
dzclose(d)
{
	register struct tty *tp;
	register dev;
 
	dev = minor(d);
	tp = &dz_tty[dev];
	(*linesw[tp->t_line].l_close)(tp);
	ttyclose(tp);
/***
	if (tp->t_flags & HUPCLS)
***/
	if (tp->t_state & HUPCLS)
/**D**/ {	tp->t_xtra &= ~04000;
		dzmodem(dev, OFF);
/**D**/	}
}
 
dzread(d)
{
	register struct tty *tp;
 
	tp = &dz_tty[minor(d)];
	(*linesw[tp->t_line].l_read)(tp);
}
 
dzwrite(d)
{
	register struct tty *tp;
 
	tp = &dz_tty[minor(d)];
	(*linesw[tp->t_line].l_write)(tp);
}
 
dzrint(dev)
{
	register struct tty *tp;
	register int c;
	register struct device *dzaddr;
 
	dzaddr = dzpdma[dev*8].p_addr;
	while ((c = dzaddr->dzrbuf) < 0) {	/* char present */
		tp = &dz_tty[((c>>8)&07)|(dev<<3)];
		if (tp >= &dz_tty[dz_cnt])
			continue;
		if ((tp->t_state & ISOPEN) == 0) {
			wakeup((caddr_t)&tp->t_rawq);
			continue;
		}
		if (c & FRERROR)
#if	! MELB_TTY
			/* framing error = break */
			if (tp->t_flags & RAW)
				c = 0;		/* null for getty */
			else
				c = 0177;	/* DEL = interrupt */
#else
		{
			c = tp->t_brkin&0377;
			if (c==(tun.t_intrc&0377) || c==(tun.t_quitc&0377)) {
				signal(tp->t_pgrp, c==(tun.t_intrc&0377)?SIGINT:SIGQUIT);
				flushtty(tp);
				c = 0200;
			}
#if	O_INT
			if (tp->t_type == INT8001) {
				ttyoutput(033, tp);
				ttyoutput('F', tp);
				tp->t_col--;
			}
#endif
			if (c == 0200)
				continue;
		}
#endif
		if (c & PERROR)	
			/* parity error */
			if (((tp->t_flags & (EVENP|ODDP)) == EVENP)
			  || ((tp->t_flags & (EVENP|ODDP)) == ODDP))
				continue;
		(*linesw[tp->t_line].l_rint)(c, tp);
	}
}
 
/*ARGSUSED*/
dzioctl(dev, cmd, addr, flag)
caddr_t addr;
dev_t dev;
{
	register struct tty *tp;
 
	tp = &dz_tty[minor(dev)];
#if	MELB_TTY
	if (cmd == TIOCXBRK) {
		register struct device *dzaddr;
		register bit;
		int dzbrkoff();

		dzaddr = dzpdma[minor(dev)].p_addr;
		bit = 1 << (minor(dev)&07);
		VOID spl5();
		tp->t_xtra |= TTY_BRK;		/* hang all ttwrites */
		putc(0, &tp->t_outq);
		while (tp->t_outq.c_cc != 0) {
			tp->t_state |= ASLEEP;
			ttstart(tp);
			sleep((caddr_t)&tp->t_outq, TTOPRI);
		}
		dzaddr->dzbrk |= bit;
		timeout( dzbrkoff, tp, (250*HZ)/1000 );		/* approx 250 ms */
		sleep((caddr_t)&tp->t_ospeed, TTBRKPRI);
		dzaddr->dzbrk &= ~bit;
		VOID putc(0, &tp->t_outq);
		tp->t_xtra &= ~TTY_BRK;
		VOID spl0();
		ttstart(tp);
		return;
	}
#endif
	if (ttioccomm(cmd, tp, addr, dev)) {
		if (cmd==TIOCSETP || cmd==TIOCSETN)
			dzparam(minor(dev));
	} else
		u.u_error = ENOTTY;
}

#if	MELB_TTY
dzbrkoff(tp)
struct tty *tp;
{
	wakeup(&tp->t_ospeed);
}
#endif
 
dzparam(dev)
{
	register struct tty *tp;
	register struct device *dzaddr;
	register short lpr;
 
	tp = &dz_tty[dev];
	dzaddr = dzpdma[dev].p_addr;
	dzaddr->dzcsr = DZ_IEN;
	if (tp->t_ispeed == 0) {
/**D**/		tp->t_xtra &= ~04000;
		dzmodem(dev, OFF);		/* hang up line */
		return;
	}
	lpr = (dz_speeds[tp->t_ispeed]<<8) | (dev & 07);
	if (tp->t_flags & RAW)
		lpr |= BITS8;
	else
		lpr |= (BITS7|PENABLE);
	if ((tp->t_flags & EVENP) == 0)
		lpr |= OPAR;
	if (tp->t_ispeed == 3)
		lpr |= TWOSB; 			/* 110 baud: 2 stop bits */
	dzaddr->dzlpr = lpr;
}
 
dzxint(tp)
register struct tty *tp;
{
	register struct pdma *dp;
 
	dp = &dzpdma[tp-dz_tty];
	tp->t_state &= ~BUSY;
	if (tp->t_state & FLUSH)
		tp->t_state &= ~FLUSH;
	else
		ndflush(&tp->t_outq, dp->p_end-tp->t_outq.c_cf);
	if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	else
		dzstart(tp);
	if (tp->t_outq.c_cc == 0 || (tp->t_state&BUSY)==0)
		dp->p_addr->dztcr &= ~(1 << ((tp-dz_tty) % 8));
}

dzstart(tp)
register struct tty *tp;
{
	register struct pdma *dp;
	register struct device *dzaddr;
	register cc;
	int sps;
	extern ttrstrt();
 
	dp = &dzpdma[tp-dz_tty];
	dzaddr = dp->p_addr;
	sps = spl5();
	if (tp->t_state & (TIMEOUT|BUSY|TTSTOP))
		goto out;
	if (tp->t_outq.c_cc <= TTLOWAT && tp->t_state&ASLEEP) {
		tp->t_state &= ~ASLEEP;
		if (tp->t_chan)
			mcstart(tp->t_chan, (caddr_t)&tp->t_outq);
		else
			wakeup((caddr_t)&tp->t_outq);
	}
#if	MELB_TTY && O_PAGE
   loop:
#endif
	if (tp->t_outq.c_cc == 0)
		goto out;
	if (tp->t_flags&RAW)
		cc = ndqb(&tp->t_outq, 0);
	else {
		cc = ndqb(&tp->t_outq, 0200);
		if (cc == 0) {
			cc = getc(&tp->t_outq);
#if	MELB_TTY && O_PAGE
			if (cc == 0200) {
				if (!(tp->t_xtra & PG_CONT))		/* don't ignore this halt */
					tp->t_xtra |= PG_WAIT;
				tp->t_xtra &= ~(PG_CONT|PG_PEND);
				goto loop;
			}
#endif
			timeout(ttrstrt, (caddr_t)tp, (cc&0177) + 6);
			tp->t_state |= TIMEOUT;
			goto out;
		}
	}
	tp->t_state |= BUSY;
	dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	dp->p_end += cc;
	dzaddr->dztcr |= 1 << ((tp-dz_tty) % 8);
   out:
	splx(sps);
}
 
/*
 * Stop output on a line.
 * Assume call is made at spl6.
 */
/*ARGSUSED*/
dzstop(tp, flag)
register struct tty *tp;
{
	register struct pdma *dp;
	register int s;

	dp = &dzpdma[tp-dz_tty];
	s = spl6();
	if (tp->t_state & BUSY) {
		dp->p_end = dp->p_mem;
		if ((tp->t_state&TTSTOP)==0) {
			tp->t_state |= FLUSH;
		}
	}
	splx(s);
}
 
dzmodem(dev, flag)
register int dev;
{
	register struct device *dzaddr;
	register char bit;
 
	dzaddr = dzpdma[dev].p_addr;
	bit = 1<<(dev&07);
	if (flag == OFF)
		dzaddr->dzdtr &= ~bit;
	else
		dzaddr->dzdtr |= bit;
}
 
dzscan()
{
	register i;
	register struct device *dzaddr;
	register bit;
	register struct tty *tp;
 
	for (i = 0; i < dz_cnt ; i++) {
		dzaddr = dzpdma[i].p_addr;
		tp = &dz_tty[i];
		bit = 1<<(i&07);
		if (dzaddr->dzmsr & bit) {
			/* carrier present */
			if ((tp->t_state & CARR_ON) == 0) {
				wakeup((caddr_t)&tp->t_rawq);
				tp->t_state |= CARR_ON;
			}
		} else {
			if ((tp->t_state & CARR_ON)) {
				/* carrier lost */
				signal(tp->t_pgrp, SIGHUP);
				dzaddr->dzdtr &= ~bit;
				flushtty(tp);
#if	MELB_TTY
		/*
		 * after a carrier loss, we don't know the terminal
		 * type (etc) as from the next open - this is easily handled
		 */
/***		I am not sure that this is safe after all ...
				tp->t_state |= HUPCLS;
 ***							... kre		***/
#endif
			}
			tp->t_state &= ~CARR_ON;
		}
	}
	timeout(dzscan, (caddr_t)0, 2*HZ);
}
