/*
 *  Melb Uni Comp Sci:
 *
 *	LPD
 *
 *	Herewithin is contained that part that actually prints
 *	a spool file and initiates and/or performs the other actions
 *	requested by opr
 */
#include <stdio.h>
#include <setjmp.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/dir.h>
#include "local.h"
#include "spool.h"
#ifdef	TTY
#include <sgtty.h>
#endif
#ifdef	LPR
#include "la.h"
#endif
#include "globals.h"

#ifdef	TTY
struct sgttyb ttysgtty;
#endif
#ifdef	LPR
struct	la_iocb	laiocb;
#endif

FILE	*cf;			/* command file fd. */

FILE	*fopen();
int	debug;			/* debug flag  */

/*
 * Read and obey a file of spooling commands
 */
spool(dfname)
char *dfname;
{
	register inp;
	register len, c;
	register l;
	register i;
	int job, copies, copyno;
	int bcopies, j, n;
	char *p, *q;
	long	t;
	char	*ctime();
	extern	int	errno;
 
	/*
	 *	All the work is really done in here
	 */
 
	if ((cf=fopen(dfname, "r"))  == 0) return;

	/*
	 *	Now the command file has been successfully opened,
	 *	initialize all relvant strings and flags, then
	 *	process the commands serially.
	 */
 
	job = mypr->pjob;
	copies = 1;
	bcopies = 1;
	bcopies = 0;
	if (mypr->opts&BANNER)
		bcopies = 1;
	banner[0] = '\0';
	wdir[0] = '\0';
	mesg[0] = '\0';
	person[0] = '\0';
	submitted[0] = '\0';
	realfname[0] = '\0';
	ttyn[0] = '\0';
	debug = 0;
#ifdef	LPR
	lpflags = F_CRUNCH;
	if (mypr->opts & NEEDCR)
		lpflags |= F_NLCR;
	if (mypr->opts & SIMFORM)
		lpflags |= F_NOFF;
	if (mypr->opts & USETABS)
		lpflags |= F_XTABS;
#endif

	time(&t);
	dt = ctime(&t);

#ifdef	TTY
	if (mypr->opts & PR_TTY)
		ioctl(fileno(op), TIOCGETP, &ttysgtty);
#endif
 
	/*  fetch and process commands  */
	for (ever) {
		setjmp(abt_env);	/* return here from 'opctl' abort */
		switch (c = getc(cf)) {
	
		/*  banner  */
		case 'B':
			getline(banner);
			continue;
 
		/*  set debug flag  */
		case 'D':
			debug = 1;
			getline(lbuf);
			continue;
 
		/*  output a file  */
		case 'F':
			if (stopped) {
				acct(mypr, A_STOP);
				exit(0);
			}
			aborted = 0;
			getline(lbuf);
			if ((inp = open(lbuf, 0)) < 0)
				continue;
			xinp = inp;
			if ( !informed && devmatch != 0 )
				inform(person, ttyn, job);
			setjmp(spool_env);
			if (debug) {
				fprintf (op, "job: %l\n", job);
				fprintf (op, "person: %s\n", person);
				fprintf(op, "tty: %s\n", ttyn);
				fprintf (op, "spooled device: %s\n",mypr->prnm);
				fprintf (op, "real file: %s\n", realfname);
				fprintf (op, "banner: %s\n", banner);
				fprintf (op, "banner copies: %l\n", bcopies);
				fprintf (op, "submitted: %s\n", submitted);
				fprintf (op, "released: %s", dt);
				fprintf (op, "copies: %l\n", copies);
				fprintf (op, "options set: 0x%x\n", lpflags);
				fprintf(op, "working dir: %s\n", wdir);
			}
			for (copyno = 1; copyno <= copies; copyno++) {
				if (mypr->opts & BIGBAN || mypr->opts & WINDUP && bcopies == 0)
					putc('\f', op);
				for (j = 0; j < bcopies; j++) {
					if (killsig) {
						fflush(op);
						spooling++;
						childcatch();
					}
					bannerpage(job, copyno, copies);
				}

				/*  flush the buffer before copying  */
				fflush(op);
#ifdef	LPR
				if (mypr->opts & PR_LA) {
					ioctl(fileno(op), LAIOCGET, &laiocb);
					laiocb.la_flags = lpflags;
					ioctl(fileno(op), LAIOCSET, &laiocb);
				}
#endif

				spooling++;
				if (killsig)
					childcatch();


				/*  the output is done here  */
				lseek(inp, 0L, 0);
				i = fileno(op);
				while ((l = read(inp, prbuf, sizeof prbuf)) > 0) {
		/*
		 * sometime we should implement a way to determine how much of
		 * the write actually got written on an EINTR, so we can only
		 * do the bit that got lost next time around
					while (write(i, prbuf, l) < 0 && errno == EINTR)
						;
		 */			write(i, prbuf, l);
				}
				spooling = 0;
				/*
				 * eject the last page, and move up
				 * ready for the next banner, or so the
				 * the user can remove his listing if this
				 * is the end
				 */
				putc('\f', op);
				if (bcopies > 0 && !(mypr->opts & BIGBAN))
					windup();
			}
			close(inp);
			xinp = -1;
			continue;
	
		/*  login user id  */
		case 'L':
			getline(person);
			continue;
 
		/*  end of job message  */
		case 'M':
			getline(mesg);
			continue;
 
		/*  number of copies  */
		case 'N':
			getline(lbuf);
			copies = atoi(lbuf);
			continue;

		/* options */
		case 'O':
			getline(lbuf);
			for (p = lbuf; c = *p; p++) switch (c) {
#ifdef	LPR
				case 'm': lpflags |= F_MARGIN; break;		/* margin */
				case 'w': lpflags |= F_WRAP; break;		/* wrap */
				case 'p': lpflags |= F_NOSKP; break;		/* no perf skip */
				case 'C': lpflags &= ~F_CRUNCH; break;		/* no line crunching */
#endif
			}
			continue;
 
		/*  real file name  */
		case 'R':
			getline(realfname);
			continue;
 
		/*  time submitted  */
		case 'S':
			getline(submitted);
			continue;
 
		/*  tty no.  */
		case 'T':
			getline(ttyn);
			continue;
 
		/*  number of banner pages per copy  */
		case 'X':
			getline(lbuf);
			bcopies = atoi(lbuf);
			continue;
 
		/* Delete file after copying */
		case 'U':
#ifdef	TTY
			if (mypr->opts & PR_TTY)
				ioctl(fileno(op), TIOCSETP, &ttysgtty);
#endif
#ifdef	LPR
			if (mypr->opts & PR_LA)
				ioctl(fileno(op), LADRAIN, 0);
#endif
			getline(lbuf);
			if (lbuf[0] == '/')
				unlink(lbuf);
			else {
				if (wdir[0] == '\0' || aborted ||
					strlen(lbuf) + wdlen > sizeof(wdir)-2)
						continue;
				strcat(wdir, lbuf);
				unlink(wdir);
				wdir[wdlen] = '\0';
			}
			continue;
 
		/*  end of command file  */
		case EOF:
			fclose(cf);
			if (bcopies == 0 || mypr->opts & BIGBAN)
				windup();
			fflush(op);
#ifdef	TTY
			if (mypr->opts & PR_TTY)
				ioctl(fileno(op), TIOCSETP, &ttysgtty);
#endif
#ifdef	LPR
			if (mypr->opts & PR_LA)
				ioctl(fileno(op), LADRAIN, 0);
#endif
			sendmesg(person, ttyn, mesg, 1);
			return;

		/* set users current working directory */
		case 'W':
			getline(wdir);
			strcat(wdir, "/");
			wdlen = strlen(wdir);
			continue;
 
		/*  unidentified command  */
		default:
			getline(lbuf);
			/*  just ignore it  */
			continue;
		}
	}
}


/*
 * Read rest of line from command file
 */
getline(buf)
char buf[];
{
	register char *p;
	register c;

	for (p = buf; (*p = c = getc(cf)) != '\n' && c > 0; p++)
		;
	*p = '\0';
}
 
 
/*
 * Discard output already sent to the printer
 */
throwout(fd)
{
#ifdef	TTY
	if (mypr->opts & PR_TTY)
		ioctl(fd, TIOCFLUSH, 0);
#endif

#ifdef	LPR
	if (mypr->opts & PR_LA)
		ioctl(fd, LAFLUSH, 0);
#endif
}
