/*
 *	lpd paper accounting
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include "local.h"
#include "spool.h"

#define	MAXU	10000
#define	MAXGRP	1000

#define	NSIZE	8		/* # chars in user / grp name */

#define	NCPY(a,b)	strncpy(a, b, NSIZE)

struct info {
	short	jobs;
	long	pages;
} users[MAXU], groups[MAXGRP];

struct {
	long	lpages;
	short	ljobs;
	char	pn[DIRSIZ];
} psum[TABSIZE];

char	uname[MAXU][NSIZE];
char	gname[MAXGRP][NSIZE];

struct act act;

char	usummary[] = "/usr/adm/lpdusrsum";
char	gsummary[] = "/usr/adm/lpdgrpsum";
char	psummary[] = "/usr/adm/lpdprsum";
char	rawdata[]  = ACFILE;

int	sflag, rflag, uflag, gflag, pflag, lflag, tflag;
int	limit;
int	nu,	ng;

char *sprintf();
struct group *getgrgid(), *getgrent();
struct passwd *getpwuid(), *getpwent();

main(argc, argv)
char **argv;
{
	register i;
	register char *p;
	register struct passwd *pw;
	register struct group *gp;
	register FILE *afd;
	register	c;
	register	fd;
	long		sum,	cnt;
	char		buf[16];

	while (--argc > 0) if (*(p = *++argv) == '-') while (c = *++p) switch (c) {
		case 's':	sflag++;	break;
		case 'r':	rflag++;	break;
		case 'u':	uflag++;	break;
		case 'g':	gflag++;	break;
		case 'p':	pflag++;	break;
		case 'l':	lflag++;	break;
		case 't':	tflag++;	break;
		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
				limit *= 10;
				limit += c - '0';
						break;

		default:	usage();	break;
	}
		else
			break;

	if (argc > 0)
		usage();

	if (rflag && sflag) {
		fprintf(stderr, "Illagal option combination\n");
		exit(1);
	}

	if (!uflag && !gflag && !pflag && !lflag && !sflag)
		tflag++;

	if (!rflag) {
		if ((fd = open(usummary, 0)) >= 0) {
			nu = read(fd, users, sizeof users) / sizeof(struct info);
			close(fd);
		}
		if ((fd = open(gsummary, 0)) >= 0) {
			ng = read(fd, groups, sizeof groups) / sizeof(struct info);
			close(fd);
		}
		if ((fd = open(psummary, 0)) >= 0) {
			read(fd, psum, sizeof psum);
			close(fd);
		}
	}

	if ((afd = fopen(rawdata, "r")) == NULL) {
		fprintf(stderr, "Can't open %s\n", rawdata);
		exit(1);
	}

	while (fread(&act, sizeof act, 1, afd) == 1) {

		if (act.a_uid >= MAXU) {
			fprintf(stderr, "MAXU overflow\n");
			exit(1);
		}
		if (act.a_gid >= MAXGRP) {
			fprintf(stderr, "MAXGRP overflow\n");
			exit(1);
		}
		if (act.a_uid > nu)
			nu = act.a_uid;
		if (act.a_gid > ng)
			ng = act.a_gid;

		users[act.a_uid].jobs ++;
		users[act.a_uid].pages += act.a_pages;
		groups[act.a_gid].jobs ++;
		groups[act.a_gid].pages += act.a_pages;

		for (i = 0; i < TABSIZE; i++)
			if (strncmp(act.a_pname, psum[i].pn, DIRSIZ) == 0) {
				psum[i].ljobs ++;
				psum[i].lpages += act.a_pages;
				break;
			} else
				if (psum[i].pn[0] == '\0') {
					strncpy(psum[i].pn, act.a_pname, DIRSIZ);
					psum[i].ljobs = 1;
					psum[i].lpages = act.a_pages;
					break;
				}

		if (lflag && act.a_pages >= limit) {
			if (uname[act.a_uid][0] == '\0') {
				if ((pw = getpwuid(act.a_uid)) == NULL)
					p = sprintf(buf, "#%d", act.a_uid);
				else
					p = pw->pw_name;
				NCPY(uname[act.a_uid], p);
			}
			if (gname[act.a_gid][0] == '\0') {
				if ((gp = getgrgid(act.a_gid)) == NULL)
					p = sprintf(buf, "#%d", act.a_gid);
				else
					p = gp->gr_name;
				NCPY(gname[act.a_gid], p);
			}

			printf("%-10.8s (%.8s)	%3d pages on %.14s\n"
				, uname[act.a_uid]
				, gname[act.a_gid]
				, act.a_pages
				, act.a_pname
			);
		}
	}
	fclose(afd);

	if (sflag)
		update();

	if (uflag) {
		setpwent();
		while (pw = getpwent()) {
			if (pw->pw_uid > nu)
				continue;
			if (uname[pw->pw_uid][0] == '\0')
				NCPY(uname[pw->pw_uid], pw->pw_name);
		}
		endpwent();

		for (i = 0; i <= nu; i++)
			if (users[i].jobs && users[i].pages >= limit) {
				if (*(p = uname[i]) == '\0')
					p = sprintf(buf, "#%d", i);
				printf("%-10.8s	%6d		%8d\n"
					, p
					, users[i].jobs
					, users[i].pages
				);
			}
	}

	if (gflag) {
		setgrent();
		while (gp = getgrent()) {
			if (gp->gr_gid > ng)
				continue;
			if (gname[gp->gr_gid][0] == '\0')
				NCPY(gname[gp->gr_gid], gp->gr_name);
		}
		endgrent();

		for (i = 0; i <= ng; i++)
			if (groups[i].jobs && groups[i].pages >= limit) {
				if (*(p = gname[i]) == '\0')
					p = sprintf(buf, "#%d", i);
				printf("%-10.8s	%6d		%8d\n"
					, p
					, groups[i].jobs
					, groups[i].pages
				);
			}
	}

	if (pflag)
		for (i = 0; i < TABSIZE; i++)
			if (psum[i].pn[0] && psum[i].ljobs && psum[i].lpages >= limit)
				printf("%-15.14s	%6d		%8d\n"
					, psum[i].pn
					, psum[i].ljobs
					, psum[i].lpages
				);

	if (tflag) {
		sum = cnt = 0;
		for (i = 0; i <= nu; i++) {
			cnt += users[i].jobs;
			sum += users[i].pages;
		}
	
		printf("%d jobs, %d pages\n", cnt, sum);
	}

	exit(0);
}

update()
{
	register fd;
	extern errno;

	errno = 0;
	if ((fd = creat(usummary, 0644)) >= 0) {
		if (users[nu].jobs)
			nu++;
		write(fd, users, nu*sizeof(struct info));
		close(fd);
	} else
		perror(usummary);

	if ((fd = creat(gsummary, 0644)) >= 0) {
		if (groups[ng].jobs)
			ng++;
		write(fd, groups, ng*sizeof(struct info));
		close(fd);
	} else
		perror(gsummary);

	if ((fd = creat(psummary, 0644)) >= 0) {
		write(fd, psum, sizeof psum);
		close(fd);
	} else
		perror(psummary);

	if (errno == 0)
		if (close(creat(rawdata)) < 0)
			fprintf(stderr, "Cannot truncate %s\n", rawdata);
}

usage()
{
	fprintf(stderr, "Usage: lpdacct [-sruplg#]\n");
	exit(1);
}
