/*
 *	Details of hp7602A / LA180 ioctl calls
 *
 *	(with emphasis on the LA180 in this file)
 */

#define	LAIOCSET	(('C'<<8)|0)
#define	LAIOCGET	(('C'<<8)|1)
#define	LAFLUSH		(('C'<<8)|2)
#define	LADRAIN		(('C'<<8)|3)


 
	/* Flags */
#define	F_IMAGE		01	/* HP: read image mode */
#define	F_XTABS		02	/* LA: use tabs to generate long space sequences */
#define	F_LCASE		04	/* LA: printer has no lower case (NOT SUPPORTED) */
#define	F_MARGIN	010	/* LA: indent all non-wrapping lines */
#define	F_NLCR		020	/* LA: \n does nor perform \r (driver is smarter) */
#define	F_RAW		040	/* LA: no manipulations of output data at all */
#define	F_ODD		0100	/* both: odd parity */
#define	F_EVEN		0200	/* both: even parity */
#define	F_NOSKP		0400	/* LA: don't jump the perforations */
#define	F_CRUNCH	01000	/* LA: delete blank lines at top of page */
#define	F_NOFF		02000	/* LA: device has no hardware form feed */
#define	F_STILL		04000	/* LA: on close, no form feed */
#define	F_WRAP		010000	/* LA: wrap long lines */
#define	F_WASTE		020000	/* LA: enable output of empty pages */

struct la_iocb {
	char	la_speed;	/* both: line speed */
	char	la_vln;		/* current virt line # (where we are on page) */
	char	la_cols;	/* # of columns available to print in */
	char	la_lines;	/* # of lines / page */
	short	la_flags;	/* both: various flags */
	int	la_pages;	/* number of pages printed since reset */
};
