#include	"../mac/mac.h"
#include	"mactab.h"
#include	"mactab.x"



/*
 *   Argument of instruction decoder.
 *   This generates the parser for MAC.
 */
parg()
{
	register int ns2;
	register int i;

	treeinit();			/* set up dummy node (root) */
	while (getlin())  {
		p = buf;
		gentree();
		}

	if (!tree->n_alt)  {
		/* null root */
		error("no parser table generated !", 0);
		return;
		}


					/* cvt tree to linear array */
	if((parse = (struct tbl *) malloc(sizeof (struct tbl)
		* (nslot + NE1 + NS1 + NS3))) == NULL) {
		error("parse table too large", 0);
		exit(1);
	}

	s2 = &parse[NE1+NS1];

	ptable(tree->n_alt);
	ns2 = tp;			/* size of seg. 2 */


	/*
	 *   Apply various patches to the generated
	 *   table to make it really useable.
	 *
	 *   Symbol type MCH implies always match
	 *   on this parser symbol. It is so MAC
	 *   can do special actions at these times.
	 */

	for (i=0; i<ns2; i++)  switch (s2[i].tb_sym)  {

		case EOL:
			s2[i].tb_sym = MCH;
			s2[i].tb_act = SELC;		/* select options */
			s2[i].tb_mem = NUL;
			s2[i].tb_next = ns2;
			break;

		case ERR:
			s2[i].tb_sym = MCH;
			s2[i].tb_act = OERR;		/* parse error */
			break;

		case LIT:
			s2[i].tb_sym = -s2[i].tb_sym;
			s2[i].tb_act =  NOOP;
			break;

		case DEL:
		case CHR:
		case OPR:
			s2[i].tb_sym = -s2[i].tb_sym;
			s2[i].tb_act = ODEL;
			break;

		case STR:
			s2[i].tb_act = OSTR;
			break;

		case EXP:
			/*
			 *   Call expr parser. An error is
			 *   detectable on 1st symbol. If so -
			 *   the expr parser returns to next
			 *   state. If a good match - it returns
			 *   to the next tree state.
			 */
			s2[i].tb_sym = MCH;
			s2[i].tb_act = EXPR;
			break;


		case LBL:
			/* make an entry for a classed label */

			s2[i].tb_act = CLBL;
			break;

		default:
			/* don't do anything */
			s2[i].tb_act = NOOP;
			break;

		}

	/*
	 *   Relocate all four sections and combine into one.
	 */

	/*
	 *   First copy the predefined sections into the table
	 */

	copytbl(e1, &parse[0], NE1);
	copytbl(s1, &parse[NE1], NS1);
	/* section 2 (user-defined) is already in place */
	copytbl(s3, &parse[ns2+NS1+NE1], NS3);

	tp = 0;
	relocate(&e1[0], NE1);
	relocate(&s1[0], NS1);
	relocate(&s2[0], ns2);
	relocate(&s3[0], NS3);


	head.h_p_len = tp;
	head.h_p_start = NE1;
	return;
}

/*
 *   This routine was designed with the aid of the
 *   project supervisor - Mr. Richard Miller.
 *
 *   The author of MACTAB duly thanks him.
 *
 */
gentree()
{
	register struct node *q;
	register cc;

	q = tree;

	do	{

		getsym();
		while (sym != q->n_sym || mem != q->n_mem)

			if (q->n_alt)
				q = q->n_alt;

			else  {
				q->n_alt = dslot();
				q = q->n_alt;
				while (sym != EOL)  {
					getsym();
					q->n_next = dslot();
					q = q->n_next;
					/*
					 * for each 'next' branch we need
					 * an extra table slot
					 */
					nslot++;
					}

				}

			/*  */

		q = q->n_next;
		}	while (sym != EOL);

	/*  end of sectional build  */

	return;
}

/*
 *   Initialise root node for gentree();
 */
treeinit()
{
	sym = ERR;
	tree = dslot();
	return;
}

/*
 *   Define a node in the tree.
 */
struct node *
dslot()
{
	register int i;
	register struct node *t;

	if((t = (struct node *) malloc(sizeof (struct node))) == NULL) {
		error("parse table too large", 0);
		exit(1);
		}

	t->n_sym = sym;
	if (sym == LBL) {
		if(mem < 0) {
			error("%s undefined", clabel);
		} else if (!symtab[mem].s_mode & CLAS) {
			error("%s is not a class", clabel);
		} else
			t->n_mem = symtab[mem].s_value;
	} else {
		t->n_mem = mem;
	}

	for (i=0; i<4; i++)
		t->n_mem4[i] = mem4[i];
	t->n_alt = NUL;
	t->n_next = NUL;

	nslot++;
	return(t);
}

/*
 *   Recursive descent routine to build a state table
 *   from the previously generated n-ary tree.
 */
ptable(q)
register struct node *q;
{
	register struct node *r;
	register int rtp;
	register int rltp;
	register int i;
	register int j;

	r = q;
	rtp = tp;

	/*
	 *   Scan list of 'alts' for an EOL.
	 *   For very subtle reasons - this MUST be
	 *   the last alt in the alt list.
	 *   In order for the parser not to be confused
	 *   between a classed label and an expression
	 *   EXP must be the last alt before EOL
	 */
	shiftdown(EXP, q);	/* shift any EXP to the end of the alt list */
	shiftdown(EOL, q);	/* make EOL the last alt. If there was an
				 * EXP it will now also be in the right place
				 */

	do	{
		s2[tp].tb_sym = q->n_sym;
		s2[tp].tb_mem = q->n_mem;
		for (j=0; j<4; j++)
			s2[tp].tb_arg[j] = q->n_mem4[j];

		tp++;
		q = q->n_alt;
		}	while (q);

	rltp = tp;			/* remember last Tree Pointer */
	s2[tp++].tb_sym = ERR;		/* stopping point */

	/*
	 *   Descend each alt,next level in turn to
	 *   build the full tree.
	 */
	for (i=rtp; i<rltp; i++)  {

		s2[i].tb_next = tp;
		if (r->n_next)
			ptable(r->n_next);

		r = r->n_alt;
		}

	return;
}

relocate(t, n)
register struct tbl *t;
register int n;
{
	register struct tbl *ep;
	register int rtp;
	register int nxt;
	register int i;


	rtp = tp;
	ep = &parse[rtp];
	tp += n;

	while (n-- > 0)  {
		nxt = t->tb_next;
		ep->tb_next = (nxt == 0 ? 0 : nxt + rtp);
		ep++;
		t++;
		}

	return;
}

copytbl(s, d, n)
struct tbl *s, *d;
int n;
{
	register char *s1, *d1;
	register int i;

	i = n * sizeof (struct tbl);
	s1 = (char *) s; d1 = (char *) d;

	while (i-- > 0)
		*d1++ = *s1++;
}

shiftdown(sym, q)
register struct node *q;
{
	do	{
		/* once sym is found, the first part of the &&
		 * will always be true
		 */
		if (q->n_sym == sym && q->n_alt)
			swap(q, q->n_alt);
		q = q->n_alt;			/* move along alt list */

	}	while (q);
}

static int swap(m, d)
register struct node *m, *d;
{
	register int i, j;
	/*
	 *    swap entries *m and *d.
	 *   this will put sym as last on list.
	 *   note - don't swap alt pointers !!!
	 */
	i = d->n_sym;
	d->n_sym = m->n_sym;
	m->n_sym = i;

	i = d->n_mem;
	d->n_mem = m->n_mem;
	m->n_mem = i;

	for (j=0; j<4; j++)  {
		i = d->n_mem4[j];
		d->n_mem4[j] = m->n_mem4[j];
		m->n_mem4[j] = i;
		}

	i = (int)d->n_next;
	d->n_next = m->n_next;
	m->n_next = (struct node *)i;
}
