#include	"mac.h"
#include	"mac.x"

/*
 *   Auxilliary routines 1.
 */


/*
 *   compar:	Compare two strings - return
 *		TRUE if equal, FALSE if not.
 *		terminate with FALSE if > 8 chars.
 */
compar(r, s)
register char *r;
register char *s;
{
	register int n;

	n = 1;
	while (*r == *s)  {
		if (*r == '\0')
			return(1);
		if (n > 8)
			return(0);
		r++;
		s++;
		n++;
		}
	return(0);
}

/*
 *   Get roughly 32 symbol table slots.
 *	set endcore = current break.
 */
struct symt {
	struct st symt_s;
	struct symt *symt_l;
};

struct symt *
cpget() {
	struct symt *p;

	if((p = (struct symt *)malloc(sizeof(struct symt)*32)) == NULL) {
		synerr("Symbol table overflow\n");
		exit(1);
	}

	endcore = (char *)p+32;
	return((struct symt *)(coreptr = (char *)p));
}

struct st *
nextsym(q) {
	register struct st *q;

	if(q == NULL) {
		return(NULL);
	} else {
		return((struct st *)(((struct symt *)q) -> symt_l));
	}
}


/*
 *   Define a symbol table entry.
 *
 *   Get next available slot and return a pointer to it.
 */
struct st *
dslot(name, value, mode)
char	*name;
int	value;
int	mode;
{
	register struct	symt *q;
	register char	*r;
	register char	*s;
	register int	ind;

	q = (struct symt *)coreptr;
	if ((char *)(q+1) > endcore)
		q = cpget();

	ind = 0;
	r = q->symt_s.s_u.s_name;
	s = name;
	while (ind < 8)  {
		*r++ = *s++;
		ind++;
		}

	q->symt_s.s_value = value;
	q->symt_s.s_mode  = mode;
	q->symt_s.s_lcntr = lcntr;
	q->symt_s.s_next  = NUL;
	q->symt_l = (struct symt *)symtab;
	symtab = (struct st *)q;

	nsyms++;
	coreptr += sizeof(struct symt);
	return((struct st *)q);
}

/*
 *   Convert an integer to ascii characters and
 *   push chars to core pointed to by 'r'.
 */
char *
num(n, r)
register int n;
register char *r;
{
	register int mask;
	register int neg;
	register int i;
	char	 ch[16];

	i = 0;
	neg = n;
	mask = BITMASK((WORDSIZ - 1));
	if (!n)  {
		*r++ = '0';
		return(r);
		}

	if (neg < 0)  {
		*r++ = '0';
		*r++ = 'x';
		}

	while (n)  {
		if (neg < 0)  {
			ch[i] = hextab[n&0xf];
			n = (n >> 4) & mask;
			}

		else  {
			ch[i] = (n % 10) + '0';
			n /= 10;
			}
		i++;
		}

	while (--i >= 0)  {
		*r++ = ch[i];
		}

	return(r);
}

/*
 *   Search string 'str' for character 'c' and return its
 *   index in 'str' if found. return ERR otherwise.
 */
any(c, str)
register char c;
char	 str[ ];
{
	register i;

	i = 0;
	while (str[i])  {
		if (c == str[i])
			return(i);
		i++;
		}
	return(ERR);
}

/*
 *	Symbol hash function
 */
hash(p)
char *p;
{
	register int i = 8, j = 0;

	if(*p == '`')		/* local symbol */
		return(SYMHASH);
	while(*p && i-- > 0)
		j = (j << 1) + *p++;

	return(j % SYMHASH);
}
