#include	"mac.h"
#include	"m.out.h"
#include	"mac.x"

char	tmp[]	=	"/tmp/macXXXXXX";		/* Space for tmp file name */
char	*arg[8];				/* Exec arg list */
extern	struct	bt	fout;

main(argc, argv)
char	*argv[ ];
{
	register int nfile;
	register int pid;
	register FILE *rfile;
	register int i;
	register char *r;
	int unit;

	nfile = 0;					/* No args seen */
	OPTION('h') = TRUE;				/* defaults */
	OPTION('i') = TRUE;
	for (i=1; i<argc; i++)  {
		p = argv[i];
		if (*p == '-')  {
			/* Option flag */
			while (*(++p) != '\0') {
				if (*p == 'h' || *p == 'o' || *p == 'b')  {
					OPTION('h') = FALSE;
					OPTION('o') = FALSE;
					OPTION('b') = FALSE;
					OPTION('l') = TRUE;
					}

				if (*p == 'w' || *p == 'f' || *p == 'i')
					OPTION('l') = TRUE;

				OPTION(*p) = TRUE;
				}
			}
		else
			/* File-name */
			arg[nfile++] = p;
		}

	if (nfile > 2)  {
		/* object file needed */
		OPTION('a') = TRUE;
		}

	if (OPTION('n'))  {
		OPTION('d') = FALSE;
		OPTION('l') = FALSE;
		OPTION('e') = TRUE;
		}


	if (nfile < 1)  {
		fprintf(stderr, "Usage: %s opcode-file [source] [object]\n", argv[0]);
		exit(1);
		}

	/*
	 *   Try to open r-file.
	 *   try 'file' first, and if that fails,
	 *   try '/usr/lib/mac/file'.
	 */
	for (i=0; i<13; i++)
		buf[i] = "/usr/lib/mac/"[i];
	r = arg[0];
	for (i=13; *r != '\0'; i++)
		buf[i] = *r++;
	rfile = fopen(&buf[13], "r");
	if (rfile == NULL)
		/* try lib */
		rfile = fopen(&buf[0], "r");

	if (rfile == NULL)  {
		synerr("Can't open r-file");
		exit(1);
		}

	currfile = "<standard input>";
	if (nfile > 1 && (src = fopen((currfile = arg[1]), "r")) == NULL)  {
		fprintf(stderr, "Can't find source file\n");
		exit(1);
		}


	/*
	 *   Make temp file.
	 */
	mktemp(tmp);
	unit = creat(tmp, 0600);
	if (unit < 0)  {
		fprintf(stderr, "Can't create temp\n");
		exit(1);
		}

	close(unit);
	unit = open(tmp, 2);
	intercd = fdopen(unit, "w");

	if (!OPTION('u'))
		/* unlink temp file if OPTION('u') is not on */
		unlink(tmp);

	if (intercd == NULL) {
		fprintf(stderr, "Can't open temp\n");
		exit(1);
	}

	tbl(rfile);		/* initialise tables */
	pass1();		/* parse source, build symtab, temp code */

	if (errcount)  {
		synerr("Errors in pass 1.");
		exit(1);
		}

	fflush(intercd);
	lseek(unit, 0, 0);
	setbuf(stdout, outbuf);
	intercd = fdopen(unit, "r");

	if (OPTION('l'))
		if (nfile < 2)  {
			warning("Listing from std. input impossible!!");
			OPTION('l') = FALSE;
			}
		else	{
			if (rewind(src) == -1) {
				synerr("Can't rewind source");
				exit(1);
				}
			}

	if (nfile > 2 && (mout = fopen(arg[2], "w")) == NULL) {
		synerr("Can't create object file");
		OPTION('a') = FALSE;
		}

	if (nfile < 3  &&  OPTION('a'))
		if ((mout = fopen("m.out", "w")) == NULL) {
			synerr("Can't create m.out");
			OPTION('a') = FALSE;
			}


	adjust();		/* adjust location counters for assembly */
	setprint();		/* initialize print parameters */
	if (OPTION('c'))		/* display print constants */
		dprintc();
	pass2();		/* initiate pass2 */
	mouthdr();
	sdump();		/* symbol table dump to std output */
	cdump();		/* code dump to std output */

	exit(0);
}

tbl(rfile)
register FILE *rfile;
{
	register struct st *s;
	struct st *ss;
	register int i;
	register struct lt	*q;
	register struct ol	*o;


	/*
	 *	read header record:
	 *
	 *	contains number of format descriptors,
	 *	and number of opcode descriptors,
	 *	pre-defined labels, literals,
	 *	and the size of the parser table.
	 *	It also contains interesting information
	 *	about the target machine.
	 *
	 *	the file contains:-
	 *		literals;
	 *		format descriptors;
	 *		opcode table;
	 *		parser table;
	 *		pre-defined labels;
	*		instruction & address lengths
	 *
	 *	calculate core requirements and getmem() 
	 *	for the core.
	 */

	fread(&head, HT, 1, rfile);

	if(head.h_mword != MWORDR) {
		fprintf(stderr, "Not an r-file\07\r\n");
		exit(1);
	}

	i = head.h_literals;
	if (i)  {
		i *= 8;			/* sizeof literal */
		literals = getmem(i);
		fread(literals, i, 1, rfile);
		}
	i = FD * head.h_formats;
	memory = (struct fd *)getmem(i);
	fread(&memory[0], i, 1, rfile);
	i = head.h_o_len;
	opcode = (struct oc *)getmem(i);
	fread(&opcode[0], i, 1, rfile);
	relopcodes(opcode);	/* relocate the opcode table pointers */
	i = head.h_p_len * TBL;
	parse = (struct tbl *)getmem(i);
	fread(&parse[0], i, 1, rfile);

	/* Initialise origin block chains, one for each loc cntr */

	for(q = locn; q < &locn[LCOUNT]; q++) {
		q->l_currorg = q->l_orgs = o = (struct ol *)getmem(OL);
		o->ol_lcstart = o->ol_lcend = 0;
		o->ol_start = NUL; o->ol_next = NUL;
		o->ol_reloc = RREL;
	}

	symtab = NULL;
	coreptr = (char *)cpget();

	i = head.h_labels;
	while (i-- > 0)  {
		fread(buf, ST, 1, rfile);
		/* enter label in symbol table */
		s = (struct st *)buf;
		ss = lscan(s->s_u.s_name, DEF, hash(s->s_u.s_name), s->s_value, s->s_mode);
		ss->s_class = s->s_class;
		}

	bl = head.h_bu_len;
	bu = head.h_w_len;
	ib = head.h_i_len;
	ibx = head.h_i_flg;

}

adjust()
{
	register struct lt *q;
	register struct ol *o;
	register int mem;
	register int *c;

	mem = 0;

	for(q = locn; q < &locn[LCOUNT]; q++) {
		(q->l_currorg)->ol_lcend = q->l_value;
		o = q->l_orgs;
		mem += (o->ol_lcend - o->ol_lcstart) * bu;

		o = o->ol_next;

		while(o != NUL) {
			mem += (o->ol_lcend - o->ol_lcstart) * bu;
			o = o->ol_next;
		}
	}

	c = code = (int *)getmem(mem * INT);
	for(q = locn; q < &locn[LCOUNT]; q++) {
		o = q->l_currorg = q->l_orgs;

		q->l_value = o->ol_lcstart;
		q->l_next = o->ol_start = c;
		c += (o->ol_lcend - o->ol_lcstart) * bu;

		o = o->ol_next;

		while(o != NUL) {
			o->ol_start = c;
			c += (o->ol_lcend - o->ol_lcstart) * bu;
			o = o->ol_next;
		}
	}
	nline = lcntr = 0;
}

dprintc()
{
	fprintf(stderr, "\t\t\tPrint Constants\n\n");
	fprintf(stderr, "\n\ttotal    digit width = %d",pt.c_dw);
	fprintf(stderr, "\n\tchar.    bit   width = %d",pt.c_bw);
	fprintf(stderr, "\n\tlocn.    digit width = %d",pt.l_dw);
	fprintf(stderr, "\n\t         incr. width = %d",pt.l_iw);
	fprintf(stderr, "\n\t         addr. incr. = %d",pt.l_ai);
	fprintf(stderr, "\n\tword     digit width = %d",pt.w_dw);
	fprintf(stderr, "\n\t         bit   tally = %d",pt.w_bt);
	fprintf(stderr, "\n\t         bit   width = %d",pt.w_bw);
	fprintf(stderr, "\n\t         bit   MSD   = %d",pt.w_rw);
	fprintf(stderr, "\n\tformat   digit width = %d",pt.f_dw);
	fprintf(stderr, "\n\t         bit   tally = %d",pt.f_bt);
	fprintf(stderr, "\n\t         bit   width = %d",pt.f_bw);
	fprintf(stderr, "\n\tinstr    digit width = %d",pt.i_dw);
	fprintf(stderr, "\n\n\n\n");

	return;
}
