#-h- cdsmem.asm                 2_55 ascii 03/06/85 13:30:00
;******************************************
;
;##		cdsmem.asm -- assembler version of /cdsmem/
;
;	Version for MS-DOS 2.00 in progress 2/29/84

heap segment word memory 'memory'

    ds_moat1 dw ds_moat1_size dup (DS_MOAT1_WORD)

    Mem dw DS_MEMSIZE dup (?)

    heap ends

; end of cdsmem.asm
#-t- cdsmem.asm                 2_55 ascii 03/06/85 13:30:00
#-h- dprimio.asm                8_12 ascii 03/06/85 13:30:00
;********************************************
;
;			DPRIMIO.ASM
;
;	Assembler version of the common block defined in DPRIMIO.
;
;	MS-DOS 2.00 version in progress 3/5/84
;
; Copyright (c) 1984 by Carousel MicroTools Inc., El Cerrito, CA, USA

dgroup group comads

dio segment word common 'common'

state	dw	MAXOFILES dup (?)
bfstrc	dw	MAXOFILES dup (?)

inuse	dw	MAXBUFSTRUCS dup (?)
handle	dw	MAXBUFSTRUCS dup (?)
dev	dw	MAXBUFSTRUCS dup (?)
bin	dw	MAXBUFSTRUCS dup (?)
wrt	dw	MAXBUFSTRUCS dup (?)
wbfsiz	dw	MAXBUFSTRUCS dup (?)
fname	dw	MAXBUFSTRUCS dup (MAXNAME dup (?))
filpos	  dd	MAXBUFSTRUCS dup (?)
bufptr	dw	MAXBUFSTRUCS dup (?)
bufadr	  dd	MAXBUFSTRUCS dup (?)
bufsiz	dw	MAXBUFSTRUCS dup (?)
bfstrt	  dd	MAXBUFSTRUCS dup (?)
fpos	dw	MAXBUFSTRUCS dup (?)
lastc	dw	MAXBUFSTRUCS dup (?)
dirty	dw	MAXBUFSTRUCS dup (?)
iserr	dw	MAXBUFSTRUCS dup (?)

dio ends

comads segment word public 'comads'
    dio_offset dw offset state
    dio_seg dw seg state
    comads ends

; End of dprimio.asm
#-t- dprimio.asm                8_12 ascii 03/06/85 13:30:00
#-h- libdefs.asm               40_68 ascii 03/06/85 13:30:00
;***********************************************
;
;##			LIBDEFS.ASM
;
;	Symbols to be included in assembler portion(s)
;		of Carousel library for Software Tools
;		on MS-DOS 2.00.
;	In progress 4/6/84.
;
; Copyright (c) 1984 by Carousel MicroTools Inc., El Cerrito, CA, USA

false	equ	0
true	equ	not false

OK	equ	0
ERR	equ	-3
EOF	equ	-1
CPMEOF	equ	26
eos	equ	0
YES	equ	1
NO	equ	0

NUL	equ	0
TAB	equ	9
CR	equ	13
LF	equ	10
NEWLINE	equ	LF
BLANK	equ	32
EQUALS	equ	61

MAXNAME		equ	65
FILENAMESIZE	equ	MAXNAME
MAXOFILES	equ	10
MAXBUFSTRUCS	equ	MAXOFILES+1

MS_ERROUT_HANDLE equ	2	; Handle for MS-DOS's ERROUT.
MS_STDERR_HANDLE equ	MS_ERROUT_HANDLE

DISK		equ	0
CONSOLE		equ	1
OTHER_DEV	equ	2
NULLDEV		equ	5
CONSOLE_IN	equ	9
CONSOLE_OUT	equ	10

				; Tools' access modes.
READ	equ	1
WRITE	equ	2
READWRITE equ	3
APPEND	equ	4

				; Tools' standard file descriptors.
STDIN	equ	1
STDOUT	equ	2
STDERR	equ	3
ERROUT	equ	STDERR

			; Dynamic store stuff
 DS_MEMSIZE_MAX equ 32700 ; max words we can use
 DS_MEMEND equ 1	; pointer to end of available memory
 DS_FIRST equ 2		; pointer to start of available memory
 DS_CLOSE equ 8		; threshhold for smallest allowed blocks
 DS_LINK equ 1		; block link pointer address
 DS_SIZE equ 0		; block size address
 DS_OHEAD equ 2		; block administration overhead
 DS_MEMGO equ 6		; first free index in common
 DS_MEMSIZE equ DS_MEMGO + 2*DS_OHEAD - 1 ; Must match ratdef!

 DS_MOAT1_SIZE equ 64	; in words
 DS_MOAT2_SIZE equ 64	; in words
 DS_MOAT1_WORD equ "SP"	; filler word (makes "PS" in memory)
 DS_MOAT2_WORD equ "DP" ; filler word (makes "PD" in memory)
 DS_STACKSIZE equ 1024  ; in words

			; Error return codes
			   ; Used by tool.com:
err_ctrlbrk	equ 10	   ;   ctrl-brk
err_bigline	equ 11	   ;   command line too long
err_nopath	equ 12	   ;   TOOLPATH= not found in environment
err_unexp	equ 13	   ;   unexpected error
			   ; Used by boxmain:
boxerr		equ 20	   ;   
			   ; Used by tools:
toolerr		equ 30	   ;

			; Symbol for savfst
FIRST_CONSTANT	equ	'ST'

			; Symbol for relcom
CDSMEM_BLK	equ	-47

			; Symbol for dosulk, isdir
NOT_FOUND	equ	2 ; Must differ from OK, ERR, YES, NO

			; Structure of a PSP
psp_env		equ	2ch
cmd_lth		equ	80h
cmd_line	equ	81h

ff_struc	struc		; For DOS version 2.00 function 4Eh

    ff_reserve		db 21 dup (?)
    ff_attr		db ?
    ff_time		dw ?
    ff_date		dw ?
    ff_size		dd ?
    ff_name		db 13 dup (?)

    ff_struc_size	db ?	; One extra byte to generate symbol
				;   for size of structure.
    ff_struc	ends

getnow_struc struc		; Array used by routine "getnow"
    getnow_year		dw ?
    getnow_month	dw ?
    getnow_day		dw ?
    getnow_hour		dw ?
    getnow_min		dw ?
    getnow_sec		dw ?
    getnow_msec		dw ?

    getnow_struc_size	db ?

    getnow_struc ends

				; Directory descriptor structure
dd_struc struc
    dd_reserve		dw (ff_struc_size + 1)/2 dup (?)
    dd_found_name	dw size ff_name dup (?)
    dd_found_size	dd ?
    dd_found_attr	dw ?	; Upper byte 0
    dd_found_date	dw (getnow_struc_size + 1)/2 dup (?)

				; fields below not to be used by
				;   assembler routines
    dd_good		dw ?
    dd_local		dw MAXNAME dup (?)

    dd_struc ends

				; Bitmasks for file attribute byte
RO_ATTR		equ	1h
HIDDEN_ATTR	equ	2h
SYSTEM_ATTR	equ	4h
VOLUME_ATTR	equ	8h
DIR_ATTR	equ	10h
ARCHIVE_ATTR	equ	20h
ATTR6_ATTR	equ	40h
ATTR7_ATTR	equ	80h

				; To interpret dates returned by
				;   function 4Eh
ms_base_year	equ	1980
ms_date record ms_year:7, ms_month:4, ms_day:5
ms_time record ms_hour:5, ms_min:6, ms_sec:5

ms_print_str	equ	9
ms_seldisk	equ	0eh
ms_set_dta	equ	1ah
ms_version	equ	30h
ms_cd		equ	3bh
ms_2_create	equ	3ch
ms_2_open	equ	3dh
ms_2_close	equ	3eh
ms_getch	equ	3fh
ms_putch	equ	40h
ms_unlink	equ	41h
ms_lseek	equ	42h
ms_chmod	equ	43h
ms_ioctl	equ	44h
ms_get_dir	equ	47h
ms_terminate	equ	4ch
ms_2_find_first	equ	4eh
ms_2_find_more	equ	4fh
ms_move		equ	56h
ms_file_date	equ	57h

				; DOS subfunctions etc.:
; CHMOD stuff:
chmod_get	equ	0
chmod_set	equ	1

; IOCTL stuff:
ioctl_g_info	equ	0	; Get device info
ioctl_s_info	equ	1	; Set device info
isdev_bit	equ	128	; Bit that indicates whether device.
bin_bit		equ	32	; Bit that indicates whether binary.
isnul_bit	equ	4	; whether this is the null device
iscot_bit	equ	2	; whether console output
iscin_bit	equ	1	; whether console input

; ms_file_date stuff:
ms_file_date_get equ	0	; Get handle date
ms_file_date_set equ	1	; Set handle date

				; MS-DOS 2.00 function error codes

ms_Inval_func			equ	1
ms_File_not_found		equ	2
ms_Path_not_found		equ	3
ms_Too_many_open		equ	4
ms_no_more_handles		equ	4
ms_no_handles_left		equ	4
ms_Acc_denied			equ	5
ms_Inval_handle			equ	6
ms_Mem_ctrl_blks_destroyed	equ	7
ms_Insuff_mem			equ	8
ms_Inval_mem_blk_addr		equ	9
ms_Inval_env			equ	10
ms_Inval_format			equ	11
ms_Inval_acc_code		equ	12
ms_Inval_data			equ	13
ms_Inval_drive_specified	equ	15
ms_Att_to_rem_curr_dir		equ	16
ms_Not_same_dev			equ	17
ms_No_more_files		equ	18
ms_no_files_left		equ	18

; End of LIBDEFS.ASM
#-t- libdefs.asm               40_68 ascii 03/06/85 13:30:00
#-h- mcall.asm                33_117 ascii 03/06/85 13:30:00
;;
;; MCALL - macros for assembly linkage
;; from Dr. Dobbs, #84, p100.
;;
;    with further macros--see after "******"
;    with new bend & bexit macros 1/20/84

@argdef	macro	argnames
  @nargs=0
  ifnb<argnames>
    irp	dummy,<argnames>
      @nargs=@nargs+2
    endm
    @i=@nargs+2
    irp arg,<argnames>
      arg&&@=@i
      ifndef arg
        arg  equ  [bp + arg&&@]
      endif
      @i=@i-2
    endm
endif
endm

@err	macro	msg
  if1
    %out msg
  endif
endm

@check	macro	extra,macname
  ifnb<extra>
    @err <you forgot angle brackets in macname macro>
  endif
endm

bentry	macro	func,argnames,mistake
  @nlv=0
  @nsr=0
  @savefl=0
  irp flag,<@ax,@bx,@cx,@dx,@si,@di,@ds,@ss,@es,@flags>
    flag=0
  endm
  ifb<func>
    @err  <missing function name on bentry macro>
  else
    @err  <!>!>!>Begin func>
  endif
  @check mistake,bentry
  @argdef <argnames>
func	proc
	push	bp
	mov	bp, sp
endm

auto	macro	vars,mistake
  if @savefl
    @err <***ERROR*** must not save before auto>
  endif
  @check mistake,auto
  irp var,<vars>
    var&&@=-(@nlv+2)
    ifndef var
      var equ [bp + var&&@]
    endif
    @nlv=@nlv+2
  endm
	sub	sp, @nlv
endm

@pop	macro	reg
  if @&reg
    ifidn<reg>,<flags>
	popf
    else
	pop	reg
    endif
  endif
endm

;bend	macro	func
;  ifb<func>
;    @err <Missing name on bend macro>
;  endif
;  @err <!<!<!<End func>
;func&_end:
;  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
;	@pop	reg
;  endm
;  if @nlv
;	add	sp, @nlv
;  endif
;	pop	bp
;	ret	@nargs
;func	endp
;endm

			; New macro 1/20/84 PLD.
bexit	macro
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
endm

			; New bend macro 1/20/84 PLD.
bend	macro	func
  ifb<func>
    @err <Missing name on bend macro>
  endif
  @err <!<!<!<End func>
func&_end:		;; bexit repeated here:
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
func endp
endm

@save	macro	r1,r2
ifidn<r1>,<r2>
  @&r1=1
  @found=1
endif
endm

save	macro	regs,mistake
  @savfl=1
  @check mistake,save
  irp reg,<regs>
    @found=0
    irp regname,<ax,bx,cx,dx,si,di,ds,ss,es,flags>
      @save regname,reg
    endm
    ife @found
      @err <***ERROR*** 'reg': Unknown register name in save>
    endif
  endm
  irp reg,<ax,bx,cx,dx,si,di,ds,ss,es,flags>
    if @&&reg
      ifidn<flags>,<reg>
	pushf
      else
	push	reg
      endif
    endif
  endm
endm

bcall	macro	func,args,mistake
  @check mistake,func
  ifnb<args>
    irp arg,<args>
	push	arg
    endm
  endif
	call	func
endm

;**********  New macros (not from Dr. Dobb's Journal):

@fargdef	macro	argnames
  @nargs=0
  ifnb<argnames>
    irp	dummy,<argnames>
      @nargs=@nargs+4
    endm
    @i=@nargs+2
    irp arg,<argnames>
      arg&&@=@i
      ifndef arg
        arg  equ  dword ptr [bp + arg&&@]
      endif
      @i=@i-4
    endm
endif
endm

fentry	macro	func,argnames,mistake
  @nlv=0
  @nsr=0
  @savefl=0
  irp flag,<@ax,@bx,@cx,@dx,@si,@di,@ds,@ss,@es,@flags>
    flag=0
  endm
  ifb<func>
    @err  <missing function name on fentry macro>
  else
    @err  <!>!>!>Begin func>
  endif
  @check mistake,fentry
  @fargdef <argnames>
func	proc	far
	public	func
	assume	ds:nothing, es:nothing, ss:nothing
	push	bp
	mov	bp, sp
endm

fexit	macro		;; bexit repeated here:
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
 endm

fend	macro	func		;; bend repeated here:
  ifb<func>
    @err <Missing name on bend macro>
  endif
  @err <!<!<!<End func>
func&_end:		;; bexit repeated here:
  irp reg,<flags,es,ss,ds,di,si,dx,cx,bx,ax>
	@pop	reg
  endm
  if @nlv
	add	sp, @nlv
  endif
	pop	bp
	ret	@nargs
func endp
 endm

dos_error	macro	fd
	les	bx,fd
	assume	es:nothing
	bcall	sys_err,<es:[bx],ax>
 endm

get_handle	macro	fd	;; Get file handle from
	les	bx,fd		;;   ST file descriptor.
	assume	es:nothing
	call	g_handle
 endm

put_handle	macro	fd	;; Given ST file descriptor
	les	bx,fd		;;   store the handle in AX into
	assume	es:nothing
	call	p_handle	;;   array "handle".
 endm
#-t- mcall.asm                33_117 ascii 03/06/85 13:30:00
#-h- prfx.asm                  3_118 ascii 03/06/85 13:30:00
;***************************************
;
;## prfx.asm -- assembler version of common block /prfx/
;
;	MS-DOS 2.00 version in progress 2/17/84

dgroup group comads

prfx segment word common 'common'

;    comptr	dd	?
;    comlen	dw	?
;    envptr 	dd	?
    flags	dw	12 dup (?)
    addr	dd	?
    toolnm	dw	9 dup (?)
    isdrct	dw	?

    prfx ends

comads segment word public 'comads'
    prfx_offset dw offset flags
    prfx_seg dw seg flags
    comads ends

; end of prfx.asm
#-t- prfx.asm                  3_118 ascii 03/06/85 13:30:00
