#-h- tsplit.r                    4600  ascii   08/27/81  14:09:31
#-h-  split                      2924  local   12/22/80  15:20:41
# split - split file into n-line pieces or at specified patterns

 #    include ratdef
define(NLINES,100)      # default lines/file
define(MAXFILES,676)    # maximum number of files; 676 = aa...zz
define(NAMESIZE,FILENAMESIZE)

DRIVER(split)
   character line(MAXLINE), prefix(NAMESIZE), from(MAXPAT), to(MAXPAT)
   integer getarg, open, maknam, getlin, ctoi, getpat, copyp, copyl
   integer fn, fin, fout, nl, i, ccase
   string x "x"

   nl = NLINES
   call scopy(x, 1, prefix, 1)
   fin = STDIN
   ccase = 1
   i = 1
   call query ("usage:  split [-n | +from [-to]] [file [out]].")
   if (getarg(i, line, MAXLINE) ^= EOF)
      {
      if (line(1) == MINUS & line(2) ^= EOS) {
         i = 2
         nl = ctoi(line, i)
         if (nl <= 0 | line(i) ^= EOS) {
            call remark("bad argument.")
            call error("usage: split [-n | +from [-to]] [file [name]].")
            }
         i = 2
         }
      else if (line(1) == PLUS) {
         ccase = 2
         if (getpat(line(2), from) == ERR)
            call error("illegal from pattern.")
         i = 2
         if (getarg(i, line, MAXLINE) ^= EOF)
            if (line(1) == MINUS & line(2) ^= EOS) {
               ccase = 3
               if (getpat(line(2), to) == ERR)
                  call error("illegal to pattern.")
               i = 3
               }
         }
   if (getarg(i, line, MAXLINE) ^= EOF) {
      if (line(1) == MINUS & line(2) == EOS)
         fin = STDIN
      else
         fin = open(line, READ)
      if (fin == ERR)
         call cant(line)
      }
     }
   if (getarg(i+1, line, MAXLINE) ^= EOF)
      call scopy(line, 1, prefix, 1)
   if (ccase == 1) {    # split [-n] [file [name]]
      for (fn = 1; getlin(line, fin) ^= EOF; fn = fn + 1) {
         fout = maknam(prefix, fn - 1)
         call putlin(line, fout)
         if (fn >= MAXFILES)    # copy everything if last file
            call fcopy(fin, fout)
        else if (copyl(fin, fout, nl-1) == EOF)
            break
         call close(fout)
         }
      }
   else if (ccase == 2) {       # split +from [file [name]]
      nl = copyp(fin, -1, line, from)
      for (fn = 1; nl ^= EOF; fn = fn + 1) {
         fout = maknam(prefix, fn - 1)
         call putlin(line, fout)
         if (fn >= MAXFILES)
            call fcopy(fin, fout)
         nl = copyp(fin, fout, line, from)
         call close(fout)
         }
      }
   else if (ccase == 3) {       # split +from -to [file [name]]
      for (fn = 1; copyp(fin, -1, line, from) ^= EOF; fn = fn + 1) {
         fout = maknam(prefix, fn - 1)
         call putlin(line, fout)
         if (fn >= MAXFILES)
            call fcopy(fin, fout)
         else
            if (copyp(fin, fout, line, to) ^= EOF)
               call putlin(line, fout)
         call close(fout)
         }
      }
   else
      call error("split: can't happen.")
   if (fin ^= STDIN)
      call close(fin)
   DRETURN
   end
#-t-  split                      2924  local   12/22/80  15:20:41
#-h-  copyl                       305  local   12/22/80  15:20:43
# copyl - copy n lines from fdi to fdo
   integer function copyl(fdi, fdo, n)
   integer fdi, fdo, n, i
   character line(MAXLINE)
   integer getlin

   for (i = 1; i <= n; i = i + 1)
      if (getlin(line, fdi) == EOF)
        return(EOF)
      else
         call putlin(line, fdo)
   return(i-1)
   end
#-t-  copyl                       305  local   12/22/80  15:20:43
#-h-  copyp                       418  local   12/22/80  15:20:43
# copyp - copy lines from fdi to fdo until line matching pat is found
   integer function copyp(fdi, fdo, buf, pat)
   integer fdi, fdo
   character buf(MAXLINE), pat(MAXPAT)
   integer n, match, getlin

   for (n = 0; getlin(buf, fdi) ^= EOF; n = n + 1)
      if (match(buf, pat) == YES)
         return (n)
      else if (fdo >= 0)        # fdo < 0 causes skips
         call putlin(buf, fdo)
   return (EOF)
   end
#-t-  copyp                       418  local   12/22/80  15:20:43
#-h-  maknam                      424  local   12/22/80  15:20:43
# maknam - create file n using prefix
   integer function maknam(prefix, n)
   character prefix(ARB)
   integer n
   character name(NAMESIZE)
   integer length, mod, create

   call scopy(prefix, 1, name, 1)
   i = length(name)
   name(i+1) = n/26 + LETA      # add aa, ab, etc.
   name(i+2) = mod(n, 26) + LETA
   name(i+3) = EOS
   maknam = create(name, WRITE)
   if (maknam == ERR)
      call cant(name)
   return
   end
#-t-  maknam                      424  local   12/22/80  15:20:43
#-t- tsplit.r                    4600  ascii   08/27/81  14:09:31
