#-h-  pl.r                       5478  ascii   02/02/82  13:39:50
#-h-  pl                         1226  local   12/24/80  12:58:11
# pl - print specified lines or pages of given files

 # include ratdef
 define(MAXBUF,3000)
 define(MAXLINES,200)
 define(EOL,-1)
 define(PAGESIZE,23)	# default page size

 DRIVER(pl)
   character arg(MAXLINE)
   integer getarg, open, ctoi, addset
   integer fd, i, j, l, u, lp, list(MAXLINES), pagsiz, pflag, junk

   pflag = NO
   i = 1
   pagsiz = 1
   list(1) = EOL
   call query ("usage:  pl [-pn] numbers [file].")
 for (i=1; getarg(i, arg, MAXLINE) != EOF; i=i+1)
   {
   if (arg(1) == MINUS & arg(2) != EOS)        # pick up flags
	{
	call doflag(arg, pflag, pagsiz)
	next
	}
    if (list(1) == EOL)	      # need some numbers
    	lp = gnum (arg, list)     # break out numbers
     else
	{
      if (arg(1) == MINUS & arg(2) == EOS)
         fd = STDIN
      else
         fd = open(arg, READ)
      if (fd == ERR)
         call cant(arg)
      if (list(1) == EOL)     # need some numbers
		call error ("usage:  pl [-pn] numbers [file].")
      call plines(fd, list, pagsiz)
      if (fd ^= STDIN)
         call close(fd)
      }
    }

   if (list(1) == EOL)
	call error ("usage:  pl [-pn] numbers [file].")
   if (fd == ERR)
           # no files specified
      call plines(STDIN, list, pagsiz)
    DRETURN
   end
#-t-  pl                         1226  local   12/24/80  12:58:11
#-h-  doflag                      462  local   12/24/80  12:58:11
 ## doflag - process flags for pl tool
 subroutine doflag (arg, pflag, pagsiz)
 character arg(ARB)
 integer pflag, pagsiz
 integer ctoi

 if (arg(2) == LETP | arg(2) == BIGP)	  # print pages
      {
      pflag = YES
      j = 3
      pagsiz = ctoi(arg, j)
      if (pagsiz < 0 | arg(j) ^= EOS)
         call error("bad page size.")
      if (pagsiz == 0)
         pagsiz = PAGESIZE	#default
      }
else
	call remark ("ignoring invalid argument.")
 return
 end
#-t-  doflag                      462  local   12/24/80  12:58:11
#-h-  get                         492  local   12/24/80  12:58:12
# get - get next n lines from fd into buf
   integer function get(n, buf, fd)
   integer n, fd
   character buf(MAXBUF)
   integer i
   character getch, c

   i = 1
   for (m = n; m > 0; m = m - 1) {
      while (getch(c, fd) ^= EOF) {
         if (i < MAXBUF) {
            buf(i) = c
            i = i + 1
            }
         if (c == NEWLINE)
            break
         }
      if (c == EOF)
         break
      }
   buf(i) = EOS
   if (c == EOF)
      return(EOF)
   return(n)
   end
#-t-  get                         492  local   12/24/80  12:58:12
#-h-  gnum                        883  local   12/24/80  12:58:12
 ## gnum - get numbers for pl tool
 integer function gnum (arg, list)
 integer list(ARB), lp, j
 character arg(ARB)
 integer ctoi

 lp = 0
 for (j=1; arg(j) ^= EOS;  )
	{
	lp = lp + 1
        if (lp > MAXLINES)
		call error ("too many numbers.")
	list(lp) = ctoi(arg, j)
	if (list(lp) <= 0)
		call error ("bad number.")
      if (arg(j) == MINUS) {	# have l-u specification
         j = j + 1
         u = ctoi(arg, j)
         l = list(lp)
         if ( u < l)
            call error("bad range.")
         for (l = l + 1; l <= u; l = l + 1)
	    {
            lp = lp + 1
	    if (lp > MAXLINES)
		call error ("too many numbers.")
	    list(lp) = l
	    }
         }
      while (arg(j) == COMMA | arg(j) == BLANK | arg(j) == TAB)
         j = j + 1
      }
 if (lp+1 > MAXLINES)
	call error ("too many numbers.")
 list(lp+1) = EOL
   call shell (list, lp)
 gnum = lp
 return
 end
#-t-  gnum                        883  local   12/24/80  12:58:12
#-h-  plines                      590  local   12/24/80  12:58:12
# plines - print pages from fd as specified in sorted list.
   subroutine plines(fd, list, pagsiz)
   integer fd, list(MAXLINES), pagsiz
   integer i, j, n, get, skip, len, junk
   character buf(MAXBUF)

   n = 0
   for (i = 1; list(i) ^= EOL; ) {
      if (skip(pagsiz*(list(i) - n - 1), fd) == EOF)
         return
      len = get(pagsiz, buf, fd)
      for (j = i; list(j) == list(i); i = i + 1)
         call putlin(buf, STDOUT)
      if (len == EOF)
         return
      n = list(j)
      }
   if (fd == STDIN)	# must flush standard input
      junk = skip(HUGE, fd)
   return
   end
#-t-  plines                      590  local   12/24/80  12:58:12
#-h-  shell                       576  local   12/24/80  12:58:12
 ## shell - Shell sort v(1)...v(n) increasing
 subroutine shell (v, n)
 integer gap, i, j, jg, k, n, v(ARB)

 for (gap=n/2; gap>0; gap=gap/2)
        for (i=gap+1; i<=n; i=i+1)
                for (j=i-gap; j>0; j=j-gap)
                        {
                        jg = j + gap
                        if (v(j) <= v(jg))      #compare
                                break
                        k = v(j)                #exchange
                        v(j) = v(jg)            #
                        v(jg) = k               #
                        }
 return
 end
#-t-  shell                       576  local   12/24/80  12:58:12
#-h-  skip                        325  local   12/24/80  12:58:13
# skip - skip n lines on fd
   integer function skip(n, fd)
   integer n, fd
   integer m
   character getch, c

   for (m = n; m > 0; m = m - 1) {
      while (getch(c, fd) ^= EOF)
         if (c == NEWLINE)
            break
      if (c == EOF)
         break
      }
   if (c == EOF)
      return(EOF)
   return(n)
   end
#-t-  skip                        325  local   12/24/80  12:58:13
#-t-  pl.r                       5478  ascii   02/02/82  13:39:50
