.hd basys "basic computer system simulator" 02/23/82
basys
.ds
'Basys' is a program designed to simulate a basic
computer system configuration consisting of a central
processing unit, a disk drive and a central memory.
It is a distribution driven simulator. In other words, the
work load under which the system is to be simulated
is characterized by probability distributions for such
factors as the time between job arrivals, the priority
of a job, the amount of memory required by a job, the
number of i/o requests a job will make, and so on.
.sp
When invoked, 'basys' asks the user for the following information:
.in +5
.de bl
.tc \
.ta 6
.sp
.ne 2
.ti -5
-\
.bf
[1]
.br
.en bl
.bl "simulation length"
The number of seconds for which the simulation run
should last is given here.  Note that this is simulated time, not real
time.
.bl "memory size"
This is the size of main memory in K-words.  All jobs
generated by the simulator have memory requirements
in the range 2K to 70K words; thus, the memory size specified should
probably be greater than or equal to 70.
.bl "time to compact memory"
This is the amount of time in microseconds required to compress
memory to make space available for a job.
.bl "per word disk transfer time"
This is the time in microseconds required to transfer one word
between disk and memory.
.bl "disk access time"
This is the time in milliseconds required to position the disk
head over the desired sector before a transfer takes place. It
includes both seek time and rotational latency.
.bl "i/o overhead time"
This is the overhead time in microseconds involved in the
initiation of an i/o request.
.bl "mean job interarrival time"
The time in milliseconds between job arrivals is generated
from an exponential distribution whose mean is specified here.
.bl "mean cpu time per job"
The number of milliseconds of cpu time required by each
job is generated from a normal distribution whose mean
and standard deviation are specified by this parameter
and the next.
.bl "standard deviation of cpu distribution"
The standard deviation (in milliseconds) of the per-job cpu time
distribution.
.bl "mean number of i/o requests per job"
The number of i/o requests that a job will make is determined by
a normal distribution for which the mean value is specified here.
.bl "standard deviation of i/o distribution"
The standard deviation of the distribution from which the
per-job number of i/o requests is generated is specified here.
.bl "minimum record size"
This is the minimum number of words in a single i/o transfer.
All transfers requested by a single job involve the same number
of words.
.bl "maximum record size"
The maximum number of words in an i/o transfer is specified here.
.bl "event trace"
If the user responds with "yes", 'basys' will print on standard output two
a listing
of all pertinent events as they are scheduled and as they occur.
Events traced are job arrival, memory request, cpu request,
cpu release, disk request, disk release and job termination.
WARNING: under reasonable durations of simulation, the
volume of output produced by this option is prohibitively
large.
.sp
.in -5
Upon completion of the simulation, 'basys' prints on standard output
one a three part report.  The first part is a summary of system
parameters as specified by the user.  The second part is a table
of job descriptions, sorted by ascending job number.  The table
gives a profile of each job that entered the system during the
simulation run.  Finally, a summary of how well the system performed
is printed.  Included in this part are statistics on utilization of
the three system resources: memory, cpu and disk, as well as statistics
on the wait queues for each of these resources.
.es
parameters> basys
basys  >report  >event_trace
.bu
Meaningless results accompany meaningless input.
.sp
Locally supported.
