.hd rf "original Ratfor preprocessor" 03/24/82
rf [-t | -p | -c]
   [ [-o <output file>] <input file> { <input file> } ]
.ds
'Rf' is an extended version of the Ratfor preprocessor described in
.ul
Software Tools.
For a complete description of 'rf', see the book.  For a summary
of Ratfor constructs, see
.ul
Software Tools
or the
.ul
Ratfor Programmer's Guide.
.sp
Note that 'rf' has been superseded by 'rp', and will not be supported
beyond Version 7 of the Subsystem.
.sp
The following is a summary of the differences between standard
Ratfor and the language accepted by 'rf':
.sp
.in +5
.tc \
.ta 6
.ti -5
1.\When supplied with no <file> arguments, 'rf' operates as a filter,
taking its input from standard input and writing its output on standard
output.
.sp
When any <input file> arguments are given, 'rf' takes its input
from the specified files.  If "-o[bl]<output[bl]file>" is specified as the
first argument, output is directed to <output[bl]file>.  Otherwise,
".f" will be appended to (or will replace a ".r" at the end of)
the first <input[bl]file> name to construct the name of the output file.
.sp
The table
of definitions is not cleared between the input files, so
definition files can be invoked without being added to the
source file(s).
.sp
.ti -5
2.\
Include statements are of the following format:
.sp
     include '<filename>'
     include "<filename>"
     include <filename>
.sp
where <filename> may be any valid Subsystem pathname. If, however,
the <filename> contains any non-alphanumeric characters, one of the
quoted forms
.bf
must
be used.
.sp
.ti -5
3.\'Rf' will accept upper or lower case input, and will map lower
case input to upper case, except in quoted strings.  Definitions are
case sensitive, however;  a lower case token appearing in the left-hand
side of a 'define' statement
will be replaced only if it appears as a lower case token in the text.
.sp
.ti -5
4.\'Rf' uses the tilde (~) for "not".  Thus, .ne.
would be represented as ~=.  An exclamation point may be used
instead of the tilde for the benefit of Teletype users.
.sp
.ti -5
5.\'Rf' will accept and discard an underline appearing within an
identifier.  For example, 'get_arg' will be interpreted as 'getarg'.  The
underline may not begin the identifier.
.sp
.ti -5
6.\'Rf' allows arbitrarily long identifiers and replaces them
with unique six-character names acceptable to the Fortran compiler.  The
generated names retain the first character so as not to disturb implicit
typing.
.sp
.ti -5
7.\The 'andif' and 'orif' constructs suggested in the exercises in
Software Tools have been added. Two syntactic forms are available
to invoke these constructs:
.sp
.in +5
The '||' and '&&' operators may be used in the condition part of
an if statement to specify orif and andif, respectively. If this
syntax is used, the condition
.bf
may not
contain nested parentheses.
.sp
The keywords 'orif' and 'andif' may be used explicitly. With this
syntax, an orif or andif statement may be preceded only by an
if statement or another orif or andif statement.
.sp
.in -5
.ti -5
8.\Multilevel break and next statements have been implemented. Syntax
is:
.sp
.nf
     break [ <integer> ]
     next  [ <integer> ]
.fi
.sp
The integer, if specified, determines how many surrounding loops
will be terminated or continued, respectively.  If omitted, 1
is assumed.
.sp
.ti -5
9.\A case statement has been implemented.  Syntax is as follows:
.sp
     case <variable> <compound statement>
     [ else <statement> ]
.sp
<Variable> is an integer variable whose value selects which of the
statements in the <compound statement> is to be executed: if the
variable's value is 1, the first statement is selected, etc.
At most one of the statements is performed.  If there is no statement
corresponding to the value of the variable, the <statement>
after "else" is executed if the "else" is present; otherwise,
execution resumes after the <compound statement>.
.sp
Currently, case statements may be nested to a depth of 10 and
may contain as many as 392 alternatives each.
.sp
.ti -5
10.\The string declaration has been implemented.  Syntax is
.sp
     string <variable> <quoted string>
.sp
String declarations must appear before the first executable
statement of a program unit.
.sp
.ti -5
11.\The "-p" option may be used to permit profiling studies to
be performed on Ratfor programs.  The option causes insertion of
code that, at run time, will record statistical information on
program performance.  Profiled programs will behave in exactly the
same way as they would normally, except that they will run
.bf
VERY SLOWLY.
The utility command 'profile' may be used
to print up a neat report of a profiled program's performance.
The files "timer_dictionary" and "_profile" are generated by
'rf' and the profiled program, respectively.
.sp
.ti -5
12.\The "-t" option may be used to cause an execution-time trace
of the Ratfor program.
The trace consists of an indented listing which indicates the
point of call and return for each subprogram.
.sp
.ti -5
13.\The "-c" option may be used to perform statement-level
profiling studies on Ratfor programs.
The option causes insertion of code that counts the number
of times each statement is executed and then writes the totals
to the file "_st_profile", where they may be read and summarized
by the utility program 'st_profile'.
The statement count statistics gathered by this option are
inherently more reliable (and probably more useful) than the
time measurements gathered by the "-p" option.
.sp
.in -5
.es
.nf
.ne 4
command line format:
     rf -p prog.r
     rf -o prog prog.r
     prog.r> rf -t >prog.f
.sp
.ne 6
orif and andif:
     if (c1 || c2 && c3 || c4)   statement1
     else   statement2
.sp
     if (c1) andif (c2) orif(c3)   statement1
     else    statement2
.sp
.ne 6
break and next:
     repeat {
        while (condition)
           if (c1)  break 2    # terminate repeat
           else     next 2     # continue repeat
       } until (c2)
.sp
.ne 8
case:
     case i {                      goto L4
        stmt1       is       L1    stmt1; goto L5
        stmt2   equivalent   L2    stmt2; goto L5
        stmt3       to       L3    stmt3; goto L5
        }                    L4    goto(L1,L2,L3),i
     else                          stmt4
        stmt4                L5    continue
.sp
.ne 8
profiling:
     rf -p prog.r; fc prog.f; ld prog.b -o prog
     prog
     profile | sp

     rf -c prog.r; fc prog.f; ld prog.b -o prog
     prog
     st_profile prog.r | sp
.fi
.fl
"timer_dictionary" for programs compiled with "-p" option.
.me
Extensive.  Most are self-explanatory.  See [ul Software Tools]
for a complete list.
.bu
<integer> must be followed by a NEWLINE in the multi-level break and next
statements.
.sp
'andif' and 'orif' constructs may not appear in 'while', 'for' or 'repeat'
statements.
.sp
When the statement-level profile option ("-c") is used, the count
displayed for each line is the total number of times all statements
on that line were executed;
thus, for example, the line
.nf
      repeat c = c + 1; until (prime (c) == YES)
.fi
will have a displayed count equal to three times the actual number
of loops (once for the 'repeat', once for the assignment, and
once for the test).
In addition, note that only the statements in the uppermost level
file are counted;  any code compiled as a result of an 'include'
will contribute to the total for that 'include'.
.sa
profile (1), st_profile (1), rp (1),
.ul
Software Tools
