[cc]mc |
.hd cobc "interface to Primos Cobol compiler" 08/27/84
[cc]mc
cobc {-<option>[<level>]} <input file>
         [-b [<binary file>]]
         [-l [<listing file>]]
         [-z <COBOL option>]
   <option> ::= d | m | v | x
.ds
'Cobc' serves as the Subsystem interface to the Primos Cobol compiler
(COBOL).
It examines its option specifications and checks them for consistency,
provides Subsystem-compatible default file names for the listing
and binary files as needed, and then produces a
Primos COBOL command and causes it to be executed.
.sp
.bf
Options
.sp
The general structure of an 'cobc' option is a single letter, possibly
followed by a "level number" indicating the extent to which an option
should be employed.
The following list outlines the options and the meanings of their
various levels.
The first line of each description contains the option letter
followed by its default level enclosed in parentheses,
the range of available levels enclosed in square brackets, and a
brief description of the option's purpose.
In all cases, when an option is specified without a level number,
the maximum allowable value is assumed.
.sp
.in +5
.de op <letter> <lwb> <upb> <default> <purpose>
.sp
.ne 5
.nf
.ti -5
-[1]([4]) @@@[[2]..[3]] - [5].
.fi
.en op
.op d 0 2 1 Debugging
.sp
Level 0 causes debugging statements in the source program
to be ignored.
.sp
Levels 1 and 2 cause debugging statements in the source
program to be compiled.
.op m 1 2 1 Addressing Mode
.sp
Level 1 causes the compiler to generate code in 64R mode.
.sp
Level 2 causes the compiler to generate code in 64V mode.
.op v 1 2 1 "Listing verbosity"
.sp
Level 1 generates a full source code listing containing the machine
code representation of each instruction.
.sp
Level 2 generates a full source code listing that includes the code
generated by all macro calls.
.op x 0 2 1 "Cross-reference listing control"
.sp
Level 0 causes the compiler to generate no cross reference
listing at the end of the source program listing.
.sp
Levels 1 and 2 cause the compiler to generate a full cross-reference
of all variables at the end of the source listing.
.in -5
.sp
In addition to the options above, the "-z" option allows the
explicit passing of a string verbatim into the command line.
.sp
.bf
File Control
.sp
The "-b" option is used to select the name of the file to receive the
binary object code output of the compiler.
If a file name follows the option, then that file receives the object
code.
(Note that if "/dev/null" is specified as the file name, no object code
will be produced.)
If the option is not specified, or no file name follows it, a default
filename is constructed from the input filename by changing its suffix
to ".b".
For example, if the input filename is "prog.cob", the binary file will be
"prog.b";
if the input filename is "foo", the binary file will be "foo.b".
.sp
The "-l" option is used to select the name of the file to receive the
listing generated by the compiler.
If a file name follows the option, then that file receives the listing.
The file name "/dev/null" may be used to inhibit the listing;
"/dev/tty" to cause it to appear on the user's terminal;
"/dev/lps" to cause it to be spooled to the line printer.
If the "-l" option is specified without a file name following it,
a default filename is constructed from the input filename by changing
its suffix to ".l".
For example, if the input filename is "gonzo.cob", the listing file will
be "gonzo.l";
if the input filename is "bar", the listing file will be "bar.l".
If the "-l" option is not used, no listing is produced.
.sp
The input filename may be either a disk file name (conventionally
ending in ".cob" or ".cobol")
or the device "/dev/tty", in which case input to the
compiler is read from the user's terminal.
.sp
In summary, then, the default command line for compiling a file named
"file.cob" is
.sp
.nf
     cobc -d1m1v1x1  file.cob  -b file.b  -l /dev/null
.sp
which corresponds to the COBOL command
.sp
     cobol -i *>file.cob -b *>file.b -l no
.sp
.fi
.es
cobc file.cob
cobc -xm2 payroll.cob -b b_payroll -l l_payroll
cobc -v2 funnyprog.cob -z"-newopt"
.me
.in +5
.ti -5
"Usage: cobc ..." for invalid option syntax.
.ti -5
"level numbers for -<option> are <lower bound> to <upper bound>" if
an out-of-range level number is specified.
.ti -5
"missing input file name" if no input filename could be found.
.ti -5
"<name>: unreasonable input file name" if an attempt was made to read
from the null device or the line printer spooler.
.ti -5
"<name>: unreasonable binary file name" if an attempt was made to
produce object code on the terminal or line printer spooler.
.ti -5
"inconsistency in internal tables" if the tables used to process
the options are incorrectly constructed.  This message indicates
a serious error in the operation of 'cobc' that should be reported
to your system administrator.
.in -5
.sp
Numerous other self-explanatory messages may be generated to diagnose
conflicts between selected options.
.bu
'Cobc' pays no attention to standard ports.
.sa
[cc]mc |
cobcl (1), ld (1), bind (3)
[cc]mc
