[cc]mc |
.hd csubc "interface to Prime DBMS Cobol subschema compiler" 08/27/84
[cc]mc
csubc <input file>
         [-l [<listing file>]]
         [-z <CSUBS option>]
.ds
'Csubc' serves as the Subsystem interface to the Prime DBMS
Cobol subschema compiler (CSUBS).
It examines its option specifications and checks them for consistency,
provides Subsystem-compatible default file names for the listing
and output files as needed, and then produces a
Primos CSUBS command and causes it to be executed.
.sp
The "-l" option is used to select the name of the file to receive the
listing generated by the compiler.
If a file name follows the option, then that file receives the listing.
If the "-l" option is specified without a file name following it
or is not specified,
a default filename is constructed from the input filename by changing
its suffix to ".l".
.nh
For example, if the input filename is "gonzo.csub", the listing file will
be "gonzo.l";
.hy
if the input filename is "bar", the listing file will be "bar.l".
.sp
The input filename must be a disk file name (conventionally
ending in ".csub").
.sp
In summary, then, the default command line for compiling a file named
"file.csub" is
.sp
.nf
     csubc  file.csub  -l file.l
.sp
which corresponds to the CSUBS command
.sp
     csubs -i *>file.csub -l *>file.l
.sp
.fi
.es
csubc file.csub
csubc payroll.csub -l l_payroll
csubc funnyprog.csub -z"-newopt"
.me
.in +5
.ti -5
"Usage: csubc ..." for invalid option syntax.
.ti -5
"missing input file name" if no input filename could be found.
.ti -5
"<name>: unreasonable input file name" if an attempt was made to read
from the null device or the line printer spooler.
.ti -5
"Sorry, the listing file must be a disk file" if the listing
file was directed to a device file.
.in -5
.bu
'Csubc' pays no attention to standard ports.

There is no way to avoid getting a listing file.
.sa
[cc]mc |
ddlc (1), cobc (1), cdmlc (1), ld (1), bind (3)
[cc]mc
