

            cobc (1) --- interface to Primos Cobol compiler          08/27/84


          | _U_s_a_g_e

                 cobc {-<option>[<level>]} <input file>
                          [-b [<binary file>]]
                          [-l [<listing file>]]
                          [-z <COBOL option>]
                    <option> ::= d | m | v | x


            _D_e_s_c_r_i_p_t_i_o_n

                 'Cobc' serves as the Subsystem interface to the Primos Cobol
                 compiler (COBOL).  It examines its option specifications and
                 checks  them  for consistency, provides Subsystem-compatible
                 default file names for  the  listing  and  binary  files  as
                 needed,  and then produces a Primos COBOL command and causes
                 it to be executed.

                 OOOppptttiiiooonnnsss

                 The general structure of an 'cobc' option is a  single  let-
                 ter,  possibly  followed  by a "level number" indicating the
                 extent to which an option should be employed.  The following
                 list outlines the options and the meanings of their  various
                 levels.   The  first  line  of each description contains the
                 option letter followed by  its  default  level  enclosed  in
                 parentheses,  the  range  of  available  levels  enclosed in
                 square brackets, and a brief  description  of  the  option's
                 purpose.   In all cases, when an option is specified without
                 a level number, the maximum allowable value is assumed.


                 -d(1) [0..2] - Debugging.

                      Level 0  causes  debugging  statements  in  the  source
                      program to be ignored.

                      Levels 1 and 2 cause debugging statements in the source
                      program to be compiled.

                 -m(1) [1..2] - Addressing.

                      Level  1  causes  the  compiler to generate code in 64R
                      mode.

                      Level 2 causes the compiler to  generate  code  in  64V
                      mode.

                 -v(1) [1..2] - Listing verbosity.

                      Level 1 generates a full source code listing containing
                      the machine code representation of each instruction.

                      Level  2  generates  a  full  source  code listing that
                      includes the code generated by all macro calls.



            cobc (1)                      - 1 -                      cobc (1)




            cobc (1) --- interface to Primos Cobol compiler          08/27/84


                 -x(1) [0..2] - Cross-reference listing control.

                      Level 0  causes  the  compiler  to  generate  no  cross
                      reference  listing  at  the  end  of the source program
                      listing.

                      Levels 1 and 2 cause the compiler to  generate  a  full
                      cross-reference  of  all  variables  at  the end of the
                      source listing.

                 In addition to the options above, the "-z" option allows the
                 explicit passing of a string verbatim into the command line.

                 FFFiiillleee CCCooonnntttrrrooolll

                 The "-b" option is used to select the name of  the  file  to
                 receive the binary object code output of the compiler.  If a
                 file  name  follows  the option, then that file receives the
                 object code.  (Note that if "/dev/null" is specified as  the
                 file  name, no object code will be produced.)  If the option
                 is not specified, or no file  name  follows  it,  a  default
                 filename  is constructed from the input filename by changing
                 its suffix to ".b".  For example, if the input  filename  is
                 "prog.cob",  the  binary file will be "prog.b"; if the input
                 filename is "foo", the binary file will be "foo.b".

                 The "-l" option is used to select the name of  the  file  to
                 receive  the  listing  generated by the compiler.  If a file
                 name  follows  the  option,  then  that  file  receives  the
                 listing.   The  file name "/dev/null" may be used to inhibit
                 the listing; "/dev/tty" to cause it to appear on the  user's
                 terminal;  "/dev/lps"  to cause it to be spooled to the line
                 printer.  If the "-l" option is  specified  without  a  file
                 name  following  it,  a default filename is constructed from
                 the input filename by changing  its  suffix  to  ".l".   For
                 example,  if  the input filename is "gonzo.cob", the listing
                 file will be "gonzo.l"; if the input filename is "bar",  the
                 listing  file  will  be  "bar.l".  If the "-l" option is not
                 used, no listing is produced.

                 The input filename may be either  a  disk  file  name  (con-
                 ventionally  ending  in  ".cob"  or  ".cobol") or the device
                 "/dev/tty", in which case input to the compiler is read from
                 the user's terminal.

                 In summary, then, the default command line for  compiling  a
                 file named "file.cob" is

                      cobc -d1m1v1x1  file.cob  -b file.b  -l /dev/null

                 which corresponds to the COBOL command

                      cobol -i *>file.cob -b *>file.b -l no





            cobc (1)                      - 2 -                      cobc (1)




            cobc (1) --- interface to Primos Cobol compiler          08/27/84


            _E_x_a_m_p_l_e_s

                 cobc file.cob
                 cobc -xm2 payroll.cob -b b_payroll -l l_payroll
                 cobc -v2 funnyprog.cob -z"-newopt"


            _M_e_s_s_a_g_e_s

                 "Usage:  cobc ..."  for invalid option syntax.
                 "level  numbers  for  -<option>  are <lower bound> to <upper
                      bound>" if an out-of-range level number is specified.
                 "missing input file name" if  no  input  filename  could  be
                      found.
                 "<name>:   unreasonable  input  file name" if an attempt was
                      made to read from the null device or the  line  printer
                      spooler.
                 "<name>:   unreasonable  binary file name" if an attempt was
                      made to produce object code on  the  terminal  or  line
                      printer spooler.
                 "inconsistency  in  internal  tables"  if the tables used to
                      process the options are incorrectly constructed.   This
                      message  indicates  a serious error in the operation of
                      'cobc'  that  should  be  reported   to   your   system
                      administrator.

                 Numerous other self-explanatory messages may be generated to
                 diagnose conflicts between selected options.


            _B_u_g_s

                 'Cobc' pays no attention to standard ports.


            _S_e_e _A_l_s_o

          |      cobcl (1), ld (1), bind (3)




















            cobc (1)                      - 3 -                      cobc (1)


