
-h- ncode.man	Tue Jan 20 11:02:55 1987	ncode.man



NCODE(1)            UNIX Programmer's Manual             NCODE(1)



NAME
     ncode  - stochastic text construction

SYNOPSIS
     ncode [-n number] [-g groupname] [-d] codefile

DESCRIPTION
     _N_c_o_d_e reads in a file of a certain format and randomly con-
     structs text based on the organization of the file.  Other
     files may be recursively included by putting

     #include pathname

     on any line of the file.  This is useful when you want to
     use a file of basic definitions, or groups, in different
     configurations.

     The -n flag is used to run the program through the main loop
     multiple times.

     A "group" name is defined as the word on the first line of
     the file and, more commonly, the word on each line following
     a line starting with "%".  The members of a group are all
     lines between the group name and the next "%".  When a group
     name is encountered, surrounded by any of a set of charac-
     ters called "white space" in this context, it is randomly
     expanded into one of its members.  Group names are not
     allowed to contain any white space, to prevent terminal con-
     fusion on the part of the program.

     The -g flag allows you to start the expanding process on a
     group name other than the default, which is "CODE".  The
     argument may be a group name, or an entire string including
     group names, just as if it were a line in the file.  It is
     legal to start on any group in the file, and groups may be
     referenced before or after the place in the file where they
     are defined.  In the case of duplicate group definitions,
     the first one occurring is the only one used.

     For example, here is a sample group definition:

          NOUN
          lamp
          house
          car
          %

     The line "See the NOUN." could be randomly expanded to say
     "See the lamp."

     The characters considered "white" for the purpose of bound-
     ing a group name, besides what is normally considered white



Printed 12/29/86              Pixar                             1






NCODE(1)            UNIX Programmer's Manual             NCODE(1)



     space, are currently:

          | \ .  - : ; , ! ? [ ] { } () ' " `

     Two of those characters have special meanings to _n_c_o_d_e. The
     "|" symbol allows you to "splice" things to a group name.
     When it is encountered, no character is printed on output.
     The "\" causes a newline to be printed on output.

     The simplest application would be for a "fortune" program,
     but _n_c_o_d_e could also be used for more complex things such as
     a rumor generating file.  The group definitions will be left
     as an exercise for the reader, but the following example
     should prove illuminating:

     CODE
     It was rumored today that COMPANY will be bought by COMPANY for PRICE\.
     PERSON, POSITION of COMPANY, said that PRODUCT will be announced DATE\.

     Note that every string to be expanded must be on only one
     line of the file.  The program now dynamically allocates
     memory in a very general way, so the total size of your
     input files and the length of the lines in the files is lim-
     ited only by how much memory you can get.  The only hard
     limit is that a group name can't be over 4096 characters
     long.  If you can't come up with a unique group name in
     fewer characters then don't blame me.

BUGS
     No bugs.  Only features that you haven't figured out how to
     use yet.  A recent improvement makes it tolerant of blank
     lines following the last % in a #include file.

DIAGNOSTICS
     Standard perror() stuff.  Pretty self explanatory.  A bogus
     input file might benignly yield cryptic results.

AUTHOR
     Craig Good

