.TH solve 1
.SH NAME
solve - interactive equation solver 
.SH SYNOPSIS
.B solve
file
.SH DESCRIPTION
.I Solve
interprets a set of related equations and tries to solve them using only 
values entered interactively by the user. 
.I Solve 
is intended to look somewhat like TK!SOLVER. 
The equations are read in from a file at startup time.
.SH FILE FORMAT
.br
equations: 	/* empty */
.br
	|	equations equation \n
.br
	;
.br

.br
equation:	VAR_NAME = expression
.br
	;
.br

.br
expression:	VAR_NAME
.br
	|	NUMBER
.br
	|	expression + expression
.br
	|	expression - expression
.br
	|	expression * expression
.br
	|	expression / expression
.br
	|	expression % expression
.br
	|	expression ^ expression
.br
	|	- expression
.br
	|	( expression )
.br
	;
.br
.SH RUNTIME COMMANDS
.br
.B u
- move the cursor up
.br
.B d
-  move the cursor down
.br
.B q
-  exit to the shell
.br
.B a
- add new value 
.br
.B D
- delete current entry
.br
.B S
- solve equations
.SH EXAMPLE FILE
.PP
.br
monthly_interest = yearly_interest / 12.0
.br
months = years * 12.0
.br
payments = principle * monthly_interest / (1.0 - 
.br
		(1.0 + monthly_interest) ^ -months)
.br
costOfLoan = payments * months - principle
.br
.SH BUGS
Probably a lot of them.
