compound

Compound is an interactive program that asks you questions in order
to compute total money after compound interest has been accumulated.

There are two different parts (part 1 vs. part 2 computation occurs
based on how you answer the first question).

Part 1 assumes interest is compounded on a single deposit made.

Part 2 assumes interest is compounded on multiple deposits that are made
regularly at the same frequency.  The total amount is then printed.
The amount printed does not include the final deposit at the end of
the final period.

In addition, compound asks you for the inflationary rate, so that you
may see how much that grand total would really be worth, but in buying
power measured in today's dollars.  For example, that $17.6 million
($2000 deposited regularly for 40 years at 20% interest in Fidelity Mutuals)
dwindles to $2.2 million when there is 5% inflation.

Example - part 1

An example would be a deposit of a sum into a bank that compounds
money quarterly at 4% annually.  Suppose you put $100 in on
Dec 31, 1969, and want to know how much there will be at the end of
Dec 31, 1970, one year later.  Each interest period yields 1%
interest four times that year:
	Deposit		$100
	3 months	$100 * 1.01 = 101.00
	6 months	($101.00 * 1.01) = 101.00 + 1.01 = $102.01
	9 months	$102.01 * 1.01 = 102.01 + 1.0201 = 103.0301
	12 months	$103.0301 * 1.01 = 103.0301 + 1.030301 = 104.060401
Because of floating point arithmetic round-off, the actual answer printed
(on a cci632 with FLOAT defined as float)  is 104.060402, or
(on a cci632 with FLOAT defined as double) is 104.060401.

Example - part 2

For example, depositing $10 each quarter at 4%
compounded quarterly.  At the end of 3 quarters you have:
for two quarters:
	Start with $100
	End of 1st quarter	($100 * 1.01 + 100) = 101.00 + 100 = 201.00
	End of 2nd quarter	201 * 1.01 + 100 = 201 + 2.01 + 100 = 303.01
	End of 3rd quarter	303.01 * 1.01 + 100 = 303.01 + 3.0301 + 100
						    = 406.0401
	End of 4th quarter	406.0401 * 1.01 + 0 = 406.0401 + 4.060401
						    = 410.100501
(Note that each quarter is the previous quarter plus 1% (interest),
plus $100 (deposit), and note that $100 is not deposited at the end
of the 4th quarter.)
The actual number printed is slightly different because of floating point
round-offs (410.100616 on cci632).

Bugs:
	Round-off errors in floating point arithmetic.

	In real life, if you deposit into a bank that compounds quarterly,
	your money earns no interest from the time of deposit until the
	beginning of the next quarter.  So if you deposit Jan 1, but
	Dec 31st was the beginning of the quarter, you may have entered
	the wrong number of periods.  Check your bank for details.

(TODO)	In part 2, it is assumed that the time period of the contributions
	(deposits) is equal to the time period at which the compounding
	occurs.  In other words it is presently not possible to do either
	of the two following:

(TODO)		- interest period less than deposit period, for example,
		  interest compounded daily, but contributions bi-weekly

(TODO)		- interest period greater than deposit period, for example,
		  every two weeks your employer directly deposits a fixed
		  amount of money into a bank that compounds quarterly.
		  (note that the bank is taking advantage of your money
		  every quarter, that is, the bank is borrowing your
		  money free-of-charge for a maximum time of 3 months
		  as long as you continue depositing there).

	I assume that if interest is compounded monthly, that each
	month yields the same r/12 % interest, where r = annual interest,
	regardless of the number of days in a month.  If a bank
	weights monthly interest based on the length of the month,
	this program will not agree with the bank. (I have never
	heard of such a thing, but you never can tell).

Notes:
	On a leap year with 366 days, and you are compounding interest
	daily for one year, enter 366 as the number of periods per
	year, and enter 366 as the total number of periods.

