PATH=/local/bin:/usr/local/bin:$PATH
#!/bin/sh
# '@(#) uuhosts.sh 1.69 86/01/06'
# uuhosts - UUCP mail and USENET news information

MAPS=/usr/spool/news/maps
UUCPMAPGROUP=mod.map
UUCPMAP=$UUCPMAPGROUP
RUUHOSTS=uuhosts
DEFPAGER=cat
GREP=grep
pager="${PAGER-$DEFPAGER}"

case $RUUHOSTS in
"")
	;;
*)
	if [ ! -d $MAPS/$UUCPMAP ]; then
		client $RUUHOSTS uuhosts $* | $pager
		exit
	fi
	;;
esac

BIN=/usr/local
LIB=/usr/local/lib
NEWS=$LIB/news
MAPSH=$NEWS/mapsh
UUCPSPOOL=/usr/spool/news/mod/map
PATHS=$LIB/nmail.paths
WHERE=$LIB/nmail.where
LOOK=1
COMPRESS=1
case $COMPRESS in
"")
	zcat=cat
	;;
*)
	zcat=zcat
	;;
esac

case $1 in
	-setup)
		# Initial setup.  Should only need to be done once.
		ls $UUCPSPOOL/[0-9]* > $MAPS/$UUCPMAP/Batch
		exec $BIN/uuhosts -unbatch
		exit 1
	;;

	-unbatch)
		# Unbatch map articles batched by inews.  Called from cron.
		cd $MAPS/$UUCPMAP
		if [ -f Batch ]; then
			:
		else
			exit 1
		fi
		mv Batch Batch.working
		for f in `cat Batch.working`
		do
			$BIN/uuhosts -x < $f
			sleep 60
		done
		rm Batch.working
		exec $BIN/uuhosts -i
		exit 1
	;;

	-x)
		# extract a new map piece into a map directory
		temphead=/tmp/maphead.$$
		temptext=/tmp/maptext.$$
		tempcomm=/tmp/mapcomm.$$
		cp /dev/null $temphead
		cp /dev/null $temptext
		echo 'exec /bin/mail postmaster' > $tempcomm
		echo 'Reply-To: postmaster' > $temphead
		awk '
BEGIN	{
	temphead = "'$temphead'"; tempcomm = "'$tempcomm'";
	isuucpmap = 1;	# Assume most postings are map entries.
	shead = 0; stext = 1; suucp = 2;
	state = shead;
}
state == shead && ($1 == "From:" || $1 == "Sender:" \
    || $1 == "Date:" || $1 == "Message-ID:" || $1 == "Message-Id:") {
	print "Original-" $0 >> temphead;
	next;
}
state == shead && $1 == "Newsgroups:" {	# no cross-postings allowed
 	if ($2 != "'$UUCPMAPGROUP'") {
		isuucpmap = 0;
 		print "Bad-Newsgroups: " $2 " (should be '"$UUCPMAPGROUP"')" \
 			>> temphead;
 		next;
	}
}
state == shead && $1 == "Subject:" {
	# the odd initial test is to avoid certain brain damaged awks
	if ("X" ~ /X/ \
	&& $2 !~ /^UUCP/ && $2 !~ /^uucp/ && $2 !~ /^Uucp/) {
		print "Subject:  not a map update" >> temphead;
		print "Original-" $0 >> temphead;
		isuucpmap = 0;
	} else
		print $0 >> temphead;
	next;
}
state == shead && /^$/	{
	if (isuucpmap != 0) {
	print "PATH=/bin; umask 0002; cd '$UUCPMAP'" | "'$MAPSH'";
		state = suucp;
	} else
		state = stext;
}
state == shead {
		print $0 >> temphead;
}
state == suucp	{
	print | "'$MAPSH'";
}
state == stext	{
	print;
}
' > $temptext 2>&1
		cat $temphead $temptext | sh $tempcomm
		rm -f $temphead $temptext $tempcomm
		exit 0
	;;

	-compress)
		case $COMPRESS in
		"")
			exit
			;;
		esac
		cd $MAPS/$UUCPMAP
		if [ -f README ]; then
			compress -f README
		fi
		compress -f [a-z]*.*[a-z0-9]
		exit 0
	;;

	-i)
		# Create the Index used for fast lookups.
		cd $MAPS/$UUCPMAP
		$BIN/uuhosts -compress
		for file in [a-z]*.*
		do
			f=`basename $file .Z`
			$zcat $f |
			sed -n -e "s/,/ /g" -e "/^#N/s/#N[	 ]*//p" |
			awk 'BEGIN { filename = "'"$f"'" }
			{
				for (x=1; x<=NF; x++)
					printf("%s\t%s\n", $x, filename);
			}'
		done | sort -f > Index.$$
 		mv Index.$$ Index
		if [ -f $LIB/uuwhere ]; then
			$LIB/uuwhere
		fi
		exit 0
	;;

	-r)
		# by region
		cd $MAPS/$UUCPMAP
		shift
		case $# in
		0)
			exec ls
			exit 1
		;;
		esac
		case $COMPRESS in
		"")
			exec $pager $*
			exit 1
			;;
		*)
			zcat $* | $pager
			exit 0
			;;
		esac
		exit 1
	;;

	-u)
		exec $BIN/uuhosts -r
		exit 1
	;;

	-n)
		exec $BIN/uuhosts -r
		exit 1
	;;

	-k)
		# by keyword
		cd $MAPS/$UUCPMAP
		shift
		$zcat [a-z]*.* | awk '
BEGIN		{ inside = 1; outside = 0; state = outside; }
/^#N/ && state == inside	{
	if (useit == 1) {
		for (i = 0; i < count; i++) {
			print block[i];
		}
	}
	state = outside;
}
/^#N/	{ state = inside; count = 0; useit = 0; }
state == inside	{ block[count++] = $0; }
/'"$*"'/	{ useit = 1; }
END {
	if (useit == 1) {
		for (i = 0; i < count; i++) {
			print block[i];
		}
	}
}
' | $pager
		exit 0
	;;

	-*)
		# unknown option
	;;

	"")
		# no arguments
	;;

	*)
		# by host name
		case $LOOK in
		"")
			look=$GREP
			lookopt="^"
			;;
		*)
			look=look
			lookopt="-f "
			;;
		esac
		for arg in $*
		do
			echo "UUCP mail path from `uuname -l` to $arg:"
			$look $lookopt$arg $PATHS
# 			uupath $arg
			case $WHERE in
			"")
				;;
			*)
			if [ -f $WHERE ]; then
			echo "UUCP mail path for $arg annotated by location:"
				$look $lookopt$arg $WHERE
			fi
				;;
			esac
			echo "
UUCP mail information for host $arg (#USENET lines show USENET news links):"
			cd $MAPS/$UUCPMAP
# Find the Index entry for the host with look or sed.
# Select the file name(s) with sed.
# Uncompress the file and select the appropriate lines with sed.
			case $look in
			*look*)
				files=`$look $lookopt$arg Index |
				sed -n -e "/^$arg/s%.*	%%p"`
				;;
			*)
				files=`
				sed -n -e "/^$arg/s%.*	%%p" Index`
				;;
			esac
			case $files in
			"")
				continue
				;;
			esac
			$zcat $files | sed -n -e ":toss
/#N.*[	 ]*$arg/bcopy
d
btoss
:copy
s/^#N/#Name		/
p
n
:copy2
/^#N/btoss
s/^#S/#System-CPU-OS	/
s/^#O/#Organization	/
s/^#C/#Contact	/
s/^#E/#Electronic-Address/
s/^#T/#Telephone	/
s/^#P/#Postal-Address	/
s/^#L/#Latitude-Longitude/
s/^#R/#Remarks	/
s/^#W/#Written-by	/
s/^#U/#USENET/
p
n
bcopy2"
		done | $pager
		exit 0
	;;
esac

echo 'Usage:	uuhosts hostname ...
for information about a particular UUCP or USENET host or hosts, or

	uuhosts -r region
for information about hosts in a region of the UUCP or USENET networks, or

	uuhosts -r
for a list of known regions.

See uuhosts(1) or "uuhosts -r README" for further details.
'
exit 1
