/*
character name and code tables
default width tables
modified for BTL special font version 4
and Commercial II
*/

int chtab [] {
'hy', 0200,	/*hyphen*/
'bu', 0201,	/*bullet*/
'sq', 0202,	/*square*/
'em', 0203,	/*3/4em*/
'ru', 0204,	/*rule*/
'14', 0205,	/*1/4*/
'12', 0206,	/*1/2*/
'34', 0207,	/*3/4*/
'mi', 0302,	/*equation minus*/
'fi', 0211,	/*fi*/
'fl', 0212,	/*fl*/
'ff', 0213,	/*ff*/
'Fi', 0214,	/*ffi*/
'Fl', 0215,	/*ffl*/
'de', 0216,	/*degree*/
'dg', 0217,	/*dagger*/
'sc', 0220,	/*section*/
'fm', 0221,	/*foot mark*/
'aa', 0222,	/*acute accent*/
'ga', 0223,	/*grave accent*/
'ul', 0224,	/*underrule*/
'sl', 0225,	/*slash (longer)*/
'*a', 0230,	/*alpha*/
'*b', 0231,	/*beta*/
'*g', 0232,	/*gamma*/
'*d', 0233,	/*delta*/
'*e', 0234,	/*epsilon*/
'*z', 0235,	/*zeta*/
'*y', 0236,	/*eta*/
'*h', 0237,	/*theta*/
'*i', 0240,	/*iota*/
'*k', 0241,	/*kappa*/
'*l', 0242,	/*lambda*/
'*m', 0243,	/*mu*/
'*n', 0244,	/*nu*/
'*c', 0245,	/*xi*/
'*o', 0246,	/*omicron*/
'*p', 0247,	/*pi*/
'*r', 0250,	/*rho*/
'*s', 0251,	/*sigma*/
'*t', 0252,	/*tau*/
'*u', 0253,	/*upsilon*/
'*f', 0254,	/*phi*/
'*x', 0255,	/*chi*/
'*q', 0256,	/*psi*/
'*w', 0257,	/*omega*/
'*A', 0101,	/*Alpha*/
'*B', 0102,	/*Beta*/
'*G', 0260,	/*Gamma*/
'*D', 0261,	/*Delta*/
'*E', 0105,	/*Epsilon*/
'*Z', 0132,	/*Zeta*/
'*Y', 0110,	/*Eta*/
'*H', 0262,	/*Theta*/
'*I', 0111,	/*Iota*/
'*K', 0113,	/*Kappa*/
'*L', 0263,	/*Lambda*/
'*M', 0115,	/*Mu*/
'*N', 0116,	/*Nu*/
'*C', 0264,	/*Xi*/
'*O', 0117,	/*Omicron*/
'*P', 0265,	/*Pi*/
'*R', 0120,	/*Rho*/
'*S', 0266,	/*Sigma*/
'*T', 0124,	/*Tau*/
'*U', 0270,	/*Upsilon*/
'*F', 0271,	/*Phi*/
'*X', 0130,	/*Chi*/
'*Q', 0272,	/*Psi*/
'*W', 0273,	/*Omega*/
'sr', 0274,	/*square root*/
'ts', 0275,	/*terminal sigma*/
'rn', 0276,	/*root en*/
'>=', 0277,	/*>=*/
'<=', 0300,	/*<=*/
'==', 0301,	/*identically equal*/
'~=', 0303,	/*approx =*/
'ap', 0304,	/*approximates*/
'!=', 0305,	/*not equal*/
'->', 0306,	/*right arrow*/
'<-', 0307,	/*left arrow*/
'ua', 0310,	/*up arrow*/
'da', 0311,	/*down arrow*/
'eq', 0312,	/*equation equal*/
'mu', 0313,	/*multiply*/
'di', 0314,	/*divide*/
'+-', 0315,	/*plus-minus*/
'cu', 0316,	/*cup (union)*/
'ca', 0317,	/*cap (intersection)*/
'sb', 0320,	/*subset of*/
'sp', 0321,	/*superset of*/
'ib', 0322,	/*improper subset*/
'ip', 0323,	/*  " superset*/
'if', 0324,	/*infinity*/
'pd', 0325,	/*partial derivative*/
'gr', 0326,	/*gradient*/
'no', 0327,	/*not*/
'is', 0330,	/*integral sign*/
'pt', 0331,	/*proportional to*/
'es', 0332,	/*empty set*/
'mo', 0333,	/*member of*/
'pl', 0334,	/*equation plus*/
'rg', 0335,	/*registered*/
'co', 0336,	/*copyright*/
'br', 0337,	/*box vert rule*/
'ct', 0340,	/*cent sign*/
'dd', 0341,	/*dbl dagger*/
'rh', 0342,	/*right hand*/
'lh', 0343,	/*left hand*/
'**', 0344,	/*math * */
'bs', 0345,	/*bell system sign*/
'or', 0346,	/*or*/
'ci', 0347,	/*circle*/
'lt', 0350,	/*left top (of big curly)*/
'lb', 0351,	/*left bottom*/
'rt', 0352,	/*right top*/
'rb', 0353,	/*right bot*/
'lk', 0354,	/*left center of big curly bracket*/
'rk', 0355,	/*right center of big curly bracket*/
'bv', 0356,	/*bold vertical*/
'lf', 0357,	/*left floor (left bot of big sq bract)*/
'rf', 0360,	/*right floor (rb of ")*/
'lc', 0361,	/*left ceiling (lt of ")*/
'rc', 0362,	/*right ceiling (rt of ")*/
0,0};
/* if 0200 is set char is a member of the special font set */
char codetab[256-32] {	/*vidoecomp 500 codes*/
00,	/*space*/
0115,	/*!*/
0371,	/*"*/
0200,	/*#*/
0166,	/*$*/
0164,	/*%*/
020,	/*&*/
0171,	/*' close*/
0161,	/*(*/
0162,	/*)*/
0163,	/***/
0,	/*+*/
013,	/*,*/
0167,	/*- hyphen*/
012,	/*.*/
0141,	/*/*/
060,	/*0*/
061,	/*1*/
062,	/*2*/
063,	/*3*/
064,	/*4*/
065,	/*5*/
066,	/*6*/
067,	/*7*/
070,	/*8*/
071,	/*9*/
0114,	/*:*/
014,	/*;*/
0264,	/*<*/
0,	/*=*/
0263,	/*>*/
0015,	/*?*/
0200,	/*@*/
0101,	/*A*/
0102,	/*B*/
0103,	/*C*/
0104,	/*D*/
0105,	/*E*/
0106,	/*F*/
0107,	/*G*/
0110,	/*H*/
0111,	/*I*/
0121,	/*J*/
0122,	/*K*/
0123,	/*L*/
0124,	/*M*/
0125,	/*N*/
0126,	/*O*/
0127,	/*P*/
0130,	/*Q*/
0131,	/*R*/
0142,	/*S*/
0143,	/*T*/
0144,	/*U*/
0145,	/*V*/
0146,	/*W*/
0147,	/*X*/
0150,	/*Y*/
0151,	/*Z*/
0,	/*[*/
0200,	/*\*/
0200,	/*]*/
0200,	/*^*/
0160,	/*_ dash*/
0170,	/*` open*/
01,	/*a*/
02,	/*b*/
03,	/*c*/
04,	/*d*/
05,	/*e*/
06,	/*f*/
07,	/*g*/
010,	/*h*/
011,	/*i*/
021,	/*j*/
022,	/*k*/
023,	/*l*/
024,	/*m*/
025,	/*n*/
026,	/*o*/
027,	/*p*/
030,	/*q*/
031,	/*r*/
042,	/*s*/
043,	/*t*/
044,	/*u*/
045,	/*v*/
046,	/*w*/
047,	/*x*/
050,	/*y*/
051,	/*z*/
0200,	/*{*/
0,	/*|*/
0200,	/*}*/
0200,	/*~*/
0,	/*narrow space*/
0167,	/*hyphen*/
0,	/*bullet*/
0,	/*square*/
0,	/*3/4 em*/
0,	/*rule*/
0,	/*1/4*/
0,	/*1/2*/
0,	/*3/4*/
0165,	/*minus*/
0,	/*fi*/
0,	/*fl*/
0,	/*ff*/
0,	/*ffi*/
0,	/*ffl*/
0,	/*degree*/
0,	/*dagger*/
0200,	/*section*/
0370,	/*foot mark*/
0200,	/*acute accent*/
0200,	/*grave accent*/
0200,	/*underrule*/
0200,	/*slash (longer)*/
00,	/**/
00,	/**/
0201,	/*alpha*/
0202,	/*beta*/
0203,	/*gamma*/
0204,	/*delta*/
0205,	/*epsilon*/
0251,	/*zeta*/
0210,	/*eta*/
0207,	/*theta*/
0211,	/*iota*/
0222,	/*kappa*/
0223,	/*lambda*/
0224,	/*mu*/
0225,	/*nu*/
0206,	/*xi*/
0226,	/*omicron*/
0227,	/*pi*/
0231,	/*rho*/
0242,	/*sigma*/
0243,	/*tau*/
0244,	/*upsilon*/
0230,	/*phi*/
0247,	/*chi*/
0250,	/*psi*/
0246,	/*omega*/
0303,	/*Gamma*/
0304,	/*Delta*/
0307,	/*Theta*/
0323,	/*Lambda*/
0306,	/*Xi*/
0327,	/*Pi*/
0342,	/*Sigma*/
0,	/**/
0344,	/*Upsilon*/
0330,	/*Phi*/
0350,	/*Psi*/
0346,	/*Omega*/
0200,	/*square root*/
0200,	/*terminal sigma (was root em)*/
0200,	/*root en*/
0267,	/*>=*/
0270,	/*<=*/
0271,	/*identically equal*/
0365,	/*equation minus*/
0362,	/*approx =*/
0360,	/*approximates*/
0261,	/*not equal*/
0200,	/*right arrow*/
0200,	/*left arrow*/
0200,	/*up arrow*/
0200,	/*down arrow*/
0260,	/*equation equal*/
0315,	/*multiply*/
0363,	/*divide*/
0366,	/*plus-minus*/
0200,	/*cup (union)*/
0200,	/*cap (intersection)*/
0200,	/*subset of*/
0200,	/*superset of*/
0200,	/*improper subset*/
0200,	/* improper superset*/
0220,	/*infinity*/
0200,	/*partial derivative*/
0200,	/*gradient*/
0200,	/*not*/
0200,	/*integral sign*/
0200,	/*proportional to*/
0200,	/*empty set*/
0200,	/*member of*/
0364,	/*equation plus*/
0200,	/*registered*/
0200,	/*copyright*/
0200,	/*box rule (was parallel sign)*/
0200,	/*cent sign*/
0200,	/*dbl dagger*/
0200,	/*right hand*/
0200,	/*left hand*/
0200,	/*math * */
0200,	/*bell system sign*/
0200,	/*or (was star)*/
0200,	/*circle*/
0200,	/*left top (of big curly)*/
0200,	/*left bottom*/
0200,	/*right top*/
0200,	/*right bot*/
0200,	/*left center of big curly bracket*/
0200,	/*right center of big curly bracket*/
0200,	/*bold vertical*/
0200,	/*left floor (left bot of big sq bract)*/
0200,	/*right floor (rb of ")*/
0200,	/*left ceiling (lt of ")*/
0200};	/*right ceiling (rt of ")*/
int W1[256-32] {	/*Times Roman widths*/
192,	 /*space*/
44,	 /*!*/
0,	 /*"*/
0,	 /*#*/
100,	 /*$*/
200,	 /*%*/
150,	 /*&*/
52,	 /*' close*/
68,	 /*(*/
68,	 /*)*/
100,	 /***/
0,	 /*+*/
52,	 /*,*/
64,	 /*- hyphen*/
52,	 /*.*/
100,	 /*/*/
100+02000, /*0*/
100+02000, /*1*/
100+02000, /*2*/
100+02000, /*3*/
100+02000, /*4*/
100+02000, /*5*/
100+02000, /*6*/
100+02000, /*7*/
100+02000, /*8*/
100+02000, /*9*/
52,	 /*:*/
52,	 /*;*/
0,	 /*<*/
0,	 /*=*/
0,	 /*>*/
80,	 /*?*/
0,	 /*@*/
164+02000, /*A*/
138+02000, /*B*/
148+02000, /*C*/
172+02000, /*D*/
146+02000, /*E*/
136+02000, /*F*/
170+02000, /*G*/
164+02000, /*H*/
80+02000, /*I*/
92+02000, /*J*/
166+02000, /*K*/
145+02000, /*L*/
192+02000, /*M*/
164+02000, /*N*/
158+02000, /*O*/
129+02000, /*P*/
154+03000, /*Q*/
152+02000, /*R*/
118+02000, /*S*/
144+02000, /*T*/
158+02000, /*U*/
164+02000, /*V*/
206+02000, /*W*/
156+02000, /*X*/
150+02000, /*Y*/
146+02000, /*Z*/
0,	 /*[*/
0,	 /*\*/
0,	 /*]*/
0,	 /*^*/
200,	 /*_ dash*/
52,	 /*` open*/
94,	 /*a*/
106+02000, /*b*/
100,	 /*c*/
112+02000, /*d*/
94,	 /*e*/
66+02000, /*f*/
110+01000, /*g*/
112+02000, /*h*/
54+02000, /*i*/
62+03000, /*j*/
106+02000, /*k*/
58+02000, /*l*/
164,	 /*m*/
108,	 /*n*/
110,	 /*o*/
110+01000, /*p*/
108+01000, /*q*/
80,	 /*r*/
76,	 /*s*/
66+02000, /*t*/
108,	 /*u*/
114,	 /*v*/
164,	 /*w*/
100,	 /*x*/
111+01000, /*y*/
94,	 /*z*/
0,	 /*{*/
0,	 /*|*/
0,	 /*}*/
0,	 /*~*/
32,	 /*narrow space*/
64,	 /*hyphen*/
0,	 /*bullet*/
0,	 /*square*/
0,	 /*3/4 em*/
0,	 /*rule*/
0,	 /*1/4*/
0,	 /*1/2*/
0,	 /*3/4*/
100,	 /*minus*/
0,	 /*fi*/
0,	 /*fl*/
0,	 /*ff*/
0,	 /*ffi*/
0,	 /*ffl*/
0,	 /*degree*/
0,	 /*dagger*/
0,	 /*section*/
0,	 /*foot mark*/
0,	 /*'*/
0,	 /*`*/
0,	 /*_*/
0,	/*.=Rw+335-40*/
16,	/*half narrow space*/
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,
0,	 /*registered*/
0,	 /*copyright*/
0,
0,	 /*cent*/
};

int W2[256-32] {	/*Times Italic widths*/
188,	 /*space*/
66,	 /*!*/
0,	 /*"*/
0,	 /*#*/
100,	 /*$*/
200,	 /*%*/
150,	 /*&*/
52,	 /*' close*/
70,	 /*(*/
70,	 /*)*/
100,	 /***/
0,	 /*+*/
52,	 /*,*/
64,	 /*- hyphen*/
52,	 /*.*/
100,	 /*/*/
100+02000, /*0*/
100+02000, /*1*/
100+02000, /*2*/
100+02000, /*3*/
100+02000, /*4*/
100+02000, /*5*/
100+02000, /*6*/
100+02000, /*7*/
100+02000, /*8*/
100+02000, /*9*/
52,	 /*:*/
52,	 /*;*/
0,	 /*<*/
0,	 /*=*/
0,	 /*>*/
82,	 /*?*/
0,	 /*@*/
136+02000, /*A*/
134+02000, /*B*/
146+02000, /*C*/
158+02000, /*D*/
142+02000, /*E*/
128+02000, /*F*/
156+02000, /*G*/
162+02000, /*H*/
82+02000, /*I*/
94+02000, /*J*/
148+02000, /*K*/
138+02000, /*L*/
188+02000, /*M*/
164+02000, /*N*/
150+02000, /*O*/
118+02000, /*P*/
150+03000, /*Q*/
154+02000, /*R*/
112+02000, /*S*/
132+02000, /*T*/
154+02000, /*U*/
138+02000, /*V*/
192+02000, /*W*/
136+02000, /*X*/
136+02000, /*Y*/
140+02000, /*Z*/
0,	 /*[*/
0,	 /*\*/
0,	 /*]*/
0,	 /*^*/
200,	 /*_ dash*/
52,	 /*` open*/
100,	 /*a*/
100+02000, /*b*/
84,	 /*c*/
108+02000, /*d*/
84,	 /*e*/
66+02000, /*f*/
94+01000, /*g*/
106+02000, /*h*/
54+02000, /*i*/
50+03000, /*j*/
110+02000, /*k*/
58+02000, /*l*/
166,	 /*m*/
108,	 /*n*/
92,	 /*o*/
96+01000, /*p*/
96+01000, /*q*/
76,	 /*r*/
70,	 /*s*/
62+02000, /*t*/
110,	 /*u*/
82,	 /*v*/
128,	 /*w*/
106,	 /*x*/
90+01000, /*y*/
80,	 /*z*/
0,	 /*{*/
0,	 /*|*/
0,	 /*}*/
0,	 /*~*/
32,	 /*narrow space*/
64,	 /*hyphen*/
0,	 /*bullet*/
0,	 /*square*/
0,	 /*3/4 em*/
0,	 /*rule*/
0,	 /*1/4*/
0,	 /*1/2*/
0,	 /*3/4*/
100,	 /*minus*/
0,	 /*fi*/
0,	 /*fl*/
0,	 /*ff*/
0,	 /*ffi*/
0,	 /*ffl*/
0,	 /*degree*/
0,	 /*dagger*/
0,	 /*section*/
0,	 /*foot mark*/
0,	 /*'*/
0,	 /*`*/
0,	 /*_*/
0,		/*.=Iw+335-40*/
16,	/*half narrow space*/
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,
0,	 /*registered*/
0,	 /*copyright*/
0,
0,	 /*cent*/
};
int W3[256-32] {	/*Times Bold widths*/
198,	 /*space*/
74,	 /*!*/
0,	 /*"*/
0,	 /*#*/
100,	 /*$*/
200,	 /*%*/
158,	 /*&*/
52,	 /*' close*/
62,	 /*(*/
62,	 /*)*/
100,	 /***/
0,	 /*+*/
52,	 /*,*/
64,	 /*- hyphen*/
52,	 /*.*/
100,	 /*/*/
100+02000, /*0*/
100+02000, /*1*/
100+02000, /*2*/
100+02000, /*3*/
100+02000, /*4*/
100+02000, /*5*/
100+02000, /*6*/
100+02000, /*7*/
100+02000, /*8*/
100+02000, /*9*/
52,	 /*:*/
52,	 /*;*/
0,	 /*<*/
0,	 /*=*/
0,	 /*>*/
86,	 /*?*/
0,	 /*@*/
144+02000, /*A*/
138+02000, /*B*/
136+02000, /*C*/
154+02000, /*D*/
136+02000, /*E*/
124+02000, /*F*/
150+02000, /*G*/
170+02000, /*H*/
84+02000, /*I*/
110+02000, /*J*/
146+02000, /*K*/
132+02000, /*L*/
198+02000, /*M*/
156+02000, /*N*/
162+02000, /*O*/
134+02000, /*P*/
162+03000, /*Q*/
146+02000, /*R*/
114+02000, /*S*/
128+02000, /*T*/
154+02000, /*U*/
142+02000, /*V*/
194+02000, /*W*/
144+02000, /*X*/
144+02000, /*Y*/
138+02000, /*Z*/
0,	 /*[*/
0,	 /*\*/
0,	 /*]*/
0,	 /*^*/
200,	 /*_ dash*/
52,	 /*` open*/
96,	 /*a*/
102+02000, /*b*/
90,	 /*c*/
102+02000, /*d*/
90,	 /*e*/
68+02000, /*f*/
96+01000, /*g*/
104+02000, /*h*/
58+02000, /*i*/
64+03000, /*j*/
110+02000, /*k*/
58+02000, /*l*/
154,	 /*m*/
104,	 /*n*/
100,	 /*o*/
100+01000, /*p*/
100+01000, /*q*/
80,	 /*r*/
80,	 /*s*/
68+02000, /*t*/
104,	 /*u*/
94,	 /*v*/
136,	 /*w*/
108,	 /*x*/
104+01000, /*y*/
92,	 /*z*/
0,	 /*{*/
0,	 /*|*/
0,	 /*}*/
0,	 /*~*/
32,	 /*narrow space*/
64,	 /*hyphen*/
0,	 /*bullet*/
0,	 /*square*/
0,	 /*3/4 em*/
0,	 /*rule*/
0,	 /*1/4*/
0,	 /*1/2*/
0,	 /*3/4*/
100,	 /*minus*/
0,	 /*fi*/
0,	 /*fl*/
0,	 /*ff*/
0,	 /*ffi*/
0,	 /*ffl*/
0,	 /*degree*/
0,	 /*dagger*/
0,	 /*section*/
0,	 /*foot mark*/
0,	 /*'*/
0,	 /*`*/
0,	 /*_*/
0,		/*.=Bw+335-40*/
16,	/*half narrow space*/
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,
0,	 /*registered*/
0,	 /*copyright*/
0,
0,	 /*cent*/
};

/*
Modified for Commercial II
and with +, -, and = for equations
*/
int W4[256-32] {	/*Special font widths*/
98,	/*space*/
0,	 	/*.=Sw+042-40*/
100,	 /*"*/
0,	 /*#*/
0,0,0,0,	 	/*.=Sw+074-40*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,
200,	 /*<*/
0,	 	/*.=Sw+076-40*/
200,	 /*>*/
0,	 	/*.=Sw+100-40*/
0,	 /*@*/
0,0,0,0,0,0,0,	/*.=Sw+134-40*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,
0,	 /*\\*/
0,	 	/*.=Sw+136-40*/
0,	 /*^*/
0,	 	/*.=Sw+173-40*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,
0,	 /*{*/
0,	 	/*.=Sw+175-40*/
0,	 /*}*/
0,	 /*~*/
0,	 	/*.=Sw+220-40*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,	 /*section*/
50,	/*foot mark*/	/*.=Sw+222-40*/
0,	 /*acute accent*/
0,	 /*grave accent*/
0,	 /*underrule*/
0,	 /*slash (longer)*/
0,	 /**/
0,	 /**/
128,	 /*alpha*/
134+03000, /*beta*/
122+01000, /*gamma*/
108+02000, /*delta*/
90,	 /*epsilon*/
94+03000, /*zeta*/
122+01000, /*eta*/
112+02000, /*theta*/
72,	 /*iota*/
116,	 /*kappa*/
116+02000, /*lambda*/
132+01000, /*mu*/
112,	 /*nu*/
100+03000, /*xi*/
112,	 /*omicron*/
142,	 /*pi*/
110+01000, /*rho*/
156,	 /*sigma*/
104,	 /*tau*/
108,	 /*upsilon*/
138+03000, /*phi*/
120+01000, /*chi*/
132+03000, /*psi*/
142,	 /*omega*/
142+02000, /*Gamma*/
140+02000, /*Delta*/
154+02000, /*Theta*/
148+02000, /*Lambda*/
140+02000, /*Xi*/
160+02000, /*Pi*/
140+02000, /*Sigma*/
0,	 /**/
158+02000, /*Upsilon*/
158+02000, /*Phi*/
152+02000, /*Psi*/
156+02000, /*Omega*/
0,	 /*square root*/
0+01000, /*terminal sigma*/
0,	 /*root en*/
150,	 /*>=*/
150,	 /*<=*/
200,	 /*identically equal*/
200,	 /*minus*/
150,	 /*approx =*/
200,	 /*approximates*/
200,	 /*not equal*/
0,	 /*right arrow*/
0,	 /*left arrow*/
0,	 /*up arrow*/
0,	 /*down arrow*/
200,	 /*equal*/
200,	 /*multiply*/
200,	 /*divide*/
200,	 /*plus-minus*/
0,	 /*cup (union)*/
0,	 /*cap (intersection)*/
0,	 /*subset of*/
0,	 /*superset of*/
0,	 /*improper subset*/
0,	 /*improper superset*/
0,	 /*infinity*/
0,	 /*partial derivative*/
0+02000, /*gradient*/
0,	 /*not*/
0,	 /*integral sign*/
0,	 /*proportional to*/
0,	 /*empty set*/
0,	 /*member of*/
200,	 /*plus*/
0,
0,
0,	 /*box vert rule (was 2.)*/
0,
0,	 /*dbl dagger*/
0,	 /*right hand*/
0,	 /*left hand*/
0,	 /*math * */
0,	 /*bell system sign*/
0,	 /*or*/
0,	 /*circle*/
0,	 /*left top (of big curly)*/
0,	 /*left bottom*/
0,	 /*right top*/
0,	 /*right bot*/
0,	 /*left center of big curly bracket*/
0,	 /*right center of big curly bracket*/
0,	 /*bold vertical*/
0,	 /*left floor (left bot of big sq bract)*/
0,	 /*right floor (rb of ")*/
0,	 /*left ceiling (lt of ")*/
 }; /*right ceiling (rt of ")*/
