/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**	
**	ACSnet_SMTP derived from ACSnet_SUN
**	Peter Wishart	- Computer Science, ANU
*/

static char	sccsid[]	= "@(#)ACSnet_SMTP.c	1.01 86/04/01";

/*
**	Process messages destined for SMTP via sendmail
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	STDIO

#include	"global.h"

#include	<ctype.h>

#include	"address.h"
#include	"debug.h"
#include	"ftheader.h"
#include	"handlers.h"
#include	"header.h"
#include	"spool.h"
#include	"sub_proto.h"

/*
**	Parameters set from arguments.
*/

char *	CommandsFile;		/* Commands for files to be pre-pended to Message */
char *	Destination;		/* New destination */
Time_t	ElapsedTime;		/* Travel time for last link */
char *	HomeNode;		/* Name of this node */
char *	LinkNode;		/* Message destined to leave by this node */
char *	Message;		/* Message */
char *	Name;			/* Program invoked name */
char *	Source;			/* New source address */
int	Traceflag;		/* Global tracing control */

/*
**	ACSnet ftp handler types
*/

typedef enum
{
	mail, file, print
}
	FTP_t;;

/*
**	Miscellaneous
*/

bool	Ack;			/* This message is an acknowledgment */
char *	AckMessage	= WORKDIR(ack....message);
FthUlist *AckUsers;		/* List of recipients for sendack() */
char	Buf[BUFSIZ];		/* Transfer buffer */
char *	Descr;			/* Message description */
char *	DescrU;			/*  and in UPPER case */
char **	DestArg;		/* Address of destination in arg list */
bool	(*FuncP)();		/* Function to handler message type copy */
int	MesgFd;			/* File descriptor for Message */
int	Pid;			/* Process id */
char	ProtoType[2];		/* Header protocol type */
bool	Returned;		/* True if invoked for returned message */
char *	RouteP;			/* Pointer into re-formatted route */
Time_t	RouteTime;		/* Used in routing delay calculations */
Time_t	StartTime;		/* Start time for message from source */
Time_t	Time;			/* Invocation time */
char **	UserArg;		/* Address of user name in arg list */
VarArgs	VA;			/* Arguments for 'net' */

#define	Fprintf		(void)fprintf

void	ack_message(), copy(), filer(), finish(), net(), ret_message(), sendack();
bool	convroute(), filer1(), net1();
char	*lower();



int
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	HdrReason	reason;
	char *		cp;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Time = time((long *)0);
	Pid = getpid();

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'a':
					Destination = ++*argv;
					goto break2;

				case 'c':
					CommandsFile = ++*argv;
					goto break2;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'l':
					LinkNode = ++*argv;
					goto break2;

				case 's':
					Source = ++*argv;
					goto break2;

				case 't':
					ElapsedTime = atol(++*argv);
					break;

				default:
					Error("unrecognised flag '%c'", c);
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
		if ( Message != NULLSTR )
			Error("only one message allowed");
		else
			Message = *argv;
	}

	while ( (MesgFd = open(Message, O_READ)) == SYSERROR )
		Syserror("Can't open \"%s\"", Message);

	if ( (reason = ReadHeader(MesgFd)) != hr_ok )
		Error("Header %s error", HeaderReason(reason));

	if ( Destination != NULLSTR )
		HdrDest = Destination;
	if ( Source != NULLSTR )
		HdrSource = Source;
	StartTime = Time - (atol(HdrTt) + ElapsedTime);

	if ( (cp = GetEnv(ENV_ACK)) != NULLSTR )
	{
		free(cp);
		Ack = true;
	}

	if ( (cp = GetEnv(ENV_RETURNED)) != NULLSTR )
	{
		free(cp);
		Returned = true;
	}

	net();

	(void)unlink(Message);

	return 0;
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	(void)unlink(AckMessage);
	(void)exit(error);
}



/*
**	Look at header to find out what sort of message,
**	and call 'net1' once for each destination.
*/

void
net()
{
	register int	n;

	FIRSTARG(&VA) = "/usr/lib/sendmail";

	if ( strcmp(HdrHandler, STATEHANDLER) == STREQUAL )
	{
			return;
	}
	else
	if ( Returned || Ack || strcmp(HdrHandler, MAILHANDLER) == STREQUAL )
                filer(mail);
	else
	{
		Error("handler \"%s\" not available via SMTP", HdrHandler);
		return;
	}
	
	if ( HdrDest[0] == ATYP_BROADCAST )
		(void)net1(LinkNode);
	else
		(void)ExDests(HdrDest, net1);

	if ( FthType[0] & FTH_ACK )
		sendack();
}



/*
**	Reformat route for 'net'.
**	(Called from 'ExRoute'.)
*/

bool
convroute(tt, from, to)
	ulong	tt;
	char *	from;
	char *	to;
{
	char	time[TIME_SIZE+1];

	Trace4(3, "convroute \"%s\"-%lu-\"%s\"", from, tt, to);

	*RouteP++ = ':';
	RouteP = strcpyend(RouteP, to);
	*RouteP++ = '@';
	RouteTime += tt;
	(void)sprintf(time, "%lu", StartTime+RouteTime);
	RouteP = strcpyend(RouteP, time);

	return true;
}



/*
**	Pass copies of message to 'net' for one destination.
*/

bool
net1(dest)
	char *		dest;
{
	register int	i;
	register char *	save_home = HomeNode;

	Trace2(2, "net1 \"%s\"", dest);

	if ( strchr(dest, DOMAIN_SEP) != NULLSTR )
	{
		Error("Domain address \"%s\" cannot be interpreted by SMTP gateway", dest);
		return false;
	}

	HomeNode = dest;	/* For benefit of AtHome() */

	for ( i = 0 ; (*FuncP)(i++) ; );

	HomeNode = save_home;

	return true;
}



/*
**	Message for filer, extract files and users.
**
**	NB: will generate (files * users * destinations) messages!
*/

void
filer(type)
	FTP_t		type;
{
	FthReason	reason;

	Trace2(1, "filer %d", (int)type);

	if
	(
		(reason = ReadFtHeader(MesgFd, DataLength, !Returned)) != fth_ok
		||
		(reason = GetFthFiles()) != fth_ok
	)
		Error("File transfer header \"%s\" error", FTHREASON(reason));

	FuncP = filer1;

	Descr = "mail";
	DescrU = "MAIL";

	NEXTARG(&VA) = concat("-f", (Ack||Returned)?POSTMASTER:FthFrom, "@", HdrSource, NULLSTR);
	if (Traceflag > 2) {
		NEXTARG(&VA) = "-v";
		if (Traceflag > 3)
			NEXTARG(&VA) = "-oL100";
	}
	NEXTARG(&VA) = newstr("-u");	/* Place holder for user name */
	UserArg = &LASTARG(&VA);
}



/*
**	Files sender. Send each file for each user at HomeNode.
*/

bool
filer1(index)
	int			index;
{
	register int		i;
	register FthUlist *	up;
	register FthFD_p	fp;
	register int		user;
	register int		file;
	register long		start;

	Trace2(2, "filer1 %d", index);

	if ( index == 0 )
	{
		/*
		**	First time for this destination.
		*/

		FthToFree();

		if ( Ack || Returned )
		{
			FthUsers = Talloc(FthUlist);
			FthUsers->u_next = (FthUlist *)0;
			FthUsers->u_name = newstr(FthFrom);
			FthUsers->u_dest = NULLSTR;
			NFthUsers = 1;
		}
		else
		if ( GetFthTo() == 0 )
		{
			Error("Unrecognisable address \"%s\"", FthTo);
			return false; /* Shouldn't happen! */
		}
	}

	file = index % NFthFiles;
	user = index / NFthFiles;

	/*
	**	Find file and user, and copy file to 'fd'.
	*/

	for ( i = 0, start = 0, fp = FthFiles ; fp != (FthFD_p)0 ; fp = fp->f_next, i++ )
	{
		if ( i == file )
		{
			for ( i = 0, up = FthUsers ; up != (FthUlist *)0 ; up = up->u_next, i++ )
			{
				if ( i == user )
				{
					copy(fp, up, start);

					if ( (FthType[0] & FTH_ACK) && file == 0 )
					{
						char *	name = up->u_name;

						up = Talloc(FthUlist);
						up->u_name = name;
						up->u_dest = HomeNode;
						up->u_next = AckUsers;
						AckUsers = up;
					}

					return (bool)(index != (NFthUsers*NFthFiles-1));
				}
			}

			DODEBUG(Fatal1("Program bug, NFthUsers < 'user'"));

			return false;
		}

		if
		(
			CommandsFile == NULLSTR
			||
			!(fp->f_mode & FTH_NOT_IN_MESG)
		)
			start += fp->f_length;
	}

	DODEBUG(Fatal1("Program bug, NFthFiles < 'file'"));

	return false;
}



/*
**	Copy a file for a user to output.
*/

void
copy(fp, up, start)
	FthFD_p		fp;
	FthUlist *	up;
	long		start;
{
	register char *	cp;
	register int	n;
	register int	r;
	register long	l;
	register FILE *	fd;

	/*
	 * Homenode will be set to destination by net1 (pjw)
	 * must do this to get mutlicasts right.
	 */
	free(*UserArg);
	*UserArg = concat(up->u_name, "@", HomeNode, NULLSTR);

	fd = ExecPipe(&VA);

	if ( Ack || Returned )
		Fprintf(fd, "From %s %s", POSTMASTER, ctime(&StartTime));

	if ( Ack )
		ack_message(fd, fp);
	else
	{
		if ( Returned )
			ret_message(fd, fp);

		(void)fflush(fd);

		if
		(
			CommandsFile != NULLSTR
			&&
			(fp->f_mode & FTH_NOT_IN_MESG)
		)
			CopyFromComFile(CommandsFile, fileno(fd), "pipe", fp->f_name);
		else
		{
			if ( lseek(MesgFd, start, 0) != start )
				Syserror("Can't seek \"%s\"", Message);

			for
			(
				l = fp->f_length ;
				(r = l > sizeof Buf ? sizeof Buf : l) > 0
				&&
				(n = read(MesgFd, Buf, r)) > 0 ;
			)
			{
				l -= n;
				cp = Buf;

				while ( (r = write(fileno(fd), cp, n)) != n )
				{
					if ( r == SYSERROR )
						Syserror("Can't write to pipe");
					else
					{
						cp += r;
						n -= r;
					}
				}
			}

			if ( n == SYSERROR )
				Syserror("Can't read \"%s\"", Message);
		}
	}

	if ( (cp = ExPipeClose(fd)) != NULLSTR )
	{
		Error(cp);
		free(cp);
	}
}



/*
**	Make up message for returned files.
*/

void
ret_message(fd, fp)
	FILE *		fd;
	FthFD_p		fp;
{
	register char *	cp;
	register int	i;

	Fprintf
	(
		fd, 
		"Subject: Undelivered %s returned from %s\n\n",
		Descr,
		HdrSource
	);


	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	Fprintf
	(
		fd,
		"\n%s \"%s\" SENT TO \"%s\" RETURNED FROM \"%s\"\n",
		DescrU,
		fp->f_name,
		FthTo,
		HdrSource
	);

	if ( (cp = GetEnv(ENV_ERR1)) != NULLSTR )
	{
		Fprintf(fd, "\nFailure explanation follows :-\n");
		Fprintf(fd, "%s\n", cp);
		free(cp);
	}

	for ( i = 0 ; i < 79 ; i++ )
		putc('*', fd);

	Fprintf(fd, "\n\n");
}



/*
**	Notify sender of acknowledgement.
*/

void
ack_message(fd, fp)
	FILE *		fd;
	FthFD_p		fp;
{
	Fprintf
	(
		fd,
		"Subject: Acknowledgement received for %s sent to %s at %s\n\n",
		fp->f_name,
		FthTo,
		HdrSource
	);

	Fprintf
	(
		fd,
		"The following file has been delivered to %s at %s:\n  Mode       Size   Modify time   Name\n",
		FthTo,
		HdrSource
	);

	Fprintf
	(
		fd,
		"  0%3o %10ld %.15s %s\n",
		fp->f_mode,
		fp->f_length,
		ctime(&fp->f_time)+4,
		fp->f_name
	);
}



/*
**	Send an acknowledgement message to source.
*/

void
sendack()
{
	register FthFD_p	fp;
	register long		size;
	register FthUlist *	up;
	register char *		errs;
	int			fd;
	VarArgs			va;

	HdrEnv = MakeEnv(ENV_ACK, NULLSTR, NULLSTR);

	HdrDest = HdrSource;
	HdrSource = HomeNode;

	Time = time((long *)0);

	FthUsers = AckUsers;

	SetFthTo();

	for ( fp = FthFiles ; fp != (FthFD_p)0 ; fp = fp->f_next )
		fp->f_time = Time;

	SetFthFiles();

	while ( (fd = creat(UniqueName(AckMessage, (long)0, Time), 0600)) == SYSERROR )
		Syserror("Can't creat \"%s\"", AckMessage);

	while ( (size = WriteFtHeader(fd, (long)0, false, false)) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);

	ProtoType[0] = FTP;
	HdrSubpt = ProtoType;

	while ( WriteHeader(fd, size, 0) == SYSERROR )
		Syserror("Can't write \"%s\"", AckMessage);
	
	(void)close(fd);

	FIRSTARG(&va) = RECEIVER;
	NEXTARG(&va) = concat("-h", HomeNode, NULLSTR);
	NEXTARG(&va) = AckMessage;

	if ( (errs = Execute(&va)) != NULLSTR )
	{
		Error("Acknowledgement failed;\n%s\n", errs);
		free(errs);
		(void)unlink(AckMessage);
	}
}

char *
lower(s)
	register char *s;
{
	char *ss = s;

	while (*s) {
		if (isascii(*s) && isupper(*s))
			*s = tolower(*s);
		s++;
	}
	return (ss);
}
