/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)PrintRoute.c	1.3 86/01/05
*/

/*
**	Print routing tables in readable format.
*/

#include	<stdio.h>

#include	"global.h"
#include	"state.h"

#include	"route.h"


extern void	PrStFlags();

#define	Fprintf	(void)fprintf



void
PrintRoute(fd)
	register FILE *	fd;
{
	register int	i;
	register int	j;
	register int	k;
	register char *	cp;
	static char *	na = "* N/A *";

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
			return;

	Fprintf
	(
		fd,
		"Routing Tables for node \"%s\":\n\t%d node%s, %d link%s, %d domain%s\n",
		RT_NODE(NodeCount-1)->ne_name,
		NodeCount,
		NodeCount==1?"":"s",
		LinkCount,
		LinkCount==1?"":"s",
		DomainCount,
		DomainCount==1?"":"s"
	);

	i = fprintf(fd, "\n\t%-*s (Flags)    Spooler / Connector & Caller | Filter\n", NODE_NAME_SIZE+1, "Link") - 1 + 7;

#	if	SPRF_SIZE != 1
	i = 79;
#	endif	SPRF_SIZE != 1

	while ( --i > 0 )
		putc('_', fd);

	for ( i = 0 ; i < LinkCount ; i++ )
	{
		Fprintf(fd, "\n%d:\t%-*s", i+1, NODE_NAME_SIZE+1, RT_NODE(RT_LINK(i)->le_index)->ne_name);

		if ( j = RT_LINK(i)->le_flags )
			PrStFlags(fd, (States)j);

		if ( j = RT_LINK(i)->le_handlers[PT_MSG] )
			Fprintf(fd, " \"%s\"", &Strings[j]);
		if ( j = RT_LINK(i)->le_handlers[PT_CON] )
			Fprintf(fd, " / \"%s\"", &Strings[j]);
		if ( j = RT_LINK(i)->le_caller )
			Fprintf(fd, " & \"%s\"", &Strings[j]);
		if ( j = RT_LINK(i)->le_filter )
			Fprintf(fd, " | \"%s\"", &Strings[j]);
	}

	i = fprintf
	    (
		fd,
		"\n\n%-*s%-*s%-*s%-*sbroadcast links\n",
		NODE_NAME_SIZE+1,
		"Node",
		NODE_NAME_SIZE+1,
		"Domain",
		NODE_NAME_SIZE+1,
		"MSG via",
		NODE_NAME_SIZE+1,
		"CON via"
	    ) - 2;

#	if	SPRF_SIZE != 1
	i = 79;
#	endif	SPRF_SIZE != 1

	while ( --i > 0 )
		putc('_', fd);

	for ( i = 0, j = 0 ; i < NodeCount-1 ; i++ )
	{
		Fprintf(fd, "\n%-*s", NODE_NAME_SIZE+1, RT_NODE(i)->ne_name);

		if ( (k = RT_NODE(i)->ne_primary) == LINK_N_A )
			cp = na;
		else
			cp = RT_DOMAIN(k)->de_name;
		Fprintf(fd, "%-*s", NODE_NAME_SIZE+1, cp);

		if ( (k = RT_NODE(i)->ne_shortest[PT_MSG]) == LINK_N_A )
			cp = na;
		else
			cp = RT_NODE(RT_LINK(k)->le_index)->ne_name;
		Fprintf(fd, "%-*s", NODE_NAME_SIZE+1, cp);

		if ( (k = RT_NODE(i)->ne_shortest[PT_CON]) == LINK_N_A )
			cp = na;
		else
			cp = RT_NODE(RT_LINK(k)->le_index)->ne_name;
		Fprintf(fd, "%-*s", NODE_NAME_SIZE+1, cp);

		for ( k = 0 ; k < LinkCount ; k++, j++ )
			if ( ForwTable[j/8] & (1<<(j%8)) )
				Fprintf(fd, "%d ", k+1);
	}

	putc('\n', fd);
}
