/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetUid.c	1.9 87/11/23
*/

/*
**	Given a user name, find uid and
**	fill a structure with details from the 'passwd' file.
*/

#define	PASSWD_USED

#include	"global.h"

#include	"Passwd.h"



bool
GetUid(pp, name)
	register Passwd *pp;
	char *		name;
{
#	if	AUSAS == 1
	char		namebuf[SSIZ];
	struct pwent	pe;

	pp->P_name = name;
	pe.pw_strings[LNAME] = name;

	errno = 0;	/* Clear old error */

	while ( getpwuid(&pe, namebuf, sizeof namebuf) == PWERROR )
	{
		if ( errno != 0 )
		{
			Syserror("Can't access passwd file");
			errno = 0;
		}
		else
		{
			pwclose();
			pp->P_error = "no such user";
			return false;
		}
	}

	pwclose();

	pp->P_flags = ((pe.pw_xflags&USENET)?P_CANSEND:0)
			| ((pe.pw_xflags&USECON)?P_CANCON:0)
#			if	UNSW == 1
			| ((pe.pw_limits.l_flags&(ASYNCKILL|NOLOGIN))?0:P_CANEXEC)
#			endif
			| P_EXPLICIT | P_MULTICAST;

	pp->P_dir = newstr(pe.pw_strings[DIRPATH]);
	pp->P_shell = ((pe.pw_strings[SHELLPATH] != NULLSTR
			  && pe.pw_strings[SHELLPATH][0] != '\0')
			? newstr(pe.pw_strings[SHELLPATH])
			: NULLSTR);

	pp->P_uid = pe.pw_limits.l_uid;
	pp->P_gid = pe.pw_gid;

	if
	(
		pp->P_uid == 0
		||
		pp->P_uid == ACSNETUID
#		ifdef	NETPRIV
		||
		(pe.pw_xflags & NETPRIV)
#		endif	NETPRIV
	)
		pp->P_flags |= P_SU|P_BROADCAST|P_OTHERHANDLERS|P_CANCON|P_CANSEND|P_CANEXEC;

#	else	AUSAS == 1

	register struct passwd *pw;
	extern struct passwd *	getpwnam();

	pp->P_name = name;

	errno = 0;

	while ( (pw = getpwnam(name)) == (struct passwd *)0 )
	{
#		if	SYSTEM != 5 && !defined(perq)
		if ( errno != 0 )
		{
			Syserror("Can't access passwd file");
			errno = 0;
		}
		else
#		endif	SYSTEM != 5
		{
			endpwent();
			pp->P_error = "no such user";
			return false;
		}
	}

	endpwent();

	pp->P_uid = pw->pw_uid;
	pp->P_gid = pw->pw_gid;

#	if	MUSH == 1

	pp->P_flags = 0;

#	if	BSD4 == 2
	if ( sprivs(P_HAVEPRIVS) ) {
#	endif
		if ( testupriv(pw->pw_uid, USE_UUCP) )
			pp->P_flags |= P_CANSEND;
		if ( testupriv(pw->pw_uid, USE_REMOTE) )
			pp->P_flags |= P_CANCON;
		pp->P_flags |= P_MULTICAST|P_EXPLICIT|P_CANEXEC;
		if ( testupriv(pw->pw_uid, NET_SU) )
			pp->P_flags |=
			    P_BROADCAST|P_OTHERHANDLERS|P_SU;
#	if	BSD4 == 2
	} else
		pp->P_flags = P_CANSEND|P_CANCON|P_MULTICAST|P_CANEXEC;
#	endif

#	else	MUSH == 1

	pp->P_flags = P_CANSEND|P_CANCON|P_EXPLICIT|P_MULTICAST|P_CANEXEC;

#	endif	MUSH == 1

	if ( pw->pw_uid == 0 ||	pw->pw_uid == ACSNETUID )
		pp->P_flags |= P_BROADCAST|P_OTHERHANDLERS|P_SU;

#	endif	AUSAS == 1

	return true;
}
