#!/bin/sh

# lv   (link view)
# Redisplay ACSnet link status in display format every 2 seconds.
# Unchanged stuff is displayed normally, changed stuff goes to standout.
# Options and arguments are:
#	nn	-c time to linkstats
#	-cnn	as above
#	-x	Reverse meaning of standout (yuk)
#	host	names of hosts to look at
#	all	short repeated listing for all hosts
#	fast	just do a straight linkstats (shorter to type!)
#
# Set the environment variable 'acshost' to the link you are normally
# interested in.  The default is taken from 'link' below if you don't
# set acshost.
# Note that dis and linkstats must both be somewhere in PATH.
#
# $Header: lv,v 1.1 86/11/26 20:17:19 brian Exp $ ASO

# ------ Customizable variables ---------------------------------------
# Default link to use if acshost environment variable not set.
link=mulga
# PATH for local binaries
PATH=/usr/local/bin:/usr/contrib/bin:$PATH
# Spool directory for ACSnet
acshome=/usr/spool/ACSnet
# ------ End of customizable variables. --------------------------------

cflag=-c2
vflag=-V
dis=dis
dflag=-X
mylink=${acshost-$link}

for arg
do
	case x$arg in
	xall|xa)  type=all ;;
	xfast|xf) type=fast ;;
	x[0-9]*)  cflag=-c$arg
		  ;;
	x-c*)	  cflag=$arg
		  ;;
	x-x)	  dflag="$arg"
		  ;;
	x*)	  if [ "$args" != "" ]
		  then
			vflag=
		  fi
		  args="$args $arg"
		  ;;
	esac
done

: ${args=$mylink}

# Check that the link(s) actually exist (avoids messy linkstats/dis confusion)
for n in $args
do
	if [ ! -d $acshome/$n ]
	then
		echo "$0: no such link as $n" 1>&2
		exit 1
	fi
done

# Handle dumb terminals
case $TERM in
t3700|su|dumb)	dis="tr \014 \012"
	;;
esac

# 'exec' is useless with sh and pipes unfortunately...
case x$type in
xall)	echo "linkstats $cflag | $dis $dflag"
	exec linkstats $cflag | $dis $dflag
	;;
xfast)	echo linkstats
	exec linkstats
	;;
*)	echo "linkstats $cflag $vflag $args | $dis $dflag"
	exec linkstats $cflag $vflag $args | $dis $dflag
	;;
esac
