:
#	generates the restricted ACSnet user list and the
#	restricted ACSnet node list

PATH=/u/local:/usr/local:$PATH
export PATH

ACSNET=/u/spool/ACSnet

RESTRICTED=$ACSNET/_lib/restricted
LOCALNODES=$ACSNET/_lib/localnodes

#	Currently this means all undergraduate students...

grep '^s[789][0-9]' /etc/passwd | cut -d: -f1 | sort > $RESTRICTED

#	...can only access RMIT nodes

acsstate -B rmit | grep '^[a-z]' | sed -e 's/ //g' | sort > $LOCALNODES

#	Make the permission modes are right
#	NB: It is impolite to let users see who else is restricted
#	    (cf: quota system)
#
#	ie: This script should be mode 750, owner daemon, group daemon.

chmod 640 $RESTRICTED
chmod 644 $LOCALNODES
chown daemon $RESTRICTED $LOCALNODES
chgrp daemon $RESTRICTED $LOCALNODES
