/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Rstats.c	1.1 84/06/12
*/

/*
**	Read statistics records, and pass back fields.
*/

#define	STDIO

#include	"global.h"
#include	"stats.h"


#define	RBUFZ	512

static int	getrec();



void
Rstats(idp, funcp, fd)
	char *		idp;
	bool		(*funcp)();
	FILE *		fd;
{
	register char *	cp;
	register char *	fp;
	register int	i;
	char		buf[RBUFZ];

	while ( cp = buf, (i = getrec(cp, fd)) != EOF )
	{
		if ( *cp++ != ST_RE_SEP )
			continue;

		*idp = (char)i;
		i = 0;

		do
			if ( (fp = strchr(cp, ST_RE_SEP)) != NULLSTR )
				*fp++ = '\0';
		while
			( (*funcp)(cp, i++) && (cp = fp) != NULLSTR );
	}
}



static int
getrec(bp, fd)
	register char *	bp;
	FILE *		fd;
{
	register int	c;
	register char *	ep = bp + RBUFZ - 1;
	register char *	op = bp;
	int		id;

	do
	{
		if ( feof(fd) )
			return EOF;
		
		do
			if ( (id = getc(fd)) == EOF )
				return EOF;
		while
			( id == ST_SEP );

		while ( (c = getc(fd)) != EOF )
		{
			if ( c == ST_SEP )
				break;

			if ( bp < ep )
				*bp++ = c;
		}
	}
	while
		( op == bp );

	*bp++ = '\0';

	return id;
}
