/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)InFthTo.c	1.1 84/06/12
*/

/*
**	Search 'FthTo' list for named user, return 'true' if present.
*/

#include	"global.h"
#include	"ftheader.h"



bool
InFthTo(user)
	char *		user;
{
	register char *	s = FthTo;
	register char *	u;
	register char *	b;
	register char *	a;
	register bool	found = false;

	do
	{
		if ( (a = strchr(s, FTH_UDSEP)) != NULLSTR )
			*a = '\0';
		
		if ( (b = strchr(s, FTH_UDEST)) != NULLSTR )
		{
			*b = '\0';
			if ( !AtHome(b+1) )
				goto cont;
		}

		/*
		**	Search users at this host.
		*/

		do
		{
			if ( (u = strchr(s, FTH_USEP)) != NULLSTR )
				*u = '\0';
			
			if ( strcmp(user, s) == STREQUAL )
				found = true;

			if ( (s = u) != NULLSTR )
				*s++ = FTH_USEP;
			else
				break;
		}
		while
			( !found );

cont:
		if ( b != NULLSTR )
			*b = FTH_UDEST;

		if ( (s = a) != NULLSTR )
			*s++ = FTH_UDSEP;
		else
			break;
	}
	while
		( !found );

	return found;
}
