#define	FILE_CONTROL
#define	TERMIOCTL

#include	"global.h"
#include	"debug.h"
#include	"mailer.h"

static	int	netfd = -1;

#if	SYSTEM > 3
static	struct	termio	sb,ob;
#else
static	struct	sgttyb	sb;
#endif	SYSTEM > 3

netopen(netdevs, speed)
char	** netdevs;
short	speed;
{

	while (*netdevs != 0)
	{
		xalarm(30);
		if ((netfd = open(*netdevs, O_RDWR | O_EXCL)) != -1)
		{
			xalarm(0);
#if			SYSTEM > 3
			if (ioctl(netfd,TCGETA,&sb) == -1)
			{
				perror(*netdevs);
				return -1;
			}
			ob = sb;
			sb.c_cc[VMIN] = sb.c_cc[VTIME] = 1;
			sb.c_lflag &= ~(ISIG | ICANON | ECHO);
			sb.c_iflag = (ISTRIP | IXON | IXOFF);
			sb.c_oflag &= ~(OPOST);
			sb.c_cflag = (sb.c_cflag & ~CBAUD) | speed;
			sb.c_cflag &= ~(CSIZE | PARENB | CLOCAL | HUPCL);
			sb.c_cflag |= CS8 | CLOCAL;
			if (ioctl(netfd,TCSETAF,&sb) == -1)
			{
				perror(*netdevs);
				return -1;
			}
#else
			gtty(netfd,&sb);
			sb.sg_flags = RAW|EVENP|ODDP|TANDEM;
			sb.sg_ispeed = speed;
			sb.sg_ospeed = speed;
			stty(netfd,&sb);
#endif			SYSTEM > 3
			return netfd;
		}
		xalarm(0);
		if (timeout)
			fprintf(stderr,"Net device open timeout\n");
		else
			perror(*netdevs);
		netdevs++;
	}
	return -1;
}

netclose()
{
	if (logfp != NULL)
	{
		fprintf(logfp,"\n\n");
		fclose(logfp);
		logfp = NULL;
	}
	if (netfd == -1)
		return;
#ifdef CSIRO
	/*
	** You MUST poke csironet to avoid a hung line
	*/
	xalarm(10);
	write(netfd,DISCONNECT,strlen(DISCONNECT));
	xalarm(0);
	suckline(10);
#if	SYSTEM > 3
	sb = ob;
	ioctl(netfd,TCSETAF,&sb);
#else
	sb.sg_flags &= ~CBREAK;
	stty(netfd,&sb);
#endif	SYSTEM > 3
#endif CSIRO
	close(netfd);
}

logopen(s)
char	*s;
{
	static	char	buf[BUFSIZ];

	if ((logfp = fopen(s,"a")) == NULL)
	{
		perror(s);
		exit(1);
	}
	setbuf(logfp,buf);
}

sneakopen(s)
char	*s;
{
	static	char	buf[BUFSIZ];

	if ((sneakfp = fopen(s,"a")) == NULL)
	{
		perror(s);
		exit(1);
	}
	setbuf(sneakfp,buf);
}

fmt(s, count)
char	*s;
int	count;
{
	/* Format string for the log file */

	while(count-- != 0)
	{
		if( *s < ' ' || *s == '\177')
			switch (*s)
			{
			case '\t': putc('\t',logfp); break;
			case '\n': putc('\n',logfp); break;
			case '\b': fprintf(logfp,"\\b"); break;
			case '\r': fprintf(logfp,"\\r\n"); break;
			default:
				fprintf(logfp,"\\%c%c%c(\^%c)",
					(char) (((*s>>6)&7) + '0'),
					(char) (((*s>>3)&7) + '0'),
					(char) ((*s&7) + '0'),
					(char)(*s | 0100));
			}
		else
			putc(*s, logfp);
		s++;
	}
}

writeout(s,n)
char	*s;
int	n;
{
	static	int cycle = 0;
	int	count;
	if (n == 0)
		return(SUCCESS);
	fmt(s,n);
	Trace2(1 ,"%s", s);
	cycle += n;
	if (cycle >= 750)
	{
		/* Every now and again during sending, read line */
		fprintf(logfp,"\n<---- sucking for spurious output ---->\n");
		if ( suckline(5) == 1)
		{
			/* We should not read anything here */
			fprintf(stderr,"Got bad input during smail\n");
		}
		cycle = 0;
	}
	xalarm(30);			/* You never know where to hang */
	if ((count = write(netfd,s,n)) != n)
	{
		outcount += count;
		if (timeout)
			fprintf(stderr,"\n<----- Write timeout ----->\n");
		else
			perror("write");
		return(FAIL);
	}
	xalarm(0);
	outcount += count;
	return(SUCCESS);
}

static	char	lastc = '\0';

readc(p)
char	*p;
{
	if (timeout || read(netfd,p,1) != 1)
	{
		return(FAIL);
	}
	else
	{
		*p &= 0177;
			incount += 1;
		/*
		** Map <cr>,<nl><cr>, or <cr><nl> to just <nl>
		*/
		if (*p == '\n' && lastc == '\r')
		{
			if (timeout || read(netfd,p,1) != 1)
			{
				return(FAIL);
			}
			*p &= 0177;
		}
		else if (*p == '\r' && lastc == '\n')
		{
			if (timeout || read(netfd,p,1) != 1)
			{
				return(FAIL);
			}
			*p &= 0177;
		}

		lastc = *p;
		if (*p == '\r')
			*p = '\n';
		fmt(p,1);
		Trace2(1, "%c", *p);
		return(SUCCESS);
	}
}

xalarm(n)
int	n;
{
	static unsigned setsig = 1;

	if (setsig == 1)
	{
		signal(SIGALRM, dingdong);
		setsig = 0;
	}
	if (n != 0)
	{
		timeout = 0;
		alarmtime = n;
	}
	alarm(n);
}

dingdong()
{
	Trace1(1, "Ding dong!\n");
	fprintf(logfp,"\n<---- TIMEOUT after %d sec ------>\n",alarmtime);
	fflush(logfp);
	timeout = 1;
	signal(SIGALRM,dingdong);
}


suckline(time)
int	time;
{
	char	junk[1];
	int	val;

	val = 0;
	xalarm(time);
	fprintf(logfp,"<---- Sucking line for %d sec ---->\n",time);
	while(readc(junk) == SUCCESS)
		val = 1;
	xalarm(0);
	return(val);
}


cleanup()
{
	if (tosydfp != NULL)
	{
		fflush(tosydfp);
		fclose(tosydfp);
	}
	if (fromsydfp != NULL)
	{
		fflush(fromsydfp);
		fclose(fromsydfp);
	}
	netclose();
	exit(1);
}
sync()
{
	char c;
	c = 0;
	xalarm(10);
	while(readc(&c) == SUCCESS && c != '\n')
		xalarm(10);
	xalarm(0);
}
writesync(s,n)
char	*s;
int	n;
{
	static	int cycle = 0;
	int	count;
	if (n == 0)
		return(SUCCESS);
	Trace2(1, "%s", s);
	cycle += n;
	if (cycle >= 750)
	{
		/* Every now and again during sending, read line */
		fprintf(logfp,"\n<---- sucking for spurious output ---->\n");
		if ( suckline(5) == 1)
		{
			/* We should not read anything here */
			fprintf(stderr,"Got bad input during smail\n");
		}

		cycle = 0;
	}
	xalarm(30);			/* You never know where to hang */
	if ((count = write(netfd,s,n)) != n)
	{
		outcount += count;
		if (timeout)
			fprintf(stderr,"\n<----- Write timeout ----->\n");
		else
			perror("write");
		return(FAIL);
	}
	xalarm(0);
	outcount += count;
	return(SUCCESS);
}
