/*
**	Copyright (c) 1986 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)whois.c	1.6 87/10/26";

/*
**	Interrogate remote people list.
*/

char *	Usage	= "\"%s pattern@address\"";

#define	FILE_CONTROL
#define	STDIO

#include	"global.h"

#include	"Passwd.h"
#include	"address.h"
#include	"debug.h"
#include	"handlers.h"

#ifndef	WHOISHANDLER
#define	WHOISHANDLER	"peter"
#endif
#ifndef	MINPATTERN
#define	MINPATTERN	2
#endif

/*
**	Parameters set from arguments.
*/

char *	Name;			/* Program invoked name */
int	Traceflag;		/* Global tracing control */
char *	Addr;			/* Name of site for query */
char *	Pattern;		/* Query */

/*
**	Miscellaneous
*/

Passwd	From;			/* Details of user */
int	Pid;
Time_t	Time;

void		finish(), send();
extern char *	getenv();

#define	Fprintf	(void)fprintf



void
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	char *		cp;
	int		uid;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Time = time((long *)0);
	Pid = getpid();

	if
	(
		(uid = getuid()) != 0
		||
		(
			(cp = getenv("LNAME")) == NULLSTR
			&&
			(cp = getenv("LOGNAME")) == NULLSTR
		)
		||
		!GetUid(&From, cp)
	)
		if ( !GetUser(&From, uid) )
		{
			Error(From.P_error);
			return;
		}

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				default:
					Mesg("unrecognised flag", "'%c'", c);
					putc('\n', stderr);
					finish(1);
					return;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
		if ( Addr == NULLSTR )
			Addr = *argv;
		else
		if ( Pattern == NULLSTR )
			Pattern = *argv;
		else
		{
			Mesg("spurious argument", "\"%s\"", *argv);
			putc('\n', stderr);
			finish(1);
			return;
		}
	}

	if
	(
		Addr == NULLSTR
		||
		(
			Pattern == NULLSTR
			&&
			(
				(cp = strrchr(Addr, '@')) == NULLSTR
				||
				(*cp++ = '\0', Pattern = Addr, Addr = cp, *cp == '\0')
			)
		)
	)
	{
		finish(1);
		return;
	}

	if ( strchr(Addr, ATYP_BROADCAST) != NULLSTR )
	{
		Mesg("illegal address", "\"%s\"", *argv);
		putc('\n', stderr);
		finish(1);
		return;
	}

	if ( strlen(Pattern) < MINPATTERN )
	{
		Mesg("pattern too small", "\"%s\"", Pattern);
		putc('\n', stderr);
		finish(1);
		return;
	}

	send();

	exit(0);
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	Mesg("Usage", Usage, Name);
	putc('\n', stderr);

	(void)exit(error);
}



/*
**	Call sendfile
*/

void
send()
{
	register FILE *	fd;
	char *		errs;
	VarArgs		va;

	FIRSTARG(&va) = SEND;
	if ( Traceflag )
		NEXTARG(&va) = NumericArg('T', Traceflag);
	NEXTARG(&va) = concat("-Na", WHOISHANDLER, NULLSTR);
	NEXTARG(&va) = concat("-d", Addr, NULLSTR);
	NEXTARG(&va) = concat("-e", Pattern, ";", From.P_name, NULLSTR);

	fd = ExecPipe(&va);

	Fprintf(fd, From.P_name);	/* To be used by WHOISHANDLER in case of remote failure */

	(void)ExPipeClose(fd);		/* Any errors will be on <stderr> */
}
