/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Enter.c	1.5 88/09/05
*/

/*
**	Make an entry in a table
*/

#include	<ctype.h>
#include	<setjmp.h>

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"node.h"


jmp_buf		NameErrJmp;

static void	LegalString();



Entry *
Enter(name, table)
	char *			name;
	Entry **		table;
{
	register char *		cp1;
	register char *		cp2;
	register int		c;
	register Entry **	epp;

	LegalString(name);

#	if	DEBUG == 2
	if ( Traceflag >= 2 )
	{
		Traceflag -= 2;
		if ( Lookup(name, table) == (Entry *)0 )
			Trace(2, "\"%s\" hash = %#x", name, HashName(name));
		Traceflag += 2;
	}
#	endif	DEBUG == 2

	for
	(
		epp = &table[HashName(name)] ;
		*epp != (Entry *)0 ;
		epp = (c&1) ? &((*epp)->e_great) : &((*epp)->e_less)
	)
	{
#		if	DEBUG == 2
		if ( Traceflag >= 2 )
		{
			Traceflag -= 2;
			if ( Lookup(name, table) == (Entry *)0 )
				Trace(2, "hash duplication \"%s\"", (*epp)->e_name);
			Traceflag += 2;
		}
#		endif	DEBUG == 2

		for
		(
			cp1 = name, cp2 = (*epp)->e_name ;
			(c = *cp1++) != 0 ;
		)
			if ( (c ^= *cp2++) && c != 040 )
				break;

		if ( c == 0 && *cp2 == 0 )
			return *epp;
	}

	*epp = Talloc(Entry);

	(void)strcpy((*epp)->e_name, name);

	if ( table == NodeHash )
	{
		register Node *	np;

		(*epp)->e_node = np = Talloc(Node);
		np->n_l_last = &np->n_l_first;
		np->n_domains.d_tail = &np->n_domains.d_head;
	}

	return *epp;
}



static void
LegalString(name)
	char *		name;
{
	register char *	cp = name;
	register int	c;

	while ( c = *cp++ )
	{
		if ( !isalnum(c) && c != '_' && c != '-' )
		{
			longjmp(NameErrJmp, cp-name);
			return;
		}
	}

	if ( (c = cp-name) <= 1 || c > (NODE_NAME_SIZE+1) )
		longjmp(NameErrJmp, c+1);
}
