/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)out.c	1.12 85/10/23
*/

/*
**	Routines that deal with outgoing messages.
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"command.h"
#include	"debug.h"
#include	"spool.h"

#include	"Stream.h"
#include	"daemon.h"
#include	"driver.h"
#include	"AQ.h"
#include	"CQ.h"
#include	"bad.h"



/*
**	Start a new message on channel.
**	Discard old message desciptors, if any.
**	Find new message and send a SOM for it.
*/

void
NewMessage(chan)
	AQarg		chan;
{
	register Str_p	strp = &outStreams[(int)chan];
	register DQl_p	dqlp;
	register DQl_p	next;
	bool		update = false;
	bool		Again = false;
	bool		Unlink;

	Trace3(1, "NewMessage for channel %d state %d", (int)chan, strp->str_state);

	if ( strp->str_state != STR_ENDED && strp->str_state != STR_ERROR )
	{
		if ( strp->str_id[0] != '\0' )
			Again = true;	/* Try to send again */
		Unlink = false;		/* Commands no longer valid */
	}
	else
	if ( access(strp->str_id, 0) == SYSERROR )
		Unlink = false;		/* Commands no longer valid (possibly re-routed) */
	else
		Unlink = true;		/* Message sent ok */

	do
	{
		if ( (dqlp = strp->str_descr.dq_first) != (DQl_p)0 )
		{
			strp->str_descr.dq_first = (DQl_p)0;

			do
			{
				if ( dqlp->ql_range == 0 )
				{
					/*
					**	Special action.
					*/
					if ( dqlp->ql_base == 0 && Unlink )
						/*
						**	Unlink.
						*/
						(void)unlink(dqlp->ql_filename);
				}

				next = dqlp->ql_next;
				dqlp->ql_next = DQfreelist;
				DQfreelist = dqlp;
			}
				while ( (dqlp = next) != (DQl_p)0 );

			update = true;
		}

		if ( strp->str_descr.dq_data != NULLSTR )
		{
			free(strp->str_descr.dq_data);
			strp->str_descr.dq_data = NULLSTR;

			update = true;
		}

		if ( !Again && !FindCommand((int)chan) )
		{
			if ( strp->str_state != STR_EMPTY )
				SendMQE((int)chan);

			if ( update )
				Update(up_force);
			return;
		}

		Again = false;
		Unlink = true;
	}
		while ( !RdCommand((int)chan) );

	SendSOM((int)chan);

	Update(up_force);
}



/*
**	Read a command file into memory, and set up descriptor list.
*/

bool
RdCommand(chan)
	int		chan;
{
	register Str_p	strp = &outStreams[chan];
	struct stat	stat;

	Trace4(1, "RdCommand \"%s\" for channel %d state %d", strp->str_id, chan, strp->str_state);

    {
	register int	fd;

	if
	(
		(fd = open(strp->str_id, O_READ)) == SYSERROR
		||
		fstat(fd, &stat) == SYSERROR
		||
		stat.st_size > MAXCOMZ
		||
		stat.st_size < MINCOMZ
	)
	{
		if ( fd != SYSERROR )
			(void)close(fd);
		BadMessage((AQarg)chan, bm_size);
		return false;
	}

	strp->str_descr.dq_data = Malloc((int)stat.st_size+1);
	strp->str_time = stat.st_mtime;

	if ( read(fd, strp->str_descr.dq_data, (int)stat.st_size) != stat.st_size )
	{
		(void)close(fd);
		BadMessage((AQarg)chan, bm_read);
		return false;
	}

	(void)close(fd);
    }
    {
	register DQl_p	dqlp;
	register char *	cp;
	register Com_s	state;
	register char *	enddata;

	state = cs_fn;
	strp->str_posn = 0;
	strp->str_size = 0;
	dqlp = (DQl_p)&strp->str_descr.dq_first;
	cp = strp->str_descr.dq_data;
	enddata = &cp[stat.st_size];
	*enddata = '\0';

	do
	{
		switch ( state )
		{
		case cs_fn:
			if ( (dqlp->ql_next = DQfreelist) != (DQl_p)0 )
				DQfreelist = dqlp->ql_next->ql_next;
			else
				dqlp->ql_next = (DQl_p)Malloc(sizeof(*dqlp));

			dqlp = dqlp->ql_next;
			dqlp->ql_next = (DQl_p)0;
			dqlp->ql_filename = cp;
			dqlp->ql_base = 0;
			dqlp->ql_range = 1;	/* In case of error */
			state = cs_base;
			break;

		case cs_base:
			dqlp->ql_base = atol(cp);
			state = cs_range;
			break;

		case cs_range:
			dqlp->ql_range = atol(cp);
			strp->str_size += dqlp->ql_range;
			state = cs_fn;
			break;
		}
	}
		while ( (cp += (strlen(cp) + 1)) < enddata );
	
	if
	(
		cp != enddata
		||
		state != cs_fn
		||
		strp->str_size == 0
	)
	{
		BadMessage((AQarg)chan, bm_format);
		return false;
	}

	for ( dqlp = strp->str_descr.dq_first ; dqlp != (DQl_p)0 ; dqlp = dqlp->ql_next )
		if ( dqlp->ql_range == 0 )
		{
			/*
			**	Special command
			*/

			if
			(
				dqlp->ql_base > 0
				&&
				(strp->str_time + dqlp->ql_base) < LastTime
			)
			{
				Report2("RdCommand \"%s\" timed out", strp->str_id);
				return false;	/* Timed-out */
			}
		}
    }

    return true;
}



/*
**	Fetch stream data for a channel,
**	but first see if there are any blocked control messages to send.
**	Called from Precv().
*/

int
fillPkt(chan, data, size)
	int		chan;
	char *		data;
	int		size;
{
	register Str_p	strp = &outStreams[chan];

	Trace6
	(
		2,
		"fillPkt(%d) for channel %d state %d size %d posn %ld",
		size,
		chan,
		outStreams[chan].str_state,
		outStreams[chan].str_size,
		outStreams[chan].str_posn
	);

	if ( flushCq(chan, false) )
		return 0;

	if
	(
		strp->str_state == STR_ACTIVE
		&&
		(
			size <= strp->str_count
			||
			(size = strp->str_count) > 0
		)
	)
	for(;;)
	{
		register int	n;

		if ( (n = read(strp->str_fd, data, size)) > 0 )
		{
			outByteCount += n;
			strp->str_posn += n;
			if ( (strp->str_count -= n) == 0 )
				qAction(PosnStream, (AQarg)chan);
			return n;
		}

		if ( n == 0 )
		{
			BadMessage((AQarg)chan, bm_pastEOF);
			return 0;
		}

		Syserror("read on \"%s\" stream %d", strp->str_fname, chan);
		if ( BatchMode )
			finish(SYSERROR);

		(void)lseek(strp->str_fd, strp->str_posn, 0);
	}

	return 0;
}



/*
**	Position a stream in a message.
**	If at the end, send an EOM, set state to END.
*/

void
PosnStream(chan)
	AQarg		chan;
{
	register Str_p	strp = &outStreams[(int)chan];
	register DQl_p	dqlp;
	register long	count = 0;

	Trace3(1, "PosnStream for channel %d state %d", (int)chan, strp->str_state);

	if ( strp->str_fd > 0 )
	{
		(void)close(strp->str_fd);
		strp->str_fd = 0;
	}

	for ( dqlp = strp->str_descr.dq_first ; dqlp != (DQl_p)0 ; dqlp = dqlp->ql_next )
	{
		if ( (count += dqlp->ql_range) > strp->str_posn )
		{
			if ( (strp->str_fd = open(dqlp->ql_filename, O_READ)) == SYSERROR )
			{
				BMReason	reason;

				Report3
				(
					"cannot open message data file \"%s\" for message \"%s\""
					,dqlp->ql_filename
					,strp->str_id
				);

				strp->str_fd = 0;

				if ( access(dqlp->ql_filename, 0) == 0 )
					reason = bm_readdata;
				else
					reason = bm_nodata;

				BadMessage((AQarg)chan, reason);
				return;
			}

			strp->str_count = count - strp->str_posn;

			(void)lseek(strp->str_fd, dqlp->ql_range + dqlp->ql_base - strp->str_count, 0);

			strp->str_state = STR_ACTIVE;

			while ( Psend((int)chan) > 0 );	/* Get the ball rolling ... */

			return;
		}
	}

	if ( count < strp->str_posn )
		Fatal4
		(
			"\"posn\"(%ld) > \"size\"(%ld) for message \"%s\""
			,strp->str_posn
			,count
			,strp->str_id
		);

	/*
	**	Have reached end of message, send EOM
	*/

	SendEOM((int)chan);
}
