/*
**	boot time daemon to listen on socket for ACSnet connection
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <net/misc.h>
#include <net/in.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <sgtty.h>
#include <stdio.h>

#define	ACSNETUID	326
#define	ACSNETGID	20
#define	NICEDAEMON	-5

extern	int errno;
extern	struct passwd *getpwnam();
extern	char *raddr();

char	*rindex();

int	Traceflag;
char	*Name;

char	*Home = "/usr/spool/ACSnet/_lib";
char	*args[32] = { "PNdaemon", "-BF", (char *)0 };

int	options = SO_ACCEPTCONN|SO_KEEPALIVE;
struct	sockaddr_in sin = { AF_INET, IPPORT_ACSSERVER };
struct	sockaddr_in from;
int	fromlen = sizeof from;

int	netfd, ptyfd;
int	frompty(), fromnet();

/*#define	DEBUG	/***/

#ifdef	DEBUG
FILE	*debug;
#endif

/*
 * remote ACSnet server:
 */
main(argc, argv)
	int argc;
	char **argv;
{
	if (fork())
		exit(0);

	signal(SIGINT, 1);
	signal(SIGQUIT, 1);
	signal(SIGHUP, 1);
	signal(SIGTERM, 1);

#ifdef	DEBUG
debug = fopen("dbg.acsd", "w");
#endif
	sin.sin_port = htons(sin.sin_port);
	argc--, argv++;
	if (argc > 0 && !strcmp(argv[0], "-d")) {
		options |= SO_DEBUG;
		argc--, argv++;
	}
#ifdef DEBUG
fprintf(debug, "port=%d\n", sin.sin_port);
#endif

	for (;;) {
		errno = 0;
		netfd = socket(SOCK_STREAM, (struct sockproto *)0, &sin, options);
		if (netfd < 0) {
			perror("socket");
			sleep(5);
			continue;
		}
		bzero (&from, sizeof (from));
		if (accept(netfd, &from) < 0) {
			perror("accept");
			fprintf(stderr, "error=%d\n", errno);
			close(netfd);
			sleep(1);
			continue;
		}
		if (fork() == 0) {
			if (fork())
				exit(0);
			else {
#ifdef	DEBUG
fprintf(debug, "acsd: doit\n");
fflush(debug);
#endif
				doit(argc, argv, &from);
			}
		}
		close(netfd);
	        /* this allows init to pick up the "doit" fork */
		while (wait((int *)0) != -1)
			;
	}
}

doit(argc, argv, fromp)
	int argc;
	char **argv;
	struct sockaddr_in *fromp;
{
	register int i;
	struct	sockaddr_in from;
	int	fromlen = sizeof from;

#ifdef DEBUG
	if(close(0) < 0)
		fprintf(debug, "close 0 failed\n");
	if(close(1) < 0)
		fprintf(debug, "close 1 failed\n");
	if(close(2) < 0)
		fprintf(debug, "close 2 failed\n");
	if(dup(netfd) < 0)	/* socket becomes descriptor 0 */
		fprintf(debug, "dup 1 failed\n");
	if(dup(netfd) < 0)	/* socket becomes descriptor 1 */
		fprintf(debug, "dup 2 failed\n");
	if(dup(netfd) < 0)	/* socket becomes descriptor 2 */
		fprintf(debug, "dup 3 failed\n");
#else DEBUG
	close(0);
	close(1);
	close(2);
	dup(netfd);
	dup(netfd);
	dup(netfd);
#endif DEBUG
	if (chdir(Home) < 0) {
		perror(Home);
		exit(9);
	}
	fromp->sin_port = htons((unsigned short)fromp->sin_port);
	Name = raddr(fromp->sin_addr.s_addr);
#ifdef DEBUG
	fprintf(debug ,"connection from %s\n", Name);
	fflush(debug);
#endif DEBUG

	if (fromp->sin_family != AF_INET || (Name == 0))
		fatal(netfd, "Permission denied");
#	ifdef	NICEDAEMON
	(void)nice(NICEDAEMON);
#	endif	NICEDAEMON

	(void)setgid(ACSNETGID);
	(void)setuid(ACSNETUID);

	if ( DaemonActive(".", 0) ) {
#ifdef DEBUG
		fprintf(debug, "Daemon is already active, exiting.\n");
fflush(debug);
#endif DEBUG
		fflush(stdout);
		exit(7);
	}

	if (argc > 1) {
		for (i = 1; i < argc; i++) {
			args[i-1] = argv[i];
#ifdef DEBUG
fprintf(debug, "args[%d] = %s\n", i-1, args[i-1]);
fflush(debug);
#endif
		}
		args[i] = Name;
#ifdef DEBUG
fprintf(debug, "args[%d] = %s\n", i-1, args[i-1]);
fflush(debug);
#endif
		args[i+1] = (char *)0;
	} else {
		args[2] = Name;
		args[3] = (char *)0;
#ifdef DEBUG
fprintf(debug, "ARGS[2] = %s\n", args[2]);
fflush(debug);
#endif
	}

	(void)execv(args[0], args);
	Syserror(args[0]);
	exit (6);

}

finish(code)
int	code;
{
	exit(code);
}

cleanup()

{
	int how = 2;

	ioctl(netfd, SIOCDONE, &how);
	exit(1);
}

bzero(p, n)
register char *p;
register unsigned n;
{
	if (n)
		do
			*p++ = 0;
		while (--n);
}

#ifdef	DEBUG
/*ARGSUSED*/
#endif
fatal(netfd, msg)
	int netfd;
	char *msg;
{
#ifndef	DEBUG
	char buf[BUFSIZ];

	buf[0] = '\01';		/* error indicator */
	sprintf(buf + 1, "acsd: %s.\n", msg);
	write(netfd, buf, strlen(buf));
#else
	fprintf(debug, "acsd: fatal error: msg='%s'\n", msg);
	fflush(debug);
#endif
	exit(1);
}

