/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ticks.c	1.7 86/06/13
*/

/*
**	Fetch system time in ticks, if possible.
*/

#ifndef	GLBOLT
#define	TIMES
#define	NEED_HZ

#include	"global.h"

#if	BSD4 >= 2
#include	<sys/time.h>
#endif	BSD4 >= 2



Time_t
ticks()
{
#	if	SYSTEM > 0
	Timesbuf	stimes;

	return (Time_t)times(&stimes);

#	else	SYSTEM > 0

#	if	BSD4 >= 2
	struct timeval	tv;

	(void)gettimeofday(&tv, (struct timezone *)0);

	return (Time_t)(((tv.tv_sec*1000000 + tv.tv_usec) * HZ) / 1000000);

#	else	BSD4 >= 2

	return time((long *)0) * HZ;

#	endif	BSD4 >= 2
#	endif	SYSTEM > 0
}

#else	GLBOLT

_ticks(){}

#endif	GLBOLT
