/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetRaw.c	1.21 89/02/25
*/

/*
**	Set RAW mode on 'tty' link
*/

#define	TERMIOCTL

#include	"global.h"
#include	"debug.h"


#if	V8
extern int	tty_ld;
extern int	ntty_ld;
#endif	V8


int
SetRaw(fd, speed, minchars, mintime, xon_xoff)
	int	fd;
	int	speed;
	int	minchars;
	int	mintime;
	bool	xon_xoff;
{
#	if	SYSTEM < 3
	struct sgttyb	params;

	Trace3(2, "SetRaw speed=%d, xon_xoff=%d", speed, xon_xoff);

	if ( gtty(fd, &params) == SYSERROR )
		return 0;

	if ( speed )
		params.sg_ispeed = params.sg_ospeed = speed;
	else
		speed = params.sg_ispeed;

	if ( xon_xoff )
	{
		params.sg_flags = EVENP|ODDP
#				ifdef	CBREAK
				  |CBREAK
#				endif	CBREAK
#				ifdef	TANDEM
				  |TANDEM
#				endif	TANDEM
				  ;
#		if	V8 == 1
		if
		(
			(minchars = ioctl(fd, FIOLOOKLD, (struct sgttyb *)0)) != tty_ld
			&&
			minchars != ntty_ld
		)
			(void)ioctl(fd, FIOPUSHLD, (struct sgttyb *)&tty_ld);
#		endif	V8 == 1
	}
	else
	{
		params.sg_flags = RAW;

#		if	V8 == 1
		if
		(
			(minchars = ioctl(fd, FIOLOOKLD, (struct sgttyb *)0)) == tty_ld
			||
			minchars == ntty_ld
		)
			(void)ioctl(fd, FIOPOPLD, (struct sgttyb *)0);
#		endif	V8 == 1
	}

	if ( stty(fd, &params) == SYSERROR )
		Syserror("SetRaw \"stty\"");

#	else	SYSTEM < 3
	/*
	**	Some SYSTEM xx don't do system calls to stack very well
	**	(part of this comment has been censored)
	**	and hence the need for the following ``static''.
	*/
	static struct termio	params;

	Trace5(2, "SetRaw speed=%d, minch=%d, mintim=%d, xon_xoff=%d", speed, minchars, mintime, xon_xoff);

	if ( ioctl(fd, TCGETA, &params) == SYSERROR )
		return 0;

	params.c_iflag &= ~(ISTRIP|IUCLC|INLCR|ICRNL|IGNCR|IXON|IXOFF|IXANY|INPCK|BRKINT|PARMRK);
	params.c_iflag |= IGNBRK|IGNPAR;
	if ( xon_xoff )
		params.c_iflag |= IXON|IXOFF;

	params.c_oflag &= ~OPOST;

	if ( speed == 0 )
		speed = params.c_cflag & CBAUD;

	params.c_cflag &= ~(PARENB|CBAUD);
	params.c_cflag |= speed|CREAD|CS8;

	params.c_lflag = 0;

	params.c_cc[VMIN] = minchars == 0 ? 1 : minchars;
	params.c_cc[VTIME] = mintime;

	if ( ioctl(fd, TCSETAF, &params) == SYSERROR )
		Syserror("SetRaw(TCSETAF)");

#	endif	SYSTEM < 3

	Trace2(2, "SetRaw returns %d", speed);

	return speed;
}
