/*
**	Copyright (c) 1986 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)FreeHeader.c	1.3 89/10/30
*/

/*
**	Clear any "Malloc"ed fields in Header records.
*/

#include	"global.h"
#include	"header.h"
#include	"debug.h"



void
FreeHeader()
{
	register char *		cp;
	register int		i;
	register char *		head;
	register char *		tail;
#	if	APOLLO == 0
	extern char		end;
#	endif	/* APOLLO == 0 */

	Trace2(1, "FreeHeader 0x%lx", Header);

	if ( (head = Header) == NULLSTR )
		return;

	if ( (tail = HeaderEnd) < head )
		return;

#	if	APOLLO == 0
	for ( i = NHDRFIELDS ; --i >= 0 ; )
		if
		(
			(cp = HdrFields.hf_start[i]) != NULLSTR
			&&
			cp >= &end
			&&
			(cp < head || cp >= tail)
		)
		{
			Trace2(3, "FreeHeader 0x%lx", cp);
			free(cp);
			HdrFields.hf_start[i] = NULLSTR;
		}
#	endif	/* APOLLO == 0 */

	free(head);
	Header = NULLSTR;
	HeaderEnd = NULLSTR;
}
