/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)statefile.h	1.7 85/08/10
*/

/*
**	The state file is an ascii file, except for the last line,
**	which contains the bytes:-
**		C_EOF
**		LOCRC
**		HICRC
**		'\n'
**
**	The CRC checks all the bytes on the preceding lines.
*/

/*
**	Separators used between tokens in state file.
*/

#define	TOKEN_SIZE	127

typedef enum
{
	t_domhier, t_domain, t_othdom, t_topdom,
	t_alias, t_aliasv, t_xalias,
	t_node, t_nflags, t_comment, t_state, t_nodehier,
	t_connector, t_spooler, t_caller, t_handler,
	t_date, t_sent, t_recvd, t_passto, t_passfrom,
	t_link, t_lflags, t_cost, t_speed, t_time, t_bytes,
	t_eof, t_any, t_foreign, t_ignore, t_null
}
			Token;

#define	C_ALIAS		'~'
#define	C_ALIASV	'^'
#define	C_BYTES		'='
#define	C_CALLER	'\\'
#define	C_COMMENT	'"'
#define	C_CONNECTOR	'&'
#define	C_COST		'$'
#define	C_DATE		'@'
#define	C_DOMAIN	'|'
#define	C_DOMHIER	';'
#define	C_EOF		'#'
#define	C_HANDLER	'%'
#define	C_LFLAGS	'`'
#define	C_LINK		','
#define	C_NFLAGS	'\''
#define	C_NODE		'\n'
#define	C_NODEHIER	'+'
#define	C_OTHDOM	']'
#define	C_PASSFROM	'<'
#define	C_PASSTO	'>'
#define	C_RECVD		'{'
#define	C_SENT		'}'
#define	C_SPEED		'*'
#define	C_SPOOLER	'!'
#define	C_STATE		'?'
#define	C_TIME		':'
#define	C_TOPDOM	'['
#define	C_XALIAS	'/'

#define	C_SPARE1	'('
#define	C_SPARE2	')'

/*
**	Control type of statefile
*/

typedef enum
{
	t_local, t_export, t_allexport
}
			Export_t;

/*
**	Miscellaneous variables
*/

extern bool		ChangeState;		/* True if vital info. about Home has changed and should be propagated */
extern bool		AnteState;		/* True if state info. is out-of-date */
