/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ReadState.c	1.2 84/10/02
*/

/*
**	Open state file, read it, and return file descriptor.
**	If 'update' is false, file is closed.
*/

#define	LOCKING
#define	STDIO

#include	"global.h"


static char *	StateFile;

extern void	Rstate();


FILE *
ReadState(update, ignCRC)
	Lock_t		update;
	bool		ignCRC;
{
	register FILE *	fd;

	if ( StateFile == NULLSTR )
		StateFile = STATEFILE;

	if ( (fd = fopen(StateFile, update?"r+":"r")) != NULL )
	{
#		if	AUTO_LOCKING != 1
		if ( Lock(StateFile, fileno(fd), update) == SYSERROR )
		{
			Syserror("Can't lock \"%s\"", StateFile);
			return NULL;
		}
#		endif	AUTO_LOCKING
	
		Rstate(fd, false, NULLSTR, (Time_t)0, ignCRC);

		if ( update )
			rewind(fd);
		else
		{
#			if	AUTO_LOCKING != 1
			UnLock(fileno(fd));
#			endif	AUTO_LOCKING
			(void)fclose(fd);
		}

		return fd;
	}

	Syserror("Can't open \"%s\"", StateFile);

	return NULL;
}



void
SetState(newfile)
	char *	newfile;
{
	StateFile = newfile;
}
