/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)HomeDomain.c	1.1 84/06/12
*/

/*
**	Return true if we belong to "domain".
**	Relies on fact that HomeNode is last node in NodeTable,
**	and route to any of our domains is via us.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"



bool
HomeDomain(domain, handler)
	char *		domain;
	char **		handler;
{
	NodeLink	route;

	if ( !FindDomain(domain, &route) )
		return false;
	
	if ( route.nl_link != (NodeCount-1) )
		return false;
	
	if ( route.nl_spooler != NULLSTR )
		*handler = route.nl_spooler;

	return true;
}
