/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)global.h	1.13 84/10/29
*/

/*
**	Include local peculiarities here.
*/

#include	"site.h"

/*
**	Site definitions consistency checks
*/

#if	SYSTEM >= 3
#undef	FCNTL
#define	FCNTL		1
#undef	GETHOST
#define	GETHOST		0
#undef	KILL_0
#define	KILL_0		1
#undef	OLD_CC
#define	OLD_CC		0
#undef	PGRP
#define	PGRP		1
#undef	PRINTF_NULLS
#define	PRINTF_NULLS	1
#undef	SPRF_SIZE
#define	SPRF_SIZE	1
#undef	UNAME	
#define	UNAME		1
#endif	SYSTEM >= 3

#if	!defined(FUZZ) && !defined(NCC_MANAGER) && !defined(NCC_MANA)
	*** You must define one or both of the above ***
#endif

#if	BSD4 > 0 && SYSTEM > 0
	*** You can't define both of the above ***
#endif

/*
**	Global definitions for network that should not be changed
*/

#define	CRC_SIZE	sizeof(Crc_t)		/* Number of bytes in CRC */
#define	LENGTH_SIZE	11			/* Maximum bytes in an ASCII length field */
#define	MAX_MESG_DATA	200000L			/* Maximum size of data part of a message */
#define	MAX_REROUTE_WAIT (30*60)		/* Maximum wait time for message in re-route directory */
#define	NODE_NAME_SIZE	15			/* Maximum length of a node's name */
#define	TIME_SIZE	10			/* Maximum number of digits in a time */
#define	UID_LENGTH	3			/* Number of digits in a uid */
#define	UNIQUE_NAME_LENGTH 11			/* Minimum length for last component of argument to UniqueName() */
						/* UID_LENGTH + UNIQUE_NAME_LENGTH must be <= DIRSIZ */

#define	CHST_TTD	(30*60)			/* Time-to-die for state up/down messages */

/*
**	Global definitions for C programming
*/

#define	Talloc(T)	(T*)Malloc(sizeof(T))
#define	SYSERROR	(-1)
#define	NULLSTR		(char*)0
#define	NULLFUNCP	(Funcp)0
#define	NULLVFUNCP	(vFuncp)0
#define	STREQUAL	0
#define	Extern		extern			/* Redefined to <null> to declare a global object */

#ifdef	GLBOLT
#define	ticks()		glbolt()
#endif	GLBOLT

#if	KILL_0 == 1
#define	SIG0		0
#else
#define	SIG0		SIGINT
#endif

#if	OLD_CC == 1
#define	void		int
#define	ulong		long
#define	BYTE(A)		((A)&0xff)
#else
typedef unsigned long	ulong;
#define	BYTE(A)		(((unsigned char *)&(A))[0])
#endif

#define	LOCRC(A)	((A)&0xff)
#define	HICRC(A)	(((A)>>8)&0xff)

#ifdef	EBUG
#define	DEBUG		EBUG
#else
#define	DEBUG		0
#endif

/*
**	Type definitions for C programming
*/

typedef ulong		Time_t;
typedef	unsigned short	Crc_t;
typedef int		(*Funcp)();
typedef void		(*vFuncp)();
typedef enum { false = 0, true = 1 } bool;
typedef enum { for_reading, for_writing } Lock_t;

/*
**	Type definition for variable argument parameters
*/

#define	MAXVARARGS	20

typedef struct
{
	int	va_count;
	char *	va_args[MAXVARARGS+1];
}
			VarArgs;

#define	ARG(A,N)	(A)->va_args[N]
#define	FIRSTARG(A)	(A)->va_args[(A)->va_count=1,0]
#define	LASTARG(A)	(A)->va_args[(A)->va_count-1]
#define	NARGS(A)	(A)->va_count
#define	NEXTARG(A)	(A)->va_args[(A)->va_count++]

#ifdef	RECOVER

/*
**	Type definition for error recovery
*/

typedef enum { ert_finish, ert_here, ert_return } ERC_t;

#include	<setjmp.h>

extern jmp_buf		ErrBuf;
extern ERC_t		ErrFlag;

#define	Recover(T)	(ErrFlag=T,((T==ert_here)?setjmp(ErrBuf):0))

#endif	RECOVER

/*
**	System include file control
*/

#ifdef	NEED_HZ
#if	BSD4 < 1 || (BSD4 == 1 && BSD4V != 'c')
#include	<sys/param.h>
#endif	BSD4
#ifndef	HZ
#define	HZ	50		/* A stab in the dark */
#endif
#endif	NEED_HZ

#ifdef	FILE_CONTROL
#if	FCNTL == 1
#if	BSD4 < 2
#include	<fcntl.h>	/* O_XXX definitions live here */
#else	BSD4 < 2
#include	<sys/file.h>	/* O_XXX definitions live here */
#endif	BSD4 < 2
#else	FCNTL == 1
#if	BSD4 > 0
#ifndef	O_RDWR
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	major
#endif
#include	<sys/file.h>	/* O_XXX definitions live here */
#endif	O_RDWR
#if	BSD4 < 2
#undef	O_EXCL			/* Does the wrong thing */
#endif	BSD4 < 2
#else	BSD4 > 0
#define	O_READ		0
#define	O_WRITE		1
#define	O_RDWR		2
#define	O_APPEND	0
#endif	BSD4 > 0
#ifndef	O_EXCL
#define	O_EXCL		0
#endif	O_EXCL
#endif	FCNTL == 1
#ifndef	O_READ
#define	O_READ	O_RDONLY
#endif
#ifndef	O_WRITE
#define	O_WRITE	O_WRONLY
#endif
#endif	FILE_CONTROL

#ifdef	STAT_CALL
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	major
#endif
#include	<sys/stat.h>	/* Definition of stat structure */
#endif	STAT_CALL

#ifdef	PASSWD_USED
#if	AUSAS == 1
#undef	SYSERROR
#include	<local-system>
#include	<passwd.h>
#else	AUSAS == 1
#include	<pwd.h>
#if	MUSH == 1
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif
#endif	major
#if	BSD4 > 1
#include	<sys/privs.h>
#endif	MSD4 > 1
#include	<udata.h>
#endif	MUSH == 1
#endif	AUSAS == 1
#endif	PASSWD_USED

#ifdef	STDIO
#include	<stdio.h>
#endif	STDIO

#ifdef	SMDATE
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	major
#endif
#endif	SMDATE

#ifdef	TIMES
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	major
#endif
#include	<sys/times.h>
typedef struct tms	Timesbuf;
#endif	TIMES

#ifdef	TERMIOCTL
#if	SYSTEM >= 3
#include	<termio.h>
#else	SYSTEM >= 3
#include	<sgtty.h>
#endif	SYSTEM >= 3
#endif	TERMIOCTL

#ifdef	TTYCONNECT
#if	AUSAS == 1
#include	<sys/ttyconnect.h>
#else	AUSAS == 1
#define	CONNECT	0
#undef	TTYCONNECT
#endif	AUSAS == 1
#endif	TTYCONNECT

/*
**	Definitions conditional on above.
*/

#if	AUTO_LOCKING == 1
#define	Lock(A,B,C)	(C==for_reading?readlock(B):writelock(B))
#define	UnLock(B)	unlock()
#else	AUTO_LOCKING == 1
#if	FLOCK == 1
#if	defined(LOCKING) && !defined(FEXLOCK) && !defined(LOCK_EX)
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	major
#endif
#include	<sys/file.h>
#ifndef	O_READ
#define	O_READ	O_RDONLY
#endif
#ifndef	O_WRITE
#define	O_WRITE	O_WRONLY
#endif
#endif	defined(LOCKING) && !defined(FEXLOCK) && !defined(LOCK_EX)
#if BSD4 == 1 && BSD4V == 'c'
#define	Lock(A,B,C)	flock(B,C==for_writing?FEXLOCK:FSHLOCK)
#define	UnLock(B)
#else
#define	Lock(A,B,C)	flock(B,C==for_writing?LOCK_EX:LOCK_SH)
#define	UnLock(B)	flock(B, LOCK_UN)
#endif	BSD4 && BSD4V
#else	FLOCK == 1
#if	UNISOFT_LOCKS == 1
#define	Lock(A,B,C)	locking(B,1,0)
#define	UnLock(B)	locking(B,0,0)
#else	UNISOFT_LOCKS
#define	Lock(A,B,C)	_Lock(A,C)
#define	UnLock(B)	_UnLock()
#endif	UNISOFT_LOCKS
#endif	FLOCK == 1
#endif	AUTO_LOCKING == 1

/*
**	Network library routines
*/

extern int
		_Lock(),
		SetRaw();

extern bool
		DaemonActive(),
		ErrorTty(),
		InList(),
		ReadCom(),
		SetDaemonActive(),
		crc();

extern Crc_t
		acrc();

extern char
		*Execute(),
		*ExPipeClose(),
		*ExOPipeClose(),
		*ExpandString(),
		*GetErrFile(),
		*Malloc(),
		*MatchString(),
		*NodeName(),
		*ReadFile(),
		*StripErrString(),
		*TimeString(),
		*UniqueName(),
		*UniqueUid(),
		*Version,
		*concat(),
		*newstr(),
		*newnstr(),
		*strclr(),
		*strcpyend();

extern void
		_UnLock(),
		AddCom(),
		CopyFile(),
		CopyFromComFile(),
		EchoArgs(),
		Error(),
		ExpandArgs(),
		FreeCom(),
		Mesg(),
		SMdate(),
		SetUser(),
		SplitArg(),
		SysWarn(),
		Syserror(),
		Warn();

#ifdef	BUFSIZ
extern FILE	*ExecPipe();
extern FILE	*ExPipeO();
#endif	BUFSIZ

/*
**	C-library routines
*/

extern int	errno;

extern char
		*bsearch(),
		*ctime(),
		*malloc(),
		*strcat(),
		*strchr(),
		*strcpy(),
		*strncpy(),
		*strpbrk(),
		*strrchr(),
		*strrpbrk(),
		*strtok();

extern long
		atol(),
		lseek();

extern ulong
		time(),
		times();
