/* Analyse current status of all physical disks,                             */
/* ~ param1 = [logfile name]~                                                */
/* partition tables and partition format information                         */
/* Then, for all HPFS partitions, show basic information                     */
/* and find the Root-directory and Codepage info without                     */
/* using the superblock or spareblock pointers                               */
/* All results will be contained in the logfile DFSINFO.LOG                  */
/*                                                                           */
/* JvW 01-02-2002 added quotes to external calls and '-7 -a' switches   4.15 */
/* JvW 05-05-2002 Fixed SYS002 errors when old logfile not present      4.22 */
/* JvW 05-11-2002 Updated for executable naming DFSOS2.EXE (WATCOM)     5.05 */
/* JvW 28-01-2003 Updated for new PART option syntax                    5.11 */

   Parse Source with . myself .

   Parse Arg logname
   if logname = '' then
   do
      logname = 'dfsinfo.log'
   end

   if Address() <> 'DFS' then
   do
      Say 'Running DFSINFO (may take a long time!) ...'
      Say ''
      Address cmd '@dfsos2.exe -R -7 -a -b -q -w- -Q run -q' myself logname
      Say ''
      Say 'Done, output is in DFSINFO.LOG'
   end; else
   do
      Address cmd '@if exist' logname 'del' logname
      '@log' logname
      'about -P-'

      say date('E') time()' : Gathering diagnostic information; Please wait ...'
      say ''
      'close'                                   /* release physical disks    */

      say date('E') time()' : ' ||,
          'First get the standard available stuff ...'
      'cmd -B "fdisk /query"'
      if rc = 1 then
      do
         'cmd -B "lvm /query:all"'
      end
      'cmd -B "setboot /query"'

      say date('E') time()' : ' ||,
          'Now use our own built-in diagnostic power ...'

      'map'
      'part'
      'part -ebr -p-'
      'part -warnings -ebr -numeric'
      'disk 0'
      'pl lvm'

      'query disks'
      physdisks = rc
      say 'physdisks: ' physdisks

      do i=1 to physdisks
         Say ''
         Say 'MBR/EBR chain for disk nr' i
         'walk' i                               /* select next disk and show */
      end                                       /* it's MBR/EBR chain        */

      'part -Verbose -alloc -check'             /* show max partition info   */

      'query part'
      partitions = rc
      say date('E') time()' : partitions: ' partitions

      do i=1 to partitions
         'part' i                               /* select next partition     */

         Say ''
         say date('E') time()' : ' ||,
             'Working on partition' i '=' dfs_drive 'on disk' dfs_disknr
         if substr(dfs_drive,2,1)=':' & translate(dfs_drive) == dfs_drive then
         do
            Say ''
            Say 'Running CHKDSK on the partition ...'
            'cmd chkdsk' dfs_drive '< dfsinfo.inp'

            Say ''
            Say 'Attempt a normal directory of its root directory'
            'cmd set dircmd=/O:GNE'             /* discard DIRCMD's like /P  */
            'cmd dir' dfs_drive'\'
         end

         Say ''
         select
         when substr(dfs_afsys,1,4) = 'HPFS' then
            do
               Say ''
               say date('E') time()' : ' ||,
                   'Running some DFS HPFS diagnostics ...'
               '0'
               't H'
               ' '
               ' '
               ' '
               '11'
               't H'
               ' '
               ' '
               '0'
               '\'
               ' '
               ' '
               ' '
               '0'
               'f c'
               ' '
               'dirmap'
               'alloc'
            end
         when substr(dfs_afsys,1,4) = 'NTFS' then
            do
               say date('E') time()' : ' ||,
                   'Running some DFS NTFS diagnostics ...'
               ' '
               if translate(dfs_drive) == dfs_drive then
               do
                  '0'
                  ' '
                  ' '
                  ' '
                  ' '
                  ' '
                  ' '
                  ' '
                  ' '
                  ' '
                  ' '
               end
            end
         when substr(dfs_afsys,1,3) = 'FAT' then
            do
               say date('E') time()' : ' ||,
                   'Running some DFS FAT diagnostics ...'
               ' '
               if translate(dfs_drive) == dfs_drive then
               do
                  'x'
                  'alloc'
                  'fatshow'
               end
            end
         otherwise
            say date('E') time()' : ' ||,
                'No specific diagnostics for filesystem' dfs_afsys '(yet).'
            't H'
         end
      end
      say date('E') time()': Gathering diagnostic information finished.'
      '@log'                                    /* close the log file        */
   end
exit 0
